/*
 * Decompiled with CFR 0.152.
 */
package com.MedInsuranceV2.Version20.Claim;

import com.MedInsuranceV2.Version20.Claim.Claim;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.element.BlockElement;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.properties.UnitValue;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class PdfGeneratorService {
    public byte[] generateClaimPdf(List<Claim> claims) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PdfWriter writer = new PdfWriter((OutputStream)baos);
        PdfDocument pdf = new PdfDocument(writer);
        Document document = new Document(pdf);
        document.add((IBlockElement)((Paragraph)new Paragraph("Claim Details").setFontSize(20.0f)).setBold());
        document.add((IBlockElement)new Paragraph(" "));
        Table table = new Table(UnitValue.createPercentArray((float[])new float[]{1.0f, 2.0f}));
        table.setWidth(UnitValue.createPercentValue((float)100.0f));
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd-MM-yyyy");
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss");
        for (Claim claim : claims) {
            this.addTableRow(table, "Claim ID:", String.valueOf(claim.getId()));
            this.addTableRow(table, "Claim Number:", claim.getClaimNumber());
            this.addTableRow(table, "Insurance Name:", claim.getInsuranceName());
            this.addTableRow(table, "Admin Notes:", claim.getAdminNotes());
            this.addTableRow(table, "Customer Email:", claim.getCustomerEmail());
            this.addTableRow(table, "Customer Name:", claim.getCustomerName());
            this.addTableRow(table, "Customer Phone:", claim.getCustomerPhone());
            this.addTableRow(table, "Filing Date:", claim.getFilingDate() != null ? LocalDateTime.ofInstant(claim.getFilingDate().toInstant(), ZoneId.systemDefault()).format(dateTimeFormatter) : "N/A");
            this.addTableRow(table, "Incident Date:", claim.getIncidentDate() != null ? LocalDateTime.ofInstant(claim.getIncidentDate().toInstant(), ZoneId.systemDefault()).format(dateFormatter) : "N/A");
            this.addTableRow(table, "Reason:", claim.getReason());
            this.addTableRow(table, "Status:", claim.isApproved() ? "Approved" : "Not Approved");
        }
        document.add((IBlockElement)table);
        document.close();
        return baos.toByteArray();
    }

    private void addTableRow(Table table, String header, String value) {
        table.addCell((BlockElement)new Paragraph(header).setBold());
        table.addCell((BlockElement)new Paragraph(value));
    }
}

