/*
 * Decompiled with CFR 0.152.
 */
package com.MedInsuranceV2.Version20.Email;

import com.MedInsuranceV2.Version20.Email.OtpService;
import com.MedInsuranceV2.Version20.User.User;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.springframework.stereotype.Service;

@Service
public class OtpService {
    private static final Map<String, OtpEntry> otpStore = new HashMap();
    private static final long OTP_VALIDITY_MS = 300000L;

    public String generateAndStoreOtp(String email, User user) {
        String otp = String.format("%06d", new Random().nextInt(1000000));
        long expiryTime = System.currentTimeMillis() + 300000L;
        otpStore.put(email, new OtpEntry(otp, expiryTime, user));
        System.out.println("Generated OTP for " + email + ": " + otp + " (Valid until: " + String.valueOf(new Date(expiryTime)) + ")");
        return otp;
    }

    public boolean validateOtp(String email, String enteredOtp) {
        OtpEntry storedOtpEntry = (OtpEntry)otpStore.get(email);
        if (storedOtpEntry == null) {
            System.out.println("Validation failed for " + email + ": No OTP found.");
            return false;
        }
        if (System.currentTimeMillis() > storedOtpEntry.expiryTime) {
            otpStore.remove(email);
            System.out.println("Validation failed for " + email + ": OTP expired.");
            return false;
        }
        boolean isValid = storedOtpEntry.otp.equals(enteredOtp);
        if (!isValid) {
            System.out.println("Validation failed for " + email + ": OTP mismatch. Expected " + storedOtpEntry.otp + ", Got " + enteredOtp);
        } else {
            System.out.println("Validation successful for " + email);
        }
        return isValid;
    }

    public User getPendingUser(String email) {
        OtpEntry storedOtpEntry = (OtpEntry)otpStore.get(email);
        if (storedOtpEntry != null && System.currentTimeMillis() <= storedOtpEntry.expiryTime) {
            System.out.println("Retrieved pending user for " + email);
            return storedOtpEntry.pendingUser;
        }
        System.out.println("Could not retrieve pending user for " + email + ": OTP expired or not found.");
        return null;
    }

    public void removeOtp(String email) {
        otpStore.remove(email);
        System.out.println("Removed OTP and pending user data for " + email);
    }

    public void clearOtp(String emailId) {
        otpStore.remove(emailId);
        System.out.println("Cleared OTP for " + emailId);
    }
}

