/*
 * Decompiled with CFR 0.152.
 */
package com.MedInsuranceV2.Version20.PDF;

import com.MedInsuranceV2.Version20.BoughtInsurance.BoughtInsurance;
import com.MedInsuranceV2.Version20.BoughtInsurance.BoughtInsuranceService;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PdfReportService {
    @Autowired
    private BoughtInsuranceService boughtInsuranceService;

    public byte[] generateAllBoughtInsurancesPdf(String planName) throws DocumentException {
        List allBoughtInsurances = planName != null && !planName.trim().isEmpty() ? this.boughtInsuranceService.getBoughtInsurancesByInsurancePlanName(planName) : this.boughtInsuranceService.getAllBoughtInsurances();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Document document = new Document();
        PdfWriter.getInstance((Document)document, (OutputStream)baos);
        document.open();
        Font titleFont = FontFactory.getFont((String)"Helvetica-Bold", (float)20.0f, (BaseColor)BaseColor.BLUE);
        Font headerFont = FontFactory.getFont((String)"Helvetica-Bold", (float)12.0f, (BaseColor)BaseColor.WHITE);
        Font normalFont = FontFactory.getFont((String)"Helvetica", (float)10.0f, (BaseColor)BaseColor.BLACK);
        Paragraph title = new Paragraph("All Bought Insurance Policies Report");
        title.setAlignment(1);
        title.setFont(titleFont);
        document.add((Element)title);
        if (planName != null && !planName.trim().isEmpty()) {
            Paragraph filterInfo = new Paragraph("Filtered by Plan: " + planName);
            filterInfo.setAlignment(1);
            filterInfo.setFont(normalFont);
            document.add((Element)filterInfo);
        }
        document.add((Element)new Paragraph(" "));
        PdfPTable table = new PdfPTable(6);
        table.setWidthPercentage(100.0f);
        table.setSpacingBefore(10.0f);
        table.setSpacingAfter(10.0f);
        PdfPCell cell = new PdfPCell();
        cell.setPadding(8.0f);
        cell.setBackgroundColor(BaseColor.DARK_GRAY);
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.setPhrase(new Phrase("ID", headerFont));
        table.addCell(cell);
        cell.setPhrase(new Phrase("User Name", headerFont));
        table.addCell(cell);
        cell.setPhrase(new Phrase("Insurance Name", headerFont));
        table.addCell(cell);
        cell.setPhrase(new Phrase("Start Date", headerFont));
        table.addCell(cell);
        cell.setPhrase(new Phrase("End Date", headerFont));
        table.addCell(cell);
        cell.setPhrase(new Phrase("Claimed Status", headerFont));
        table.addCell(cell);
        PdfPCell dataCell = new PdfPCell();
        dataCell.setPadding(5.0f);
        dataCell.setHorizontalAlignment(0);
        dataCell.setVerticalAlignment(5);
        dataCell.setLeading(0.0f, 1.2f);
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        for (BoughtInsurance boughtInsurance : allBoughtInsurances) {
            dataCell.setPhrase(new Phrase(String.valueOf(boughtInsurance.getId()), normalFont));
            table.addCell(dataCell);
            dataCell.setPhrase(new Phrase(boughtInsurance.getUser().getName(), normalFont));
            table.addCell(dataCell);
            dataCell.setPhrase(new Phrase(boughtInsurance.getInsurance().getName(), normalFont));
            table.addCell(dataCell);
            LocalDate purchaseDate = Instant.ofEpochMilli(boughtInsurance.getPurchaseDate().getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
            dataCell.setPhrase(new Phrase(dateFormatter.format(purchaseDate), normalFont));
            table.addCell(dataCell);
            LocalDate expiryDate = Instant.ofEpochMilli(boughtInsurance.getExpiryDate().getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
            dataCell.setPhrase(new Phrase(dateFormatter.format(expiryDate), normalFont));
            table.addCell(dataCell);
            dataCell.setPhrase(new Phrase(boughtInsurance.isClaimed() ? "Claimed" : "Not Claimed", normalFont));
            table.addCell(dataCell);
        }
        document.add((Element)table);
        document.close();
        return baos.toByteArray();
    }
}

