/*
 * Decompiled with CFR 0.152.
 */
package com.MedInsuranceV2.Version20.User;

import com.MedInsuranceV2.Version20.User.User;
import com.MedInsuranceV2.Version20.User.UserRepository;
import exception.UserAlreadyExistsException;
import exception.UserNotFoundException;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;

@Service
public class UserService {
    @Autowired
    private UserRepository userRepository;

    public User registerUser(User user) {
        try {
            return (User)this.userRepository.save((Object)user);
        }
        catch (DataIntegrityViolationException e) {
            if (e.getMessage().contains("unique constraint") || e.getMessage().contains("duplicate key")) {
                throw new UserAlreadyExistsException("This Email ID already exists: " + user.getEmailId());
            }
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Problem occurred while registering the user", e);
        }
    }

    public Optional<User> findUserByEmail(String email) {
        try {
            return this.userRepository.findByEmailId(email);
        }
        catch (Exception e) {
            throw new RuntimeException("Problem occurred while finding user by Email ID: " + email, e);
        }
    }

    public Optional<User> findUserById(Long userId) {
        try {
            Optional user = this.userRepository.findById((Object)userId);
            if (user.isEmpty()) {
                throw new UserNotFoundException("User ID " + userId + " not found");
            }
            return user;
        }
        catch (UserNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Problem occurred while finding user by User ID: " + userId, e);
        }
    }

    public List<User> getAllUsers() {
        return this.userRepository.findAll();
    }

    public void updateUser(User user) {
        try {
            if (!this.userRepository.existsById((Object)user.getId())) {
                throw new UserNotFoundException("User ID " + user.getId() + " not found, cannot update.");
            }
            this.userRepository.save((Object)user);
        }
        catch (UserNotFoundException e) {
            throw e;
        }
        catch (DataIntegrityViolationException e) {
            if (e.getMessage().contains("unique constraint") || e.getMessage().contains("duplicate key")) {
                throw new UserAlreadyExistsException("This Email ID already exists: " + user.getEmailId());
            }
            throw new RuntimeException("Problem occurred while updating the user", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Problem occurred while updating the user", e);
        }
    }

    public void deleteUser(Long userId) {
        try {
            if (!this.userRepository.existsById((Object)userId)) {
                throw new UserNotFoundException("User ID " + userId + " not found, cannot delete.");
            }
            this.userRepository.deleteById((Object)userId);
        }
        catch (UserNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Problem occurred while deleting the user: " + userId, e);
        }
    }
}

