package com.MedInsuranceV2.Version20.BoughtInsurance;


import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Optional;

// Assuming you have a user context or you'll pass user_id/username
// For simplicity, this example just searches by policy number and displays details.
// In a real application, you'd likely restrict this to the user who bought the policy
// or to an admin.

@Controller
public class BoughtInsuranceController {

    @Autowired
    private BoughtInsuranceService boughtInsuranceService;

    // Displays the search form for policy number
    @GetMapping("/searchPolicy")
    public String showSearchPolicyForm() {
        return "searchPolicy"; // This will map to searchPolicy.jsp
    }

    // Handles the search request by policy number
    @GetMapping("/findPolicyDetails")
    public String findPolicyDetails(@RequestParam("policyNumber") String policyNumber, Model model) {
        Optional<BoughtInsurance> boughtInsurance = boughtInsuranceService.findByPolicyNumber(policyNumber);

        if (boughtInsurance.isPresent()) {
            BoughtInsurance foundPolicy = boughtInsurance.get();
            model.addAttribute("foundPolicy", foundPolicy);
            model.addAttribute("user", foundPolicy.getUser()); // Pass user details
            model.addAttribute("insurance", foundPolicy.getInsurance()); // Pass insurance details
            return "policyDetails"; // This will map to policyDetails.jsp
        } else {
            model.addAttribute("message", "Policy Number '" + policyNumber + "' not found.");
            return "policyNotFound"; // This will map to policyNotFound.jsp
        }
    }
}