package com.MedInsuranceV2.Version20.BoughtInsurance;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Repository;

import com.MedInsuranceV2.Version20.User.User;

import java.util.Date;
import java.util.List;
import java.util.Optional; // Import Optional

@Repository
public interface BoughtInsuranceRepository extends JpaRepository<BoughtInsurance, Long> {
    List<BoughtInsurance> findByUser(User user);
    List<BoughtInsurance> findByClaimed(boolean claimed);
    List<BoughtInsurance> findByPurchaseDateBetween(Date startDate, Date endDate);

    // New method to find by policyNumber
    Optional<BoughtInsurance> findByPolicyNumber(String policyNumber); // Use Optional for single result
	List<BoughtInsurance> findByInsurance_NameContainingIgnoreCase(String planName);
	List<BoughtInsurance> findByUserId(Long userId);
}