package com.MedInsuranceV2.Version20.BoughtInsurance;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.MedInsuranceV2.Version20.Insurance.Insurance;
import com.MedInsuranceV2.Version20.User.User;

import java.util.Date;
import java.util.List;
import java.util.Calendar; // For date manipulation
import java.util.Optional;
import java.util.UUID;

@Service
public class BoughtInsuranceService {

    @Autowired
    private BoughtInsuranceRepository boughtInsuranceRepository;

    public BoughtInsurance buyInsurance(User user, Insurance insurance) {
        BoughtInsurance boughtInsurance = new BoughtInsurance();
        boughtInsurance.setUser(user);
        boughtInsurance.setInsurance(insurance);
        boughtInsurance.setPurchaseDate(new Date());
        String policyNumber = generateUniquePolicyNumber(); // Implement this method
        boughtInsurance.setPolicyNumber(policyNumber);
        // காப்பீட்டுத் திட்டத்தின் காலாவதியான தேதியை 1 வருடமாக அமைக்கவும்
        Date expiryDate = new Date(System.currentTimeMillis() + (365 * 24 * 60 * 60 * 1000L));
        boughtInsurance.setExpiryDate(expiryDate);
        boughtInsurance.setClaimed(false); // புதிதாக வாங்கிய காப்பீடு கிளெய்ம் செய்யப்படவில்லை
        return boughtInsuranceRepository.save(boughtInsurance);
    }
    private String generateUniquePolicyNumber() {
        // Implement logic to generate a unique policy number.
        // This could be a UUID, a timestamp-based string, or a counter.
        // Example using UUID:
        return "POL-" + UUID.randomUUID().toString().substring(0, 8).toUpperCase();
        // Or a more business-friendly format, e.g., "MI-" + System.currentTimeMillis()
    }
    
    public List<BoughtInsurance> getBoughtInsuranceByUser(User user) {
        // Assuming you have a JpaRepository for BoughtInsurance, e.g., BoughtInsuranceRepository
        List<BoughtInsurance> list = boughtInsuranceRepository.findByUser(user); // Or whatever your method is
        System.out.println("DEBUG: In BoughtInsuranceService, fetching for user: " + user.getId() + ". Found " + list.size() + " records."); // Add this
        return list;
    }

    // கிளெய்ம் செய்யப்பட்ட அனைத்து காப்பீடுகளையும் பெற
    public List<BoughtInsurance> getAllClaimedInsurances() {
        return boughtInsuranceRepository.findByClaimed(true); // கிளெய்ம் செய்யப்பட்டவை மட்டும்
    }

    // கிளெய்ம் செய்யப்பட்ட காப்பீட்டின் நிலையை புதுப்பிக்க (அட்மின் பயன்படுத்த)
    public void updateClaimStatus(Long boughtInsuranceId, boolean status) {
        Optional<BoughtInsurance> optionalBoughtInsurance = boughtInsuranceRepository.findById(boughtInsuranceId);
        if (optionalBoughtInsurance.isPresent()) {
            BoughtInsurance boughtInsurance = optionalBoughtInsurance.get();
            boughtInsurance.setClaimed(status);
            boughtInsuranceRepository.save(boughtInsurance);
        } else {
            throw new RuntimeException("Bought Insurance with ID " + boughtInsuranceId + " not found.");
        }
    }

    // ஆண்டு வாரியான காப்பீட்டு அறிக்கையைப் பெற புதிய முறை
    public List<BoughtInsurance> getBoughtInsurancesByYear(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, Calendar.JANUARY, 1, 0, 0, 0);
        calendar.set(Calendar.MILLISECOND, 0);
        Date startDate = calendar.getTime();

        calendar.set(year, Calendar.DECEMBER, 31, 23, 59, 59);
        calendar.set(Calendar.MILLISECOND, 999);
        Date endDate = calendar.getTime();

        return boughtInsuranceRepository.findByPurchaseDateBetween(startDate, endDate);
    }


	public Optional<BoughtInsurance> findById(long id) {
		
		return boughtInsuranceRepository.findById(id); // இந்த முறை அனைத்து வாங்கிய காப்பீடுகளையும் பெறும்
	}
	public List<BoughtInsurance> getAllBoughtInsurances() {
        return boughtInsuranceRepository.findAll(); // Assuming you're using Spring Data JPA
    }

	public Optional<BoughtInsurance> findByPolicyNumber(String policyNumber) {
		
		return boughtInsuranceRepository.findByPolicyNumber(policyNumber); // கொடுக்கப்பட்ட policyNumber உடன் வாங்கிய காப்பீட்டை பெறும்
	}
	public void save(BoughtInsurance boughtInsurance) {
		boughtInsuranceRepository.save(boughtInsurance); // வாங்கிய காப்பீட்டை சேமிக்கிறது
		
	}
	 public List<BoughtInsurance> getBoughtInsurancesByInsurancePlanName(String planName) {
	        return boughtInsuranceRepository.findByInsurance_NameContainingIgnoreCase(planName);
	    }
	public List<BoughtInsurance> findBoughtInsurancesByUserId(Long userId) {
		
		return boughtInsuranceRepository.findByUserId(userId); // கொடுக்கப்பட்ட userId உடன் வாங்கிய காப்பீடுகளை பெறும்
	}
	
	
}