package com.MedInsuranceV2.Version20.Claim;


import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository // This annotation tells Spring to make this a Spring Data JPA repository
public interface ClaimRepository extends JpaRepository<Claim, Long> {
 // JpaRepository<Claim, Long> provides methods like save(), findById(), findAll(), delete()

 // You can add custom methods here if you need more specific queries
 List<Claim> findByStatus(String status); // Example: find all claims with a specific status
 List<Claim> findByUser_Id(Long userId); // Example: find all claims by a specific user
List<Claim> findByBoughtInsurance_Id(Long id);
//List<Claim> findClaimedInsurancesByName(String insuranceName);
//List<Claim> findAllClaimedInsurances();
List<Claim> findByIsApprovedTrue();
List<Claim> findByInsuranceNameContainingIgnoreCaseAndIsApprovedTrue(String insuranceName);

}
