package com.MedInsuranceV2.Version20.Claim;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional; // Good practice for service methods that modify data

import java.util.List;
import java.util.Optional;

@Service // This annotation tells Spring that this is a service component
public class ClaimService {

 @Autowired // Spring will automatically inject an instance of ClaimRepository
 private ClaimRepository claimRepository;

 @Transactional // Ensures that this method runs in a transaction. If any error, changes are rolled back.
 public Claim saveClaim(Claim claim) {
     return claimRepository.save(claim); // Calls the save method from JpaRepository
 }

 @Transactional(readOnly = true) // Read-only transaction for fetching data
 public Optional<Claim> findClaimById(Long id) {
     return claimRepository.findById(id); // Calls the findById method from JpaRepository
 }

 @Transactional(readOnly = true)
 public List<Claim> getAllClaims() {
     return claimRepository.findAll(); // Calls the findAll method from JpaRepository
 }

 @Transactional(readOnly = true)
 public List<Claim> getClaimsByStatus(String status) {
     return claimRepository.findByStatus(status); // Calls the custom method defined in the repository
 }

 // You could add methods for updating status, etc.
 @Transactional
 public Claim updateClaim(Claim claim) {
     return claimRepository.save(claim); // save can also be used for updates if entity has an ID
 }

public List<Claim> findByBoughtInsurance_Id(Long id) {
	
	return claimRepository.findByBoughtInsurance_Id(id); // Calls the custom method defined in the repository
}
public List<Claim> findAllClaimedInsurances() {
    return claimRepository.findByIsApprovedTrue(); // Or whatever method name you chose
}

public List<Claim> findClaimedInsurancesByName(String insuranceName) {
    return claimRepository.findByInsuranceNameContainingIgnoreCaseAndIsApprovedTrue(insuranceName); // Or whatever method name you chose
}

public void save(Claim claim) {
		claimRepository.save(claim); // Calls the save method from JpaRepository
	
}
}
