package com.MedInsuranceV2.Version20.Email;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Properties;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.MailException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.stereotype.Service;

import jakarta.mail.MessagingException;
import jakarta.mail.*;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.activation.DataHandler; // For DataHandler
import jakarta.activation.DataSource; // For DataSource
import jakarta.mail.util.ByteArrayDataSource; // For ByteArrayDataSource

import java.util.Properties;

@Service
public class EmailService {

	@Autowired
	private JavaMailSender javaMailSender;

	public void sendSimpleEmail(String toEmail, String subject, String body) {
		SimpleMailMessage message = new SimpleMailMessage();
		message.setFrom(toEmail); // properties-ல இருக்கிற email-ஐ பயன்படுத்தவும்
		message.setTo(toEmail);
		message.setSubject(subject);
		message.setText(body);

		try {
			javaMailSender.send(message);
			System.out.println("Email sent successfully to " + toEmail);
		} catch (MailException e) {
			System.err.println("Error sending email: " + e.getMessage());
			e.printStackTrace();
		}
	}

	private final String senderEmail = "manickaraj1516@gmail.com"; // Replace with your email
	private final String senderPassword = "znwy jmtz pzdl czcc"; // Use an App Password for Gmail

	public void sendOtpEmail(String recipientEmail, String otp) throws MessagingException {
		Properties props = new Properties();
		props.put("mail.smtp.host", "smtp.gmail.com");
		props.put("mail.smtp.port", "587");
		props.put("mail.smtp.auth", "true");
		props.put("mail.smtp.starttls.enable", "true"); // For TLS

		Session session = Session.getInstance(props, new Authenticator() {
			protected PasswordAuthentication getPasswordAuthentication() {
				return new PasswordAuthentication(senderEmail, senderPassword);
			}
		});

		try {
			Message message = new MimeMessage(session);
			message.setFrom(new InternetAddress(senderEmail));
			message.setRecipients(Message.RecipientType.TO, InternetAddress.parse(recipientEmail));
			message.setSubject("Your OTP for Registration");
			message.setText("Dear User,\n\nYour One-Time Password (OTP) for registration is: " + otp
					+ "\n\nThis OTP is valid for 5 minutes. Do not share it with anyone.\n\nRegards,\nYour App Team");

			Transport.send(message);
			System.out.println("OTP email sent successfully to " + recipientEmail);
		} catch (MessagingException e) {
			System.err.println("Error sending OTP email: " + e.getMessage());
			throw e;
		}
	}

	public void sendEmailWithAttachment(String toEmail, String subject, String body, byte[] pdfBytes,
			String attachmentName, String attachmentContentType) {
		Properties props = new Properties();
		props.put("mail.smtp.host", "smtp.gmail.com");
		props.put("mail.smtp.port", "587");
		props.put("mail.smtp.auth", "true");
		props.put("mail.smtp.starttls.enable", "true"); // For TLS
		Session session = Session.getInstance(props, new Authenticator() {
			protected PasswordAuthentication getPasswordAuthentication() {
				return new PasswordAuthentication(senderEmail, senderPassword);
			}
		});

	}

	public void sendEmailWithAttachment1(String toEmail, String subject, String body, ByteArrayInputStream attachmentBytes,
			String attachmentName, String attachmentContentType) throws MessagingException, IOException {
		
// Properties are already set up in sendOtpEmail,
// but it's good practice to ensure they are available or passed.
		Properties props = new Properties();
		props.put("mail.smtp.host", "smtp.gmail.com");
		props.put("mail.smtp.port", "587");
		props.put("mail.smtp.auth", "true");
		props.put("mail.smtp.starttls.enable", "true"); // For TLS

		Session session = Session.getInstance(props, new Authenticator() {
			protected PasswordAuthentication getPasswordAuthentication() {
				return new PasswordAuthentication(senderEmail, senderPassword);
			}
		});

		try {
			MimeMessage message = new MimeMessage(session);
			message.setFrom(new InternetAddress(senderEmail));
			message.setRecipients(Message.RecipientType.TO, InternetAddress.parse(toEmail));
			message.setSubject(subject);

// Create the message body part
			MimeBodyPart messageBodyPart = new MimeBodyPart();
			messageBodyPart.setText(body);

// Create the attachment body part
			MimeBodyPart attachmentBodyPart = new MimeBodyPart();
			DataSource source = new ByteArrayDataSource(attachmentBytes, attachmentContentType);
			attachmentBodyPart.setDataHandler(new DataHandler(source));
			attachmentBodyPart.setFileName(attachmentName);

// Create a multipart message and add the body part and attachment part
			MimeMultipart multipart = new MimeMultipart();
			multipart.addBodyPart(messageBodyPart);
			multipart.addBodyPart(attachmentBodyPart);

// Set the content of the message to the multipart
			message.setContent(multipart);

// Send the message
			Transport.send(message);

			System.out.println(
					"Email with attachment sent successfully to " + toEmail + " with attachment: " + attachmentName);

		} catch (MessagingException e) {
			System.err.println("Error sending email with attachment: " + e.getMessage());
			throw e; // Re-throw the exception for proper error handling upstream
		}
	}

	

}
