package com.MedInsuranceV2.Version20.Enquiry;

import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import java.time.LocalDateTime;

@Entity // This annotation marks the class as a JPA entity
public class Enquiry {

    @Id // Specifies the primary key of the entity
    @GeneratedValue(strategy = GenerationType.IDENTITY) // Auto-generates the ID
    private Long id;
    private String name;
    private String mobileNumber;
    private String pincode;
    private LocalDateTime enquiryDate; // To store when the enquiry was made

    // Constructors
    public Enquiry() {
    }

    public Enquiry(String name, String mobileNumber, String pincode) {
        this.name = name;
        this.mobileNumber = mobileNumber;
        this.pincode = pincode;
        this.enquiryDate = LocalDateTime.now(); // Set current time on creation
    }

    // Getters and Setters
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMobileNumber() {
        return mobileNumber;
    }

    public void setMobileNumber(String mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    public String getPincode() {
        return pincode;
    }

    public void setPincode(String pincode) {
        this.pincode = pincode;
    }

    public LocalDateTime getEnquiryDate() {
        return enquiryDate;
    }

    public void setEnquiryDate(LocalDateTime enquiryDate) {
        this.enquiryDate = enquiryDate;
    }

    @Override
    public String toString() {
        return "Enquiry{" +
               "id=" + id +
               ", name='" + name + '\'' +
               ", mobileNumber='" + mobileNumber + '\'' +
               ", pincode='" + pincode + '\'' +
               ", enquiryDate=" + enquiryDate +
               '}';
    }
}
