package com.MedInsuranceV2.Version20.Insurance;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

@Service
public class InsuranceService {

    @Autowired
    private InsuranceRepository insuranceRepository;

    public List<Insurance> getAllInsurancePolicies() {
        return insuranceRepository.findAll();
    }

    public Optional<Insurance> getInsuranceById(Long id) {
        return insuranceRepository.findById(id);
    }

    public Optional<Insurance> findByName(String name) {
        return insuranceRepository.findByName(name);
    }
    public Optional<Insurance> findById(Long id) {
        return insuranceRepository.findById(id);
    }

    // புதிய காப்பீட்டுத் திட்டத்தை சேர்க்க
    public Insurance addInsurance(Insurance insurance) {
        return insuranceRepository.save(insurance);
    }

    // காப்பீட்டுத் திட்டத்தை ID மூலம் நீக்க
    public void deleteInsurance(Long id) {
        insuranceRepository.deleteById(id);
    }

    // காப்பீட்டுத் திட்டத்தை புதுப்பிக்க
    public Insurance updateInsurance(Insurance insurance) {
        // காப்பீட்டுத் திட்டம் உள்ளதா என்று சரிபார்க்க
        if (insuranceRepository.existsById(insurance.getId())) {
            return insuranceRepository.save(insurance);
        } else {
            // அல்லது ஒரு தனிப்பயன் விதிவிலக்கை (custom exception) தூண்டலாம்
            throw new RuntimeException("Insurance policy with ID " + insurance.getId() + " not found.");
        }
    }
}