package com.MedInsuranceV2.Version20.Medicine;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import com.MedInsuranceV2.Version20.Medicine.MedicineService.MedicineServiceException;

import java.util.List;

@Controller
public class MedicineController {

    @Autowired
    private MedicineService medicineService;

    @GetMapping("/medicineByLocation")
    public String medicineByLocationPage() {
        return "medicineByLocation";
    }

    @GetMapping("/medicineByLocation/search")
    public String findMedicinesByLocation(@RequestParam String location, Model model) {
        try {
            List<Medicine> medicines = medicineService.getMedicinesByLocation(location);
            model.addAttribute("medicines", medicines);
            return "medicineByLocation";
        } catch (MedicineService.MedicineServiceException e) {
            model.addAttribute("error", "Medicine Mismatch: " + e.getMessage());
            return "medicineByLocation";
        }
    }
}
