package com.MedInsuranceV2.Version20.User;

import exception.UserAlreadyExistsException;
import exception.UserNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;

import java.util.List; // List இறக்குமதி செய்யப்பட்டது
import java.util.Optional;

@Service
public class UserService {

    @Autowired
    private UserRepository userRepository;

    public User registerUser(User user) {
        // IMPORTANT: In a real application, you would hash the password here
        // before saving the user to the database.
        // For example: user.setPassword(passwordEncoder.encode(user.getPassword()));

        try {
            return userRepository.save(user);
        } catch (DataIntegrityViolationException e) {
            if (e.getMessage().contains("unique constraint") || e.getMessage().contains("duplicate key")) {
                throw new UserAlreadyExistsException("This Email ID already exists: " + user.getEmailId());
            }
            throw e;
        } catch (Exception e) {
            throw new RuntimeException("Problem occurred while registering the user", e);
        }
    }

    public Optional<User> findUserByEmail(String email) {
        try {
            return userRepository.findByEmailId(email);
        } catch (Exception e) {
            throw new RuntimeException("Problem occurred while finding user by Email ID: " + email, e);
        }
    }

    public Optional<User> findUserById(Long userId) {
        try {
            Optional<User> user = userRepository.findById(userId);
            if (user.isEmpty()) {
                throw new UserNotFoundException("User ID " + userId + " not found");
            }
            return user;
        } catch (UserNotFoundException e) {
            throw e;
        } catch (Exception e) {
            throw new RuntimeException("Problem occurred while finding user by User ID: " + userId, e);
        }
    }

    // அனைத்து பயனர்களையும் பெற புதிய முறை சேர்க்கப்பட்டது
    public List<User> getAllUsers() {
        return userRepository.findAll();
    }

    public void updateUser(User user) {
        try {
            if (!userRepository.existsById(user.getId())) {
                throw new UserNotFoundException("User ID " + user.getId() + " not found, cannot update.");
            }
            userRepository.save(user);
        } catch (UserNotFoundException e) {
            throw e;
        } catch (DataIntegrityViolationException e) {
            if (e.getMessage().contains("unique constraint") || e.getMessage().contains("duplicate key")) {
                throw new UserAlreadyExistsException("This Email ID already exists: " + user.getEmailId());
            }
            throw new RuntimeException("Problem occurred while updating the user", e);
        } catch (Exception e) {
            throw new RuntimeException("Problem occurred while updating the user", e);
        }
    }

    public void deleteUser(Long userId) {
        try {
            if (!userRepository.existsById(userId)) {
                throw new UserNotFoundException("User ID " + userId + " not found, cannot delete.");
            }
            userRepository.deleteById(userId);
        } catch (UserNotFoundException e) {
            throw e;
        } catch (Exception e) {
            throw new RuntimeException("Problem occurred while deleting the user: " + userId, e);
        }
    }
}