<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>
<%@ taglib uri="jakarta.tags.core" prefix="c"%>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Admin Dashboard</title>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<link flex href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet" />
<style>
/* Combined CSS from both your dashboard and the new sidebar design */

/* Google Fonts - Poppins (for sidebar) and Inter (for dashboard) */
@import url("https://fonts.googleapis.com/css2?family=Poppins:wght@200;300;400;500;600;700&display=swap");
@import url('https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap');

:root {
    --primary-color: #2563eb;
    --secondary-color: #1e40af;
    --background-color: #eef5fe; /* Lighter background for new design */
    --card-background: #ffffff;
    --text-primary: #1e293b;
    --text-secondary: #64748b;
    --border-radius: 12px;
    --transition: all 0.3s ease;

    /* Sidebar specific colors */
    --sidebar-bg: #fff;
    --sidebar-text: #707070;
    --sidebar-hover-bg: #4070f4;
    --sidebar-hover-text: #fff;
    --sidebar-lock-icon: #4070f4;
    --logo-name: #333;
    --profile-name-email: #333;
}

/* Base Styles */
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
    font-family: 'Inter', "Poppins", sans-serif; /* Prioritize Inter, fallback to Poppins */
}

body {
    min-height: 100vh;
    background-color: var(--background-color);
    color: var(--text-primary);
    line-height: 1.6;
}

/* Pre css for sidebar structure */
.flex {
    display: flex;
    align-items: center;
}
.nav_image {
    display: flex;
    min-width: 55px;
    justify-content: center;
}
.nav_image img {
    height: 35px;
    width: 35px;
    border-radius: 50%;
    object-fit: cover;
}

/* Sidebar */
.sidebar {
    position: fixed;
    top: 0;
    left: 0;
    height: 100%;
    width: 270px;
    background: var(--sidebar-bg);
    padding: 15px 10px;
    box-shadow: 0 0 2px rgba(0, 0, 0, 0.1);
    transition: all 0.4s ease;
    z-index: 1000; /* Ensure sidebar is on top */
}
.sidebar.close {
    width: calc(55px + 20px);
}
.logo_items {
    gap: 8px;
}
.logo_name {
    font-size: 22px;
    color: var(--logo-name);
    font-weight: 500;
    transition: all 0.3s ease;
}
.sidebar.close .logo_name,
.sidebar.close #lock-icon,
.sidebar.close #sidebar-close {
    opacity: 0;
    pointer-events: none;
}
#lock-icon,
#sidebar-close {
    padding: 10px;
    color: var(--sidebar-lock-icon);
    font-size: 25px;
    cursor: pointer;
    margin-left: -4px;
    transition: all 0.3s ease;
}
#sidebar-close {
    display: none;
    color: var(--logo-name);
}
.menu_container {
    display: flex;
    flex-direction: column;
    justify-content: space-between;
    margin-top: 40px;
    overflow-y: auto;
    height: calc(100% - 82px);
}
.menu_container::-webkit-scrollbar {
    display: none;
}
.menu_title {
    position: relative;
    height: 50px;
    width: 55px;
    margin-bottom: 10px; /* Added spacing */
}
.menu_title .title {
    margin-left: 15px;
    transition: all 0.3s ease;
    font-size: 0.9em;
    font-weight: 600;
    color: var(--text-secondary);
    text-transform: uppercase;
}
.sidebar.close .title {
    opacity: 0;
}
.menu_title .line {
    position: absolute;
    left: 50%;
    transform: translateX(-50%);
    height: 3px;
    width: 20px;
    border-radius: 25px;
    background: #aaa;
    transition: all 0.3s ease;
}
.menu_title .line {
    opacity: 0;
}
.sidebar.close .line {
    opacity: 1;
}
.item {
    list-style: none;
}
.link {
    text-decoration: none;
    border-radius: 8px;
    margin-bottom: 8px;
    color: var(--sidebar-text);
    display: flex; /* Make links flex for icon and text */
    align-items: center;
    padding: 12px 0; /* Adjust padding */
    transition: var(--transition);
}
.link:hover {
    color: var(--sidebar-hover-text);
    background-color: var(--sidebar-hover-bg);
}
.link span {
    white-space: nowrap;
    margin-left: 10px; /* Space between icon and text */
}
.link i {
    height: 50px;
    min-width: 55px;
    display: flex;
    font-size: 22px;
    align-items: center;
    justify-content: center;
    border-radius: 4px;
}

.sidebar_profile {
    padding-top: 15px;
    margin-top: 15px;
    gap: 15px;
    border-top: 2px solid rgba(0, 0, 0, 0.1);
}
.sidebar_profile .name {
    font-size: 18px;
    color: var(--profile-name-email);
}
.sidebar_profile .email {
    font-size: 15px;
    color: var(--profile-name-email);
}

/* Navbar (Top bar) */
.navbar {
    width: calc(100% - 270px); /* Adjust width based on sidebar state */
    position: fixed;
    top: 0;
    left: 270px; /* Position after sidebar */
    background: var(--card-background);
    padding: 10px 20px;
    border-radius: 0 0 8px 8px;
    justify-content: space-between;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
    transition: all 0.4s ease;
    z-index: 999; /* Below sidebar */
}
.sidebar.close + .navbar { /* When sidebar is closed, expand navbar */
    width: calc(100% - calc(55px + 20px));
    left: calc(55px + 20px);
}

#sidebar-open {
    font-size: 30px;
    color: var(--logo-name);
    cursor: pointer;
    margin-right: 20px;
    display: none; /* Hidden by default, shown on small screens */
}
.search_box {
    height: 46px;
    max-width: 500px;
    width: 100%;
    border: 1px solid #aaa;
    outline: none;
    border-radius: 8px;
    padding: 0 15px;
    font-size: 18px;
    color: var(--logo-name);
}
.navbar img {
    height: 40px;
    width: 40px;
    border-radius: 50%; /* Make profile pic round */
    object-fit: cover;
    margin-left: 20px;
}

/* Main content area */
.main-content {
    margin-left: 270px; /* Space for the sidebar */
    padding-top: 80px; /* Space for the fixed navbar */
    transition: all 0.4s ease;
}
.sidebar.close ~ .main-content { /* Use general sibling selector */
    margin-left: calc(55px + 20px);
}

/* Your existing dashboard styles - adapted to new structure */
.header { /* This header is replaced by the new navbar/sidebar. Hide it. */
    display: none;
}

.container {
    max-width: 1400px;
    margin: 0 auto;
    padding: 2rem;
}

.welcome-message {
    background-color: var(--card-background);
    padding: 1.5rem;
    border-radius: var(--border-radius);
    margin-bottom: 2rem;
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
    font-size: 1.1rem;
    color: var(--text-primary);
}

.reports-overview-section {
    background-color: var(--card-background);
    padding: 2rem;
    border-radius: var(--border-radius);
    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
    margin-bottom: 2rem;
}

.reports-overview-section h3 {
    color: var(--primary-color);
    text-align: center;
    margin-bottom: 2rem;
    font-size: 1.5rem;
    font-weight: 600;
}

.chart-container {
    width: 45%;
    min-width: 300px;
    background-color: var(--card-background);
    padding: 1.5rem;
    border-radius: var(--border-radius);
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
}

.chart-container h4 {
    text-align: center;
    color: var(--text-primary);
    margin: 0 0 1.5rem 0;
    font-size: 1.2rem;
    font-weight: 500;
}

.dashboard-sections {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
    gap: 1.5rem;
    margin-top: 2rem;
}

.section-card {
    background-color: var(--card-background);
    padding: 1.5rem;
    border-radius: var(--border-radius);
    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
    transition: var(--transition);
}

.section-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 12px -1px rgba(0, 0, 0, 0.15);
}

.section-card h3 {
    color: var(--primary-color);
    margin: 0 0 1.5rem 0;
    font-size: 1.3rem;
    font-weight: 600;
    text-align: center;
}

.section-card ul {
    list-style: none;
    padding: 0;
    margin: 0;
}

.section-card ul li {
    margin-bottom: 0.75rem;
}

.section-card ul li a {
    text-decoration: none;
    color: var(--text-primary);
    padding: 0.75rem 1rem;
    background-color: #f1f5f9;
    border-radius: 8px;
    display: block;
    transition: var(--transition);
    font-weight: 500;
}

.section-card ul li a:hover {
    background-color: var(--primary-color);
    color: white;
    transform: translateX(5px);
}

.scheduler-controls {
    margin-top: 20px;
    text-align: center;
}

.scheduler-controls button {
    padding: 10px 20px;
    margin: 5px;
    border: none;
    border-radius: 5px;
    cursor: pointer;
    font-size: 1rem;
    font-weight: 600;
    transition: background-color 0.3s ease;
}

.scheduler-controls button.start {
    background-color: #28a745;
    color: white;
}

.scheduler-controls button.start:hover {
    background-color: #218838;
}

.scheduler-controls button.stop {
    background-color: #dc3545;
    color: white;
}

.scheduler-controls button.stop:hover {
    background-color: #c82333;
}

.scheduler-status {
    margin-top: 15px;
    padding: 10px;
    border-radius: 5px;
    font-weight: 500;
    text-align: center;
}

.scheduler-status.success {
    background-color: #d4edda;
    color: #155724;
    border: 1px solid #c3e6cb;
}

.scheduler-status.error {
    background-color: #f8d7da;
    color: #721c24;
    border: 1px solid #f5c6cb;
}

.scheduler-status.info {
    background-color: #d1ecf1;
    color: #0c5460;
    border: 1px solid #bee5eb;
}

/* Responsive */
@media screen and (max-width: 1100px) {
    .navbar {
        width: calc(100% - 270px);
        left: 270px;
    }
    .sidebar.close + .navbar {
        width: calc(100% - calc(55px + 20px));
        left: calc(55px + 20px);
    }
    .main-content {
        margin-left: 270px;
    }
    .sidebar.close ~ .main-content {
        margin-left: calc(55px + 20px);
    }
}
@media screen and (max-width: 800px) {
    .sidebar {
        left: 0;
        z-index: 1000;
    }
    .sidebar.close {
        left: -100%;
    }
    #sidebar-close {
        display: block;
    }
    #lock-icon {
        display: none;
    }
    .navbar {
        left: 0;
        max-width: 100%;
        width: 100%; /* Ensure full width on small screens */
        transform: translateX(0%);
    }
    #sidebar-open {
        display: block;
    }
    .main-content { /* Content shifts entirely when sidebar is closed */
        margin-left: 0;
    }
    .sidebar.close ~ .main-content {
        margin-left: 0;
    }
}
</style>
</head>
<body>
    <nav class="sidebar locked">
        <div class="logo_items flex">
            <span class="nav_image">
                <img src="<c:url value="/images/logo.png"/>" alt="logo_img" />
            </span>
            <span class="logo_name">Admin Portal</span>
            <i class="bx bx-lock-alt" id="lock-icon" title="Unlock Sidebar"></i>
            <i class="bx bx-x" id="sidebar-close"></i>
        </div>

        <div class="menu_container">
            <div class="menu_items">
                <ul class="menu_item">
                    <div class="menu_title flex">
                        <span class="title">Dashboard</span>
                        <span class="line"></span>
                    </div>
                    <li class="item">
                        <a href="#" class="link flex">
                            <i class="bx bx-home-alt"></i>
                            <span>Overview</span>
                        </a>
                    </li>
                    <%-- Mapping existing Insurance Management links --%>
                    <li class="item">
                        <a href="/admin/insurance/viewAll" class="link flex">
                            <i class="bx bx-file"></i>
                            <span>View All Insurance</span>
                        </a>
                    </li>
                    <li class="item">
                        <a href="/admin/insurance/add" class="link flex">
                            <i class="bx bx-plus-circle"></i>
                            <span>Add New Insurance</span>
                        </a>
                    </li>
                    <li class="item">
                        <a href="/admin/insurance/manageClaims" class="link flex">
                            <i class="bx bx-receipt"></i>
                            <span>Manage Claims</span>
                        </a>
                    </li>
                     <li class="item">
                        <a href="/viewEnquiries" class="link flex">
                            <i class="bx bx-question-mark"></i>
                            <span>View Enquiries</span>
                        </a>
                    </li>
                </ul>

                <ul class="menu_item">
                    <div class="menu_title flex">
                        <span class="title">Management</span>
                        <span class="line"></span>
                    </div>
                    <%-- Mapping existing Payments links --%>
                    <li class="item">
                        <a href="/admin/payments/viewAll" class="link flex">
                            <i class="bx bx-credit-card"></i>
                            <span>View All Payments</span>
                        </a>
                    </li>
                    <li class="item">
                        <a href="/admin/payments/settle" class="link flex">
                            <i class="bx bx-dollar"></i>
                            <span>Settle Payments</span>
                        </a>
                    </li>
                    <%-- Mapping existing Agents links --%>
                    <li class="item">
                        <a href="/admin/agents/manage" class="link flex">
                            <i class="bx bx-user-plus"></i>
                            <span>Manage Agents</span>
                        </a>
                    </li>
                    <li class="item">
                        <a href="/admin/agents/details" class="link flex">
                            <i class="bx bx-user-detail"></i>
                            <span>Agent Details</span>
                        </a>
                    </li>
                </ul>

                <ul class="menu_item">
                    <div class="menu_title flex">
                        <span class="title">Reports</span>
                        <span class="line"></span>
                    </div>
                    <%-- Mapping existing Reports links --%>
                    <li class="item">
                        <a href="/admin/allBoughtInsurances" class="link flex">
                            <i class="bx bx-book-open"></i>
                            <span>Bought Insurances</span>
                        </a>
                    </li>
                    <li class="item">
                        <a href="/admin/reports/agent" class="link flex">
                            <i class="bx bx-user-check"></i>
                            <span>Agent Reports</span>
                        </a>
                    </li>
                    <li class="item">
                        <a href="/admin/reports/user" class="link flex">
                            <i class="bx bx-group"></i>
                            <span>User Reports</span>
                        </a>
                    </li>
                    <li class="item">
                        <a href="/admin/reports/claim" class="link flex">
                            <i class="bx bx-error-alt"></i>
                            <span>Claim Reports</span>
                        </a>
                    </li>
                </ul>
            </div>

            <div class="sidebar_profile flex">
                <span class="nav_image">
                     <img src="<c:url value="/images/default-profile.jpg"/>" alt="profile_img" />
                </span>
                <div class="data_text">
                    <span class="name"><c:out value="${loggedInAdmin.name}" /></span>
                    <span class="email"><c:out value="${loggedInAdmin.emailId}" /></span>
                </div>
                 <a href="/homepage" class="link flex" style="margin-top: 10px;">
                    <i class="bx bx-log-out"></i>
                    <span>Logout</span>
                </a>
            </div>
        </div>
    </nav>

    <nav class="navbar flex">
        <i class="bx bx-menu" id="sidebar-open"></i>
        <input type="text" placeholder="Search..." class="search_box" />
        <span class="nav_image">
            <img src="<c:url value="/images/default-profile.jpg"/>" alt="profile_img" />
        </span>
    </nav>

    <section class="main-content">
        <div class="container">
            <p class="welcome-message">
                Hello,
                <c:out value="${loggedInAdmin.name}" />
                ! Welcome to your Admin Portal.
            </p>

            <div class="reports-overview-section">
                <h3>Insurance Reports Overview</h3>
                <div style="display: flex; flex-wrap: wrap; justify-content: space-around; gap: 20px;">
                    <div class="chart-container">
                        <h4>Insurance Type Distribution</h4>
                        <canvas id="insuranceTypeChart"></canvas>
                    </div>
                    <div class="chart-container">
                        <h4>Monthly New Policies Sold</h4>
                        <canvas id="monthlyPoliciesChart"></canvas>
                    </div>
                </div>
            </div>

            <div class="dashboard-sections">
                <div class="section-card">
                    <h3>Insurance Management</h3>
                    <ul>
                        <li><a href="/admin/insurance/viewAll">View All Insurance</a></li>
                        <li><a href="/admin/insurance/add">Add New Insurance</a></li>
                        <li><a href="/admin/insurance/manageClaims">Manage Claimed Insurance</a></li>
                        <li><a href="/viewEnquiries">View All Enquiries</a></li>
                    </ul>
                </div>
                <div class="section-card">
                    <h3>Payments</h3>
                    <ul>
                        <li><a href="/admin/payments/viewAll">View All Payments</a></li>
                        <li><a href="/admin/payments/settle">Settle Received Payments</a></li>
                    </ul>
                </div>
                <div class="section-card">
                    <h3>Agents</h3>
                    <ul>
                        <li><a href="/admin/agents/manage">Manage Agents</a></li>
                        <li><a href="/admin/agents/details">Agent Details</a></li>
                    </ul>
                </div>
                <div class="section-card">
                    <h3>Reports</h3>
                    <ul>
                        <li><a href="/admin/allBoughtInsurances">View All Bought Insurances</a></li>
                        <li><a href="/admin/reports/agent">Agent Reports</a></li>
                        <li><a href="/admin/reports/user">User Reports</a></li>
                        <li><a href="/admin/reports/claim">Claim Reports</a></li>
                    </ul>
                    <div class="scheduler-controls">
                        <button id="scheduleReportButton" class="start">Schedule Daily Report</button>
                        <button id="stopReportButton" class="stop">Stop Daily Report</button>
                        <div id="schedulerStatus" class="scheduler-status"></div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <script>
        // Data for Insurance Type Distribution (Pie Chart)
        const insuranceTypeData = {
            labels: ['Life Insurance', 'Health Insurance', 'Auto Insurance', 'Home Insurance', 'Travel Insurance'],
            datasets: [{
                label: 'Number of Policies',
                data: [450, 300, 200, 150, 80], // Example data
                backgroundColor: [
                    'rgba(255, 99, 132, 0.7)',
                    'rgba(54, 162, 235, 0.7)',
                    'rgba(255, 206, 86, 0.7)',
                    'rgba(75, 192, 192, 0.7)',
                    'rgba(153, 102, 255, 0.7)'
                ],
                borderColor: [
                    'rgba(255, 99, 132, 1)',
                    'rgba(54, 162, 235, 1)',
                    'rgba(255, 206, 86, 1)',
                    'rgba(75, 192, 192, 1)',
                    'rgba(153, 102, 255, 1)'
                ],
                borderWidth: 1
            }]
        };

        // Configuration for Insurance Type Distribution Chart
        const insuranceTypeConfig = {
            type: 'pie',
            data: insuranceTypeData,
            options: {
                responsive: true,
                plugins: {
                    legend: {
                        position: 'top',
                    },
                    title: {
                        display: false,
                        text: 'Insurance Type Distribution'
                    }
                }
            },
        };

        // Render Insurance Type Distribution Chart
        const insuranceTypeChart = new Chart(document.getElementById('insuranceTypeChart'), insuranceTypeConfig);

        // Data for Monthly New Policies Sold (Line Chart)
        const monthlyPoliciesData = {
            labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
            datasets: [{
                label: 'New Policies Sold',
                data: [120, 150, 180, 160, 200, 230, 210, 250, 280, 270, 300, 320], // Example data
                backgroundColor: 'rgba(75, 192, 192, 0.6)',
                borderColor: 'rgba(75, 192, 192, 1)',
                borderWidth: 2,
                tension: 0.4, // Smooth line
                fill: false // Do not fill area under the line
            }]
        };

        // Configuration for Monthly New Policies Sold Chart
        const monthlyPoliciesConfig = {
            type: 'line',
            data: monthlyPoliciesData,
            options: {
                responsive: true,
                plugins: {
                    legend: {
                        position: 'top',
                    },
                    title: {
                        display: false,
                        text: 'Monthly New Policies Sold'
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        title: {
                            display: true,
                            text: 'Number of Policies'
                        }
                    },
                    x: {
                        title: {
                            display: true,
                            text: 'Month'
                        }
                    }
                }
            },
        };

        // Render Monthly New Policies Sold Chart
        const monthlyPoliciesChart = new Chart(document.getElementById('monthlyPoliciesChart'), monthlyPoliciesConfig);

        // --- Scheduler Buttons Logic (New) ---
        $(document).ready(function() {
            function updateStatus(message, type) {
                $('#schedulerStatus').text(message)
                .removeClass('success error info') // Remove all previous classes
                .addClass(type); // Add the new type class
            }

            $('#scheduleReportButton').click(function() {
                updateStatus('Scheduling report...', 'info');
                $.ajax({
                    url: '${pageContext.request.contextPath}/admin/scheduleDailyReport',
                    type: 'POST',
                    success: function(response) {
                        if (response.success) {
                            updateStatus(response.message, 'success');
                        } else {
                            updateStatus('Error: ' + response.message, 'error');
                        }
                    },
                    error: function(xhr, status, error) {
                        updateStatus('An AJAX error occurred: ' + error, 'error');
                        console.error("AJAX Error:", status, error, xhr.responseText);
                    }
                });
            });

            $('#stopReportButton').click(function() {
                updateStatus('Stopping scheduler...', 'info');
                $.ajax({
                    url: '${pageContext.request.contextPath}/admin/stopDailyReport',
                    type: 'POST',
                    success: function(response) {
                        if (response.success) {
                            updateStatus(response.message, 'success');
                        } else {
                            updateStatus('Error: ' + response.message, 'error');
                        }
                    },
                    error: function(xhr, status, error) {
                        updateStatus('An AJAX error occurred: ' + error, 'error');
                        console.error("AJAX Error:", status, error, xhr.responseText);
                    }
                });
            });
        });

        // --- Sidebar JavaScript (Copied from your provided code) ---
        const sidebar = document.querySelector(".sidebar");
        const sidebarOpenBtn = document.querySelector("#sidebar-open");
        const sidebarCloseBtn = document.querySelector("#sidebar-close");
        const sidebarLockBtn = document.querySelector("#lock-icon");
        const mainContent = document.querySelector(".main-content"); // Get main content
        const navbar = document.querySelector(".navbar"); // Get navbar

        // Function to toggle the lock state of the sidebar
        const toggleLock = () => {
            sidebar.classList.toggle("locked");
            // If the sidebar is not locked
            if (!sidebar.classList.contains("locked")) {
                sidebar.classList.add("hoverable");
                sidebarLockBtn.classList.replace("bx-lock-alt", "bx-lock-open-alt");
            } else {
                sidebar.classList.remove("hoverable");
                sidebarLockBtn.classList.replace("bx-lock-open-alt", "bx-lock-alt");
            }
        };

        // Function to hide the sidebar when the mouse leaves
        const hideSidebar = () => {
            if (sidebar.classList.contains("hoverable")) {
                sidebar.classList.add("close");
                // Adjust main content and navbar when sidebar closes on hover-out
                mainContent.style.marginLeft = 'calc(55px + 20px)';
                navbar.style.width = 'calc(100% - calc(55px + 20px))';
                navbar.style.left = 'calc(55px + 20px)';
            }
        };

        // Function to show the sidebar when the mouse enter
        const showSidebar = () => {
            if (sidebar.classList.contains("hoverable")) {
                sidebar.classList.remove("close");
                // Adjust main content and navbar when sidebar opens on hover-in
                mainContent.style.marginLeft = '270px';
                navbar.style.width = 'calc(100% - 270px)';
                navbar.style.left = '270px';
            }
        };

        // Function to show and hide the sidebar (for manual toggle)
        const toggleSidebar = () => {
            sidebar.classList.toggle("close");
            // Adjust main content and navbar based on toggle
            if (sidebar.classList.contains("close")) {
                mainContent.style.marginLeft = 'calc(55px + 20px)';
                navbar.style.width = 'calc(100% - calc(55px + 20px))';
                navbar.style.left = 'calc(55px + 20px)';
            } else {
                mainContent.style.marginLeft = '270px';
                navbar.style.width = 'calc(100% - 270px)';
                navbar.style.left = '270px';
            }
        };

        // If the window width is less than 800px, close the sidebar and remove hoverability and lock
        if (window.innerWidth < 800) {
            sidebar.classList.add("close");
            sidebar.classList.remove("locked");
            sidebar.classList.remove("hoverable");
            // Adjust main content and navbar initially for small screens
            mainContent.style.marginLeft = '0'; // Sidebar is off-screen
            navbar.style.width = '100%';
            navbar.style.left = '0';
        }

        // Adding event listeners to buttons and sidebar for the corresponding actions
        sidebarLockBtn.addEventListener("click", toggleLock);
        sidebar.addEventListener("mouseleave", hideSidebar);
        sidebar.addEventListener("mouseenter", showSidebar);
        sidebarOpenBtn.addEventListener("click", toggleSidebar);
        sidebarCloseBtn.addEventListener("click", toggleSidebar);

        // Initial adjustment on load, in case JS runs after CSS is applied
        // This ensures correct layout even if window.innerWidth is > 800 but sidebar is 'locked' or 'close' by default
        if (window.innerWidth >= 800) {
            if (sidebar.classList.contains("locked") || sidebar.classList.contains("close")) {
                // If locked or default close, set to collapsed width
                mainContent.style.marginLeft = 'calc(55px + 20px)';
                navbar.style.width = 'calc(100% - calc(55px + 20px))';
                navbar.style.left = 'calc(55px + 20px)';
            } else {
                // Otherwise, set to expanded width
                mainContent.style.marginLeft = '270px';
                navbar.style.width = 'calc(100% - 270px)';
                navbar.style.left = '270px';
            }
        }
    </script>
</body>
</html>