<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib uri="jakarta.tags.core" prefix="c" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Agent Reports</title>
    <style>
        body { font-family: Arial, sans-serif; background-color: #f4f4f4; margin: 0; padding: 0; }
        .header { background-color: #333; color: white; padding: 15px 20px; display: flex; justify-content: space-between; align-items: center; }
        .header h1 { margin: 0; font-size: 24px; }
        .header nav ul { list-style: none; margin: 0; padding: 0; display: flex; }
        .header nav ul li { margin-left: 20px; }
        .header nav ul li a { color: white; text-decoration: none; font-weight: bold; }
        .header nav ul li a:hover { text-decoration: underline; }
        .container { padding: 20px; max-width: 1000px; margin: 20px auto; background-color: #fff; border-radius: 8px; box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1); }
        h2 { color: #007bff; margin-bottom: 20px; text-align: center; }
        .form-section { margin-bottom: 20px; text-align: center; }
        .form-section label { margin-right: 10px; font-weight: bold; }
        .form-section select { padding: 8px; border-radius: 4px; border: 1px solid #ccc; }
        .form-section button { padding: 8px 15px; background-color: #28a745; color: white; border: none; border-radius: 4px; cursor: pointer; }
        .form-section button:hover { background-color: #218838; }
        .report-table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        .report-table th, .report-table td { border: 1px solid #ddd; padding: 10px; text-align: left; }
        .report-table th { background-color: #f2f2f2; color: #333; }
        .no-records { text-align: center; color: #888; margin-top: 20px; }
        .back-link { display: block; text-align: center; margin-top: 20px; text-decoration: none; color: #007bff; }
        .back-link:hover { text-decoration: underline; }
        .info-message { text-align: center; color: #555; margin-top: 15px; font-style: italic; }
    </style>
</head>
<body>
    <div class="header">
        <h1>Admin Panel</h1>
        <nav>
            <ul>
                <li><a href="/admin/dashboard">Dashboard</a></li>
                <li><a href="/logout">Logout</a></li>
            </ul>
        </nav>
    </div>

    <div class="container">
        <h2>Agent Reports for Year: <c:out value="${selectedYear}"/></h2>

        <div class="form-section">
            <form action="/admin/reports/agent" method="get">
                <label for="yearSelect">Select Year:</label>
                <select id="yearSelect" name="year">
                    <c:forEach begin="${currentYear - 5}" end="${currentYear + 5}" var="yearOption">
                        <option value="${yearOption}" <c:if test="${yearOption == selectedYear}">selected</c:if>>${yearOption}</option>
                    </c:forEach>
                </select>
                <button type="submit">View Report</button>
            </form>
        </div>

        <div class="info-message">
            <p>This report displays all insurance policies bought within the selected year.</p>
            <p>PDF download is not available due to current system limitations (requires additional libraries).</p>
        </div>

        <c:choose>
            <c:when test="${not empty annualReports}">
                <table class="report-table">
                    <thead>
                        <tr>
                            <th>Transaction ID</th>
                            <th>User Name</th>
                            <th>User Email</th>
                            <th>Insurance Plan</th>
                            <th>Coverage</th>
                            <th>Amount Paid</th>
                            <th>Purchase Date</th>
                            <th>Expiry Date</th>
                            <th>Claimed</th>
                        </tr>
                    </thead>
                    <tbody>
                        <c:forEach var="report" items="${annualReports}">
                            <tr>
                                <td><c:out value="${report.id}"/></td>
                                <td><c:out value="${report.user.name}"/></td>
                                <td><c:out value="${report.user.emailId}"/></td>
                                <td><c:out value="${report.insurance.name}"/></td>
                                <td><fmt:formatNumber value="${report.insurance.coverage}" type="currency" currencySymbol="$"/></td>
                                <td><fmt:formatNumber value="${report.insurance.amountPerYear}" type="currency" currencySymbol="$"/></td>
                                <td><fmt:formatDate value="${report.purchaseDate}" pattern="yyyy-MM-dd"/></td>
                                <td><fmt:formatDate value="${report.expiryDate}" pattern="yyyy-MM-dd"/></td>
                                <td><c:out value="${report.claimed ? 'Yes' : 'No'}"/></td>
                            </tr>
                        </c:forEach>
                    </tbody>
                </table>
            </c:when>
            <c:otherwise>
                <p class="no-records">No insurance policies found for the selected year.</p>
            </c:otherwise>
        </c:choose>

        <a href="/admin/dashboard" class="back-link">Back to Dashboard</a>
    </div>
</body>
</html>