<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib uri="jakarta.tags.core" prefix="c" %>
<%@ taglib uri="jakarta.tags.fmt" prefix="fmt" %>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>All Bought Insurance Reports - Admin</title>
    <style>
        body { font-family: Arial, sans-serif; background-color: #f4f4f4; margin: 0; padding: 0; }
        .header { background-color: #333; color: white; padding: 15px 20px; display: flex; justify-content: space-between; align-items: center; }
        .header h1 { margin: 0; font-size: 24px; }
        .header nav ul { list-style: none; margin: 0; padding: 0; display: flex; }
        .header nav ul li { margin-left: 20px; }
        .header nav ul li a { color: white; text-decoration: none; font-weight: bold; }
        .header nav ul li a:hover { text-decoration: underline; }
        .container { padding: 20px; max-width: 1200px; margin: 20px auto; background-color: #fff; border-radius: 8px; box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1); }
        h2 { color: #007bff; text-align: center; margin-bottom: 20px; }
        .filter-form {
            text-align: left;
            margin-bottom: 20px;
            padding: 15px;
            background-color: #e9ecef;
            border-radius: 5px;
            display: flex;
            align-items: center;
            gap: 10px; /* Space between elements */
        }
        .filter-form label {
            font-weight: bold;
            color: #333;
        }
        .filter-form input[type="text"] {
            flex-grow: 1; /* Allows input to take available space */
            padding: 8px;
            border: 1px solid #ced4da;
            border-radius: 4px;
            font-size: 14px;
            max-width: 300px; /* Limit max width of input */
        }
        .filter-form button {
            padding: 8px 15px;
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
            transition: background-color 0.2s ease;
        }
        .filter-form button:hover {
            background-color: #0056b3;
        }
        .report-options { text-align: center; margin-bottom: 30px; }
        .report-options button {
            background-color: #28a745; /* Green for PDF */
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            margin: 0 10px;
            transition: background-color 0.3s ease;
        }
        .report-options button:hover {
            background-color: #218838;
        }
        .report-options button.excel {
            background-color: #17a2b8; /* Blue for Excel */
        }
        .report-options button.excel:hover {
            background-color: #138496;
        }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { border: 1px solid #ddd; padding: 10px; text-align: left; font-size: 14px; }
        th { background-color: #f2f2f2; color: #333; }
        tr:nth-child(even) { background-color: #f9f9f9; }
        .no-records { text-align: center; color: #777; padding: 20px; }
        .back-link { display: block; text-align: center; margin-top: 30px; text-decoration: none; color: #007bff; }
        .back-link:hover { text-decoration: underline; }
    </style>
</head>
<body>
    <div class="header">
        <h1>Admin Panel</h1>
        <nav>
            <ul>
                <li><a href="/admin/dashboard">Dashboard</a></li>
                <!-- 
                <li><a href="/admin/allBoughtInsurances">All Bought Insurances</a></li>
                 -->
                <li><a href="/logout">Logout</a></li>
            </ul>
        </nav>
    </div>

    <div class="container">
        <h2>All Bought Insurance Policies</h2>

        <div class="filter-form">
            <form action="/admin/allBoughtInsurances" method="get" style="display: flex; width: 100%; gap: 10px; align-items: center;">
                <label for="planNameFilter">Filter by Insurance Plan Name:</label>
                <input type="text" id="planNameFilter" name="planName" value="${param.planName}" placeholder="Enter plan name">
                <button type="submit">Apply Filter</button>
                <c:if test="${not empty param.planName}">
                    <button type="button" onclick="window.location.href='/admin/allBoughtInsurances'">Clear Filter</button>
                </c:if>
            </form>
        </div>

        <div class="report-options">
            <p>Generate reports in different formats:</p>
            <%-- Pass the filter parameter to the report generation links --%>
            <button onclick="window.location.href='/admin/reports/allBoughtInsurances/pdf<c:if test="${not empty param.planName}">?planName=${param.planName}</c:if>'">Save as PDF</button>
            <button class="excel" onclick="window.location.href='/admin/reports/allBoughtInsurances/excel<c:if test="${not empty param.planName}">?planName=${param.planName}</c:if>'">Save as Excel</button>
        </div>

        <c:choose>
            <c:when test="${not empty allBoughtInsurances}">
                <table>
                    <thead>
                        <tr>
                            <th>Policy Number</th>
                            <th>Customer Name</th>
                            <th>Customer Email</th>
                            <th>Insurance Plan</th>
                            <th>Coverage Amount</th>
                            <th>Annual Premium</th>
                            <th>Purchase Date</th>
                            <th>Expiry Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <c:forEach var="boughtPolicy" items="${allBoughtInsurances}">
                            <tr>
                                <td><c:out value="${boughtPolicy.policyNumber}"/></td>
                                <td><c:out value="${boughtPolicy.name}"/></td>
                                <td><c:out value="${boughtPolicy.email}"/></td>
                                <td><c:out value="${boughtPolicy.insurance.name}"/></td>
                                <td><fmt:formatNumber value="${boughtPolicy.insurance.coverage}" type="currency" currencySymbol="₹"/></td>
                                <td><fmt:formatNumber value="${boughtPolicy.insurance.amountPerYear}" type="currency" currencySymbol="₹"/></td>
                                <td><fmt:formatDate value="${boughtPolicy.purchaseDate}" pattern="dd-MM-yyyy"/></td>
                                <td><fmt:formatDate value="${boughtPolicy.expiryDate}" pattern="dd-MM-yyyy"/></td>
                            </tr>
                        </c:forEach>
                    </tbody>
                </table>
            </c:when>
            <c:otherwise>
                <p class="no-records">No insurance policies found matching your criteria.</p>
            </c:otherwise>
        </c:choose>

        <a href="/admin/dashboard" class="back-link">Back to Admin Dashboard</a>
    </div>
</body>
</html>