<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib uri="jakarta.tags.core" prefix="c" %>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Claim Reports</title>
    <style>
        body { font-family: Arial, sans-serif; background-color: #f4f4f4; margin: 0; padding: 0; }
        .header { background-color: #333; color: white; padding: 15px 20px; display: flex; justify-content: space-between; align-items: center; }
        .header h1 { margin: 0; font-size: 24px; }
        .header nav ul { list-style: none; margin: 0; padding: 0; display: flex; }
        .header nav ul li { margin-left: 20px; }
        .header nav ul li a { color: white; text-decoration: none; font-weight: bold; }
        .header nav ul li a:hover { text-decoration: underline; }
        .container { padding: 20px; max-width: 1200px; margin: 20px auto; background-color: #fff; border-radius: 8px; box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1); }
        h2 { color: #007bff; margin-bottom: 20px; text-align: center; }
        .filter-form { margin-bottom: 20px; text-align: center; }
        .filter-form label { margin-right: 10px; font-weight: bold; }
        .filter-form input[type="text"] { padding: 8px; border: 1px solid #ccc; border-radius: 4px; width: 250px; }
        .filter-form button { padding: 8px 15px; background-color: #007bff; color: white; border: none; border-radius: 4px; cursor: pointer; }
        .filter-form button:hover { background-color: #0056b3; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { border: 1px solid #ddd; padding: 10px; text-align: left; vertical-align: top; } /* vertical-align top for better display of long text */
        th { background-color: #f2f2f2; font-weight: bold; }
        tr:nth-child(even) { background-color: #f9f9f9; }
        tr:hover { background-color: #f1f1f1; }
        .no-records { text-align: center; color: #888; padding: 20px; }
        .back-link { display: block; text-align: center; margin-top: 20px; text-decoration: none; color: #007bff; }
        .back-link:hover { text-decoration: underline; }
        /* Style for the collective action buttons */
        .collective-action-buttons {
            text-align: right; /* Align buttons to the right */
            margin-bottom: 15px; /* Space below buttons */
        }
        .collective-action-buttons button {
            padding: 8px 15px;
            margin-left: 10px; /* Space between buttons */
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
        }
        .collective-action-buttons .pdf-button { background-color: #dc3545; color: white; }
        .collective-action-buttons .pdf-button:hover { background-color: #c82333; }
        .collective-action-buttons .mail-button { background-color: #28a745; color: white; }
        .collective-action-buttons .mail-button:hover { background-color: #218838; }

        /* Styles for flash messages */
        .message-container {
            text-align: center;
            margin-bottom: 15px;
            padding: 10px;
            border-radius: 5px;
        }
        .message-container.success {
            background-color: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        .message-container.error {
            background-color: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Admin Panel</h1>
        <nav>
            <ul>
                <li><a href="/admin/dashboard">Dashboard</a></li>
                <li><a href="/logout">Logout</a></li>
            </ul>
        </nav>
    </div>

    <div class="container">
        <h2>Claim Reports</h2>

        <%-- Display success/error flash messages from RedirectAttributes --%>
        <c:if test="${not empty message}">
            <div class="message-container success">
                <p>${message}</p>
            </div>
        </c:if>
        <c:if test="${not empty error}">
            <div class="message-container error">
                <p>${error}</p>
            </div>
        </c:if>

        <div class="filter-form">
            <form action="/reports/claim" method="get">
                <label for="insuranceName">Filter by Insurance Name:</label>
                <input type="text" id="insuranceName" name="insuranceName"
                       value="${currentFilter != null ? currentFilter : ''}"
                       placeholder="Enter insurance name">
                <button type="submit">Filter</button>
            </form>
        </div>

        <c:choose>
            <c:when test="${not empty claimedInsurances}">
                <div class="collective-action-buttons">
                    <button class="pdf-button" onclick="location.href='/admin/reports/claim/download-all-pdf${currentFilter != null && !currentFilter.isEmpty() ? '?insuranceName=' : ''}${currentFilter != null ? currentFilter : ''}'">Download All PDF</button>
                    <button class="mail-button" onclick="location.href='/admin/reports/claim/send-all-email${currentFilter != null && !currentFilter.isEmpty() ? '?insuranceName=' : ''}${currentFilter != null ? currentFilter : ''}'">Mail All Reports</button>
                </div>

                <table>
                    <thead>
                        <tr>
                            <th>Claim ID</th>
                            <th>Claim Number</th>
                            <th>Insurance Name</th>
                            <th>Customer Name</th>
                            <th>Customer Email</th>
                            <th>Customer Phone</th>
                            <th>Filing Date</th>
                            <th>Incident Date</th>
                            <th>Reason</th>
                            <th>Admin Notes</th>
                            <th>Status</th>
                            <%-- The "Actions" column header is removed as buttons are now collective --%>
                        </tr>
                    </thead>
                    <tbody>
                        <c:forEach var="claim" items="${claimedInsurances}">
                            <tr>
                                <td>${claim.id}</td>
                                <td>${claim.claimNumber}</td>
                                <td>${claim.insuranceName}</td>
                                <td>${claim.customerName}</td>
                                <td>${claim.customerEmail}</td>
                                <td>${claim.customerPhone}</td>
                                <td>${claim.filingDate}</td>
                                <td>${claim.incidentDate}</td>
                                <td>${claim.reason}</td>
                                <td>${claim.adminNotes}</td>
                                <td>
                                    <%-- Using 'approved' for EL as the getter is isApproved() --%>
                                    <c:if test="${claim.approved}">Approved</c:if>
                                    <c:if test="${!claim.approved}">Pending/Rejected</c:if>
                                    <%-- If you want to display the 'status' string directly from your Claim entity's 'status' field: --%>
                                    <%-- <td>${claim.status}</td> --%>
                                </td>
                                <%-- Individual action buttons are removed from here --%>
                            </tr>
                        </c:forEach>
                    </tbody>
                </table>
            </c:when>
            <c:otherwise>
                <p class="no-records">No claimed insurances found.</p>
            </c:otherwise>
        </c:choose>

        <a href="/admin/dashboard" class="back-link">Back to Dashboard</a>
    </div>
</body>
</html>