<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib uri="jakarta.tags.core" prefix="c" %>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Edit Insurance Policy</title>
    <style>
        body { font-family: Arial, sans-serif; background-color: #f4f4f4; margin: 0; padding: 0; display: flex; flex-direction: column; min-height: 100vh; }
        .header { background-color: #333; color: white; padding: 15px 20px; display: flex; justify-content: space-between; align-items: center; }
        .header h1 { margin: 0; font-size: 24px; }
        .header nav ul { list-style: none; margin: 0; padding: 0; display: flex; }
        .header nav ul li { margin-left: 20px; }
        .header nav ul li a { color: white; text-decoration: none; font-weight: bold; }
        .header nav ul li a:hover { text-decoration: underline; }
        .container { padding: 20px; max-width: 600px; margin: 20px auto; background-color: #fff; border-radius: 8px; box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1); flex-grow: 1; }
        h2 { color: #007bff; text-align: center; margin-bottom: 20px; }
        form { display: flex; flex-direction: column; gap: 15px; }
        form label { font-weight: bold; margin-bottom: 5px; display: block; }
        form input[type="text"],
        form input[type="number"] {
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 4px;
            width: 100%;
            box-sizing: border-box; /* Ensures padding doesn't increase total width */
        }
        form button {
            background-color: #28a745;
            color: white;
            padding: 12px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            margin-top: 10px;
            transition: background-color 0.3s ease;
        }
        form button:hover {
            background-color: #218838;
        }
        .back-link { display: block; text-align: center; margin-top: 20px; text-decoration: none; color: #007bff; }
        .back-link:hover { text-decoration: underline; }
        .error-message { color: red; text-align: center; margin-bottom: 10px; }
        .success-message { color: green; text-align: center; margin-bottom: 10px; }
    </style>
</head>
<body>
    <div class="header">
        <h1>Admin Panel</h1>
        <nav>
            <ul>
                <li><a href="/admin/dashboard">Dashboard</a></li>
                <li><a href="/logout">Logout</a></li>
            </ul>
        </nav>
    </div>

    <div class="container">
        <h2>Edit Insurance Policy</h2>

        <c:if test="${not empty errorMessage}">
            <p class="error-message"><c:out value="${errorMessage}"/></p>
        </c:if>
        <c:if test="${not empty successMessage}">
            <p class="success-message"><c:out value="${successMessage}"/></p>
        </c:if>

        <c:choose>
            <c:when test="${empty insurance}">
                <p class="no-records">No insurance policy found with the given ID.</p>
                <a href="/admin/insurance/viewAll" class="back-link">Back to All Policies</a>
            </c:when>
            <c:otherwise>
                <form action="/admin/insurance/update" method="post">
                    <input type="hidden" id="id" name="id" value="<c:out value="${insurance.id}"/>">

                    <label for="name">Policy Name:</label>
                    <input type="text" id="name" name="name" value="<c:out value="${insurance.name}"/>" required>

                    <label for="coverage">Coverage:</label>
                    <input type="text" id="coverage" name="coverage" value="<c:out value="${insurance.coverage}"/>" required>

                    <label for="amountPerYear">Amount Per Year:</label>
                    <input type="number" id="amountPerYear" name="amountPerYear" value="<c:out value="${insurance.amountPerYear}"/>" step="0.01" required>

                    <button type="submit">Update Policy</button>
                </form>
                <a href="/admin/insurance/viewAll" class="back-link">Back to All Policies</a>
            </c:otherwise>
        </c:choose>
    </div>
</body>
</html>