<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Enquiry List</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        :root {
            --primary-color: #004080; /* Deep Navy */
            --primary-dark: #002D5A; /* Even darker blue for hover/nav */
            --secondary-color: #36A420; /* Forest Green for CTA */
            --accent-color: #7D8A99; /* Cool Grey for subtle text */
            --background-light: #EEF2F6;
            --background-card: #ffffff;
            --text-dark: #333333;
            --text-light: #666666;
            --border-radius-lg: 15px;
            --border-radius-md: 10px;
            --box-shadow-light: 0 4px 10px rgba(0,0,0,0.08);
            --box-shadow-hover: 0 8px 20px rgba(0,0,0,0.15);
        }

        body {
            font-family: 'Roboto', sans-serif;
            background: var(--background-light);
            margin: 0;
            padding: 0;
            color: var(--text-dark);
            line-height: 1.6;
        }

        header {
            background: linear-gradient(to right, var(--primary-color), var(--primary-dark));
            color: white;
            padding: 20px;
            text-align: center;
            box-shadow: var(--box-shadow-light);
        }
        header h1 {
            font-size: 2.5em;
            margin-bottom: 5px;
            font-weight: 700;
        }
        header p {
            font-size: 1.1em;
            opacity: 0.9;
        }

        .container {
            max-width: 1000px;
            margin: 30px auto;
            padding: 0 20px;
        }

        .enquiry-list-section {
            background: var(--background-card);
            padding: 30px;
            border-radius: var(--border-radius-lg);
            box-shadow: var(--box-shadow-light);
            margin-bottom: 30px;
        }

        .enquiry-list-section h2 {
            color: var(--primary-color);
            font-size: 2em;
            margin-bottom: 25px;
            text-align: center;
            position: relative;
            padding-bottom: 10px;
        }
        .enquiry-list-section h2::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 60px;
            height: 3px;
            background-color: var(--primary-color);
            border-radius: 2px;
        }

        .enquiry-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        .enquiry-table th, .enquiry-table td {
            border: 1px solid #e0e0e0;
            padding: 12px 15px;
            text-align: left;
            font-size: 0.95em;
            color: var(--text-dark);
        }

        .enquiry-table th {
            background-color: var(--primary-color);
            color: white;
            font-weight: 500;
            text-transform: uppercase;
        }

        .enquiry-table tr:nth-child(even) {
            background-color: #f8fbfc; /* Light alternating row color */
        }

        .enquiry-table tr:hover {
            background-color: #e6f2ff; /* Lighter blue on hover */
        }
        
        .no-enquiries {
            text-align: center;
            font-size: 1.1em;
            color: var(--text-light);
            padding: 30px;
            border: 1px dashed #ccc;
            border-radius: var(--border-radius-md);
            background-color: #fefefe;
        }

        .back-button-container {
            text-align: center;
            margin-top: 30px;
        }

        .back-button {
            display: inline-flex;
            align-items: center;
            padding: 12px 25px;
            background-color: var(--primary-color);
            color: white;
            border-radius: var(--border-radius-md);
            text-decoration: none;
            font-weight: bold;
            transition: background-color 0.3s ease, transform 0.3s ease, box-shadow 0.3s ease;
            font-size: 1.05em;
            box-shadow: 0 4px 8px rgba(0, 64, 128, 0.3);
        }

        .back-button i {
            margin-right: 8px;
        }

        .back-button:hover {
            background-color: var(--primary-dark);
            transform: translateY(-2px);
            box-shadow: 0 6px 12px rgba(0, 64, 128, 0.4);
        }

        footer {
            text-align: center;
            padding: 30px;
            background-color: var(--primary-dark);
            color: white;
            margin-top: 60px;
            font-size: 0.95em;
        }

        @media (max-width: 768px) {
            .container {
                padding: 0 15px;
            }
            .enquiry-table th, .enquiry-table td {
                padding: 10px;
                font-size: 0.9em;
            }
            .enquiry-table {
                display: block;
                overflow-x: auto;
                white-space: nowrap;
            }
        }
    </style>
</head>
<body>
    <header>
        <h1>Health Care Solutions</h1>
        <p>Enquiry List</p>
    </header>

    <div class="container">
        <div class="enquiry-list-section">
            <h2>Customer Enquiries</h2>

            <c:if test="${empty enquiries}">
                <p class="no-enquiries">No enquiries found at this time.</p>
            </c:if>
            <c:if test="${not empty enquiries}">
                <table class="enquiry-table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Mobile Number</th>
                            <th>Pincode</th>
                            <th>Enquiry Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <c:forEach var="enquiry" items="${enquiries}">
                            <tr>
                                <td>${enquiry.id}</td>
                                <td>${enquiry.name}</td>
                                <td>${enquiry.mobileNumber}</td>
                                <td>${enquiry.pincode}</td>
                                <td>${enquiry.enquiryDate}</td>
                            </tr>
                        </c:forEach>
                    </tbody>
                </table>
            </c:if>

            <div class="back-button-container">
                <a href="/admin/dashboard" class="back-button"><i class="fas fa-arrow-left"></i> Back to Dashboard</a>
            </div>
        </div>
    </div>

    <footer>
        <p>&copy; 2025 Health Care Solutions. All rights reserved. | <a href="#" style="color: white; text-decoration: none;">Privacy Policy</a> | <a href="#" style="color: white; text-decoration: none;">Terms of Service</a></p>
    </footer>
</body>
</html>