<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib uri="jakarta.tags.core" prefix="c" %>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>View All Insurance Policies</title>
    <style>
        body { font-family: Arial, sans-serif; background-color: #f4f4f4; margin: 0; padding: 0; }
        .header { background-color: #333; color: white; padding: 15px 20px; display: flex; justify-content: space-between; align-items: center; }
        .header h1 { margin: 0; font-size: 24px; }
        .header nav ul { list-style: none; margin: 0; padding: 0; display: flex; }
        .header nav ul li { margin-left: 20px; }
        .header nav ul li a { color: white; text-decoration: none; font-weight: bold; }
        .header nav ul li a:hover { text-decoration: underline; }
        .container { padding: 20px; max-width: 900px; margin: 20px auto; background-color: #fff; border-radius: 8px; box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1); }
        h2 { color: #007bff; text-align: center; margin-bottom: 20px; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { padding: 12px; border: 1px solid #ddd; text-align: left; }
        th { background-color: #f2f2f2; }
        .no-records { text-align: center; color: #555; margin-top: 20px; }
        .back-link { display: block; text-align: center; margin-top: 20px; text-decoration: none; color: #007bff; }
        .back-link:hover { text-decoration: underline; }
        .action-links a { margin-right: 10px; text-decoration: none; color: #007bff; }
        .action-links a:hover { text-decoration: underline; }
        .action-links .delete-link { color: #dc3545; } /* Style for delete link */

        /* Style for the PDF button */
        .pdf-export-button {
            display: inline-block;
            padding: 10px 20px;
            background-color: #28a745; /* Green color for success/export */
            color: white;
            text-decoration: none;
            border-radius: 5px;
            font-weight: bold;
            margin-bottom: 20px;
            transition: background-color 0.3s ease;
            float: right; /* Align to the right */
        }
        .pdf-export-button:hover {
            background-color: #218838;
        }
        .table-actions {
            display: flex;
            justify-content: flex-end; /* Aligns items to the end (right) */
            align-items: center;
            margin-bottom: 10px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Admin Panel</h1>
        <nav>
            <ul>
                <li><a href="/admin/dashboard">Dashboard</a></li>
                <li><a href="/logout">Logout</a></li>
            </ul>
        </nav>
    </div>

    <div class="container">
        <h2>All Insurance Policies</h2>

        <div class="table-actions">
            <a href="/admin/insurance/export/pdf" class="pdf-export-button">Save as PDF</a>
        </div>

        <c:if test="${empty allInsurances}">
            <p class="no-records">No insurance policies found.</p>
        </c:if>
        <c:if test="${not empty allInsurances}">
            <table>
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Name</th>
                        <th>Coverage</th>
                        <th>Amount Per Year</th>
                        <%-- 
                        <th>Creation Date</th> Added Creation Date header
                         --%>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <c:forEach var="insurance" items="${allInsurances}">
                        <tr>
                            <td><c:out value="${insurance.id}"/></td>
                            <td><c:out value="${insurance.name}"/></td>
                            <td><c:out value="${insurance.coverage}"/></td>
                            <td><c:out value="${insurance.amountPerYear}"/></td>
                            <%-- 
                            <td><c:out value="${insurance.creationDate}"/></td> Display Creation Date
                             --%>
                            <td class="action-links">
                                <a href="/admin/insurance/edit?id=<c:out value="${insurance.id}"/>">Edit</a>
                                <a href="/admin/insurance/delete?id=<c:out value="${insurance.id}"/>" class="delete-link" onclick="return confirm('Are you sure you want to delete this policy?');">Delete</a>
                            </td>
                        </tr>
                    </c:forEach>
                </tbody>
            </table>
        </c:if>
        <a href="/admin/dashboard" class="back-link">Back to Dashboard</a>
    </div>
</body>
</html>