<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Buy Insurance</title>
<style>
body {
	font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
	background-color: #f5f9ff;
	margin: 0;
	padding: 0;
}

header {
	background-color: #007BFF;
	color: white;
	padding: 20px;
	text-align: center;
}

nav {
	background-color: #e9ecef;
	padding: 10px;
	text-align: center;
}

nav a {
	margin: 0 15px;
	text-decoration: none;
	color: #007BFF;
	font-weight: bold;
}

nav a:hover {
	text-decoration: underline;
}

.container {
	max-width: 600px;
	margin: 40px auto;
	background-color: white;
	padding: 30px;
	border-radius: 12px;
	box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
	text-align: center;
}

.container h2 {
	color: #333;
	margin-bottom: 25px;
}

.container p {
	font-size: 16px;
	margin-bottom: 20px;
}

button {
	padding: 10px 25px;
	background-color: #28a745;
	color: white;
	border: none;
	border-radius: 8px;
	font-size: 16px;
	cursor: pointer;
}

button:hover {
	background-color: #218838;
}

footer {
	text-align: center;
	font-size: 14px;
	color: #777;
	padding: 15px 0;
}
</style>
</head>
<body>
	<header>
		<h1>Buy Insurance</h1>
	</header>

	<nav>
		<a href="newInsurance">Back to Insurance Plans</a> <a
			href="medicalInsurance">Medical Insurance</a> <a href="home">Home</a>
		<a href="logout">Logout</a>
	</nav>

	<div class="container">
		<% String selectedPlan = request.getParameter("plan"); %>
		<h2>
			You are about to buy <span style="color: #007BFF;"><%= selectedPlan %></span>
			Insurance
		</h2>
		<form action="payment" method="post">
			<input type="hidden" name="plan" value="<%= selectedPlan %>">
			<p>Are you sure you want to proceed to the payment gateway?</p>
			<button type="submit">Proceed to Payment</button>
		</form>
	</div>

	<footer> &copy; 2025 Health Care Systems - All rights
		reserved. </footer>
</body>
</html>
