<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Insurance Purchase Details</title>
    <style>
    /* Your CSS remains the same */
    body {
        margin: 0;
        padding: 0;
        background: #e6f0ff;
        font-family: 'Segoe UI', sans-serif;
        display: flex;
        justify-content: center;
        align-items: center;
        min-height: 100vh;
    }

    .container {
        background: #ffffff;
        padding: 25px 30px;
        border-radius: 12px;
        box-shadow: 0 6px 12px rgba(0, 0, 0, 0.1);
        width: 90%;
        max-width: 500px;
    }

    h2 {
        text-align: center;
        color: #333;
        margin-bottom: 20px;
        font-size: 22px;
    }

    .form-group {
        margin-bottom: 15px;
    }

    label {
        display: block;
        margin-bottom: 5px;
        font-weight: 500;
        color: #444;
    }

    input[type="text"],
    input[type="date"],
    input[type="email"],
    input[type="tel"],
    textarea {
        width: 100%;
        padding: 10px 12px;
        font-size: 15px;
        border: 1px solid #ccc;
        border-radius: 8px;
        transition: border-color 0.2s;
    }

    input:focus,
    textarea:focus {
        border-color: #007bff;
        outline: none;
    }

    textarea {
        min-height: 70px;
        resize: vertical;
    }

    button {
        width: 100%;
        padding: 12px;
        background: #007bff;
        border: none;
        border-radius: 8px;
        color: white;
        font-size: 16px;
        cursor: pointer;
        transition: background 0.3s;
    }

    button:hover {
        background: #0056b3;
    }

    .hidden-input {
        display: none;
    }
    </style>
</head>
<body>
    <div class="container">
        <h2>Insurance Purchase Details</h2>
        <form action="/confirmPurchase" method="post">
            <input type="hidden" name="planName" value="${planName}">
            <input type="hidden" name="coverage" value="${coverage}">
            <input type="hidden" name="premium" value="${premium}">
           
            <input type="hidden" name="boughtInsuranceRecordId" value="${boughtInsuranceRecordId}">
            <input type="hidden" name="policyNumber" value="${policyNumber}"> <div class="form-group">
                <label for="fullName">Full Name:</label>
                <input type="text" id="fullName" name="fullName" value="${fullName}" required>
                </div>

            <div class="form-group">
                <label for="dob">Date of Birth:</label>
                <input type="date" id="dob" name="dob" value="${dob}" required>
                </div>

            <div class="form-group">
                <label for="address">Address:</label>
                <textarea id="address" name="address" required>${address}</textarea>
                </div>

            <div class="form-group">
                <label for="phoneNumber">Phone Number:</label>
                <input type="tel" id="phoneNumber" name="phoneNumber" value="${phoneNumber}" required>
                </div>

            <div class="form-group">
                <label for="emailId">Email ID:</label>
                <input type="email" id="emailId" name="emailId" value="${emailId}" required>
                </div>

            <button type="submit">Confirm Purchase</button>
        </form>
    </div>
</body>
</html>