<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Claim Details</title>
    <style>
        body { font-family: Arial, sans-serif; background-color: #f4f4f4; margin: 0; padding: 0; }
        .header { background-color: #333; color: white; padding: 15px 20px; display: flex; justify-content: space-between; align-items: center; }
        .header h1 { margin: 0; font-size: 24px; }
        .header nav ul { list-style: none; margin: 0; padding: 0; display: flex; }
        .header nav ul li { margin-left: 20px; }
        .header nav ul li a { color: white; text-decoration: none; font-weight: bold; }
        .header nav ul li a:hover { text-decoration: underline; }
        .container { padding: 20px; max-width: 800px; margin: 20px auto; background-color: #fff; border-radius: 8px; box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1); }
        h2 { color: #007bff; text-align: center; margin-bottom: 20px; }
        .detail-group { margin-bottom: 15px; border-bottom: 1px solid #eee; padding-bottom: 10px; }
        .detail-group:last-child { border-bottom: none; }
        .detail-group label { font-weight: bold; color: #555; display: block; margin-bottom: 5px; }
        .detail-group p { margin: 0; padding-left: 10px; color: #333; }
        .status-PENDING { color: #ffc107; font-weight: bold; }
        .status-APPROVED { color: #28a745; font-weight: bold; }
        .status-DENIED { color: #dc3545; font-weight: bold; }
        .error-message { color: red; text-align: center; margin-bottom: 15px; }
        .back-link {
            display: block;
            text-align: center;
            margin-top: 30px;
            padding: 10px 15px;
            background-color: #007bff;
            color: white;
            border-radius: 5px;
            text-decoration: none;
            transition: background-color 0.2s;
            width: fit-content;
            margin-left: auto;
            margin-right: auto;
        }
        .back-link:hover {
            background-color: #0056b3;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Claim Details</h1>
        <nav>
            <ul>
                <li><a href="/home">Dashboard</a></li>
                <li><a href="/newInsurance">Buy New Insurance</a></li>
                <li><a href="/viewInsurance">View Policies</a></li>
                <li><a href="/logout">Logout</a></li>
            </ul>
        </nav>
    </div>

    <div class="container">
        <h2>Insurance Claim Details</h2>

        <c:if test="${not empty error}">
            <p class="error-message">${error}</p>
        </c:if>

        <c:choose>
            <c:when test="${not empty claim}">
                <div class="detail-group">
                    <label>Claim ID:</label>
                    <p><c:out value="${claim.id}"/></p>
                </div>
                <div class="detail-group">
                    <label>Policy Number:</label>
                    <p><c:out value="${claim.boughtInsurance.policyNumber}"/></p>
                </div>
                <div class="detail-group">
                    <label>Policy Name:</label>
                    <p><c:out value="${claim.boughtInsurance.insurance.name}"/></p>
                </div>
                <div class="detail-group">
                    <label>Claim Date:</label>
                    <p><fmt:formatDate value="${claim.claimDate}" pattern="dd-MM-yyyy HH:mm"/></p>
                </div>
                <div class="detail-group">
                    <label>Claim Amount:</label>
                    <p><fmt:formatNumber value="${claim.claimAmount}" type="currency" currencySymbol="₹"/></p>
                </div>
                <div class="detail-group">
                    <label>Reason for Claim:</label>
                    <p><c:out value="${claim.reason}"/></p>
                </div>
                <div class="detail-group">
                    <label>Claim Status:</label>
                    <p class="status-${claim.status.replace(' ', '')}"><c:out value="${claim.status}"/></p>
                </div>
                <c:if test="${not empty claim.rejectionReason}">
                    <div class="detail-group">
                        <label>Rejection Reason:</label>
                        <p><c:out value="${claim.rejectionReason}"/></p>
                    </div>
                </c:if>

                <%-- You can add more claim-specific details here if your Claim object has them --%>

            </c:when>
            <c:otherwise>
                <p class="no-records">Claim details not found.</p>
            </c:otherwise>
        </c:choose>

        <a href="/viewInsurance" class="back-link">Back to Policies</a>
    </div>
</body>
</html>