<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Claim Insurance Policy</title>
    <style>
        body { font-family: Arial, sans-serif; background-color: #f4f4f4; margin: 0; padding: 20px; }
        .container { max-width: 600px; margin: 20px auto; background-color: #fff; padding: 30px; border-radius: 8px; box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1); }
        h2 { color: #007bff; text-align: center; margin-bottom: 25px; }
        .form-group { margin-bottom: 15px; }
        label { display: block; margin-bottom: 5px; font-weight: bold; color: #333; }
        input[type="text"], input[type="date"], textarea {
            width: calc(100% - 22px);
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 4px;
            font-size: 16px;
        }
        textarea { resize: vertical; min-height: 100px; }
        button {
            background-color: #28a745;
            color: white;
            padding: 12px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 18px;
            display: block;
            width: 100%;
            margin-top: 20px;
            transition: background-color 0.3s ease;
        }
        button:hover { background-color: #218838; }
        .back-link { display: block; text-align: center; margin-top: 20px; text-decoration: none; color: #007bff; }
        .back-link:hover { text-decoration: underline; }
        .policy-info {
            background-color: #e9ecef;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
            font-size: 0.95em;
            line-height: 1.5;
        }
        .policy-info p {
            margin: 5px 0;
        }
        .error-message {
            color: #dc3545;
            background-color: #f8d7da;
            border: 1px solid #f5c6cb;
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 15px;
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>File a Claim</h2>

        <c:if test="${not empty error}">
            <p class="error-message">${error}</p>
        </c:if>

        <div class="policy-info">
            <p><strong>Policy Number:</strong> <c:out value="${boughtInsurance.policyNumber}"/></p>
            <p><strong>Insurance Plan:</strong> <c:out value="${boughtInsurance.insurance.name}"/></p>
            <p><strong>Customer Name:</strong> <c:out value="${boughtInsurance.name}"/></p>
            <p><strong>Coverage Amount:</strong> <fmt:formatNumber value="${boughtInsurance.insurance.coverage}" type="currency" currencySymbol="₹"/></p>
            <p><strong>Annual Premium:</strong> <fmt:formatNumber value="${boughtInsurance.insurance.amountPerYear}" type="currency" currencySymbol="₹"/></p>
            <p><strong>Purchase Date:</strong> <fmt:formatDate value="${boughtInsurance.purchaseDate}" pattern="dd-MM-yyyy"/></p>
            <p><strong>Expiry Date:</strong> <fmt:formatDate value="${boughtInsurance.expiryDate}" pattern="dd-MM-yyyy"/></p>
            <p><strong>Customer Email:</strong> <c:out value="${boughtInsurance.email}"/></p>
            <p><strong>Customer Phone:</strong> <c:out value="${boughtInsurance.phone}"/></p>
        </div>

        <form action="/submitClaim" method="post">
            <input type="hidden" name="boughtInsuranceId" value="${boughtInsurance.id}">

            <div class="form-group">
                <label for="incidentDate">Date of Incident:</label>
                <input type="date" id="incidentDate" name="incidentDate" required>
            </div>

            <div class="form-group">
                <label for="reason">Reason for Claim (Detailed):</label>
                <textarea id="reason" name="reason" rows="5" required></textarea>
            </div>

            <%-- You might want to add file upload for supporting documents here.
                 This would require enctype="multipart/form-data" on the form
                 and handling MultipartFile in your controller.
            --%>
            <%--
            <div class="form-group">
                <label for="documents">Upload Supporting Documents (e.g., medical reports, police report):</label>
                <input type="file" id="documents" name="documents">
            </div>
            --%>

            <button type="submit">Submit Claim</button>
        </form>
        <a href="/viewInsurance" class="back-link">Cancel and Go Back</a>
    </div>
</body>
</html>