<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Policy Details</title>
    <style>
        body { font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; background-color: #f3f7fc; margin: 0; padding: 0; }
        header { background-color: #007BFF; color: white; padding: 20px; text-align: center; }
        nav { background-color: #e9ecef; padding: 12px; text-align: center; }
        nav a { margin: 0 15px; text-decoration: none; color: #007BFF; font-weight: bold; }
        nav a:hover { text-decoration: underline; }
        .container { max-width: 800px; margin: 40px auto; background-color: white; padding: 30px 40px; border-radius: 12px; box-shadow: 0 4px 12px rgba(0,0,0,0.1); }
        h2 { text-align: center; color: #333; margin-bottom: 25px; }
        .detail-item { margin-bottom: 15px; padding: 10px; border-bottom: 1px solid #eee; }
        .detail-item label { font-weight: bold; display: inline-block; width: 150px; color: #555; }
        .detail-item span { color: #333; }
        .back-button { display: inline-block; margin-top: 30px; padding: 10px 20px; background-color: #6c757d; color: white; text-decoration: none; border-radius: 5px; }
        .back-button:hover { background-color: #5a6268; }
        footer { text-align: center; color: #666; font-size: 14px; padding: 15px 0; margin-top: auto; }
    </style>
</head>
<body>
    <header>
        <h1>Insurance Policy Details</h1>
    </header>

    <nav>
        <a href="medicalInsurance">Medical Insurance</a>
        <a href="home">Home</a>
        <a href="logout">Logout</a>
    </nav>

    <div class="container">
        <h2>Policy Information</h2>
        <div class="detail-item">
            <label>Policy Number:</label><span>${foundPolicy.policyNumber}</span>
        </div>
        <div class="detail-item">
            <label>Purchased By:</label><span>${user.username} (ID: ${user.id})</span>
        </div>
        <div class="detail-item">
            <label>Insurance Type:</label><span>${insurance.name}</span>
        </div>
        <div class="detail-item">
            <label>Purchase Date:</label><fmt:formatDate value="${foundPolicy.purchaseDate}" pattern="yyyy-MM-dd HH:mm"/>
        </div>
        <div class="detail-item">
            <label>Expiry Date:</label><fmt:formatDate value="${foundPolicy.expiryDate}" pattern="yyyy-MM-dd HH:mm"/>
        </div>
        <div class="detail-item">
            <label>Claimed:</label><span>${foundPolicy.claimed ? 'Yes' : 'No'}</span>
        </div>
        <a href="/searchPolicy" class="back-button">Back to Search</a>
    </div>

    <footer>
        &copy; 2025 Uniq Team FSD49 – All rights reserved.
    </footer>
</body>
</html>