<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Search Policy</title>
    <style>
        body { font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; background-color: #f3f7fc; margin: 0; padding: 0; }
        header { background-color: #007BFF; color: white; padding: 20px; text-align: center; }
        nav { background-color: #e9ecef; padding: 12px; text-align: center; }
        nav a { margin: 0 15px; text-decoration: none; color: #007BFF; font-weight: bold; }
        nav a:hover { text-decoration: underline; }
        .container { max-width: 700px; margin: 40px auto; background-color: white; padding: 30px 40px; border-radius: 12px; box-shadow: 0 4px 12px rgba(0,0,0,0.1); }
        h2 { text-align: center; color: #333; margin-bottom: 25px; }
        form div { margin-bottom: 20px; }
        label { display: block; font-weight: bold; margin-bottom: 6px; color: #333; }
        input[type="text"] { width: 100%; padding: 10px; font-size: 15px; border: 1px solid #ccc; border-radius: 6px; box-sizing: border-box; }
        button { background-color: #007BFF; color: white; padding: 12px 25px; font-size: 16px; border: none; border-radius: 8px; cursor: pointer; display: block; margin: 0 auto; }
        button:hover { background-color: #0056b3; }
        footer { text-align: center; color: #666; font-size: 14px; padding: 15px 0; margin-top: auto; }
    </style>
</head>
<body>
    <header>
        <h1>Search Insurance Policy</h1>
    </header>

    <nav>
        <a href="medicalInsurance">Medical Insurance</a>
        <a href="home">Home</a>
        <a href="logout">Logout</a>
    </nav>

    <div class="container">
        <h2>Find Policy Details</h2>
        <form action="/findPolicyDetails" method="get">
            <div>
                <label for="policyNumber">Enter Policy Number:</label>
                <input type="text" id="policyNumber" name="policyNumber" required placeholder="e.g., MED-1678901234567-4567">
            </div>
            <button type="submit">Search</button>
        </form>
    </div>

    <footer>
        &copy; 2025 Uniq Team FSD49 – All rights reserved.
    </footer>
</body>
</html>