<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%-- If you uncommented Option 2 previously, you might still need this line:
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
--%>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Your Insurance Policies</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .header {
            background-color: #333;
            color: white;
            padding: 15px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
        }
        .header nav ul {
            list-style: none;
            margin: 0;
            padding: 0;
            display: flex;
        }
        .header nav ul li {
            margin-left: 20px;
        }
        .header nav ul li a {
            color: white;
            text-decoration: none;
            font-weight: bold;
        }
        .header nav ul li a:hover {
            text-decoration: underline;
        }
        .container {
            padding: 20px;
            max-width: 1200px;
            margin: 20px auto;
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }
        h2 {
            color: #007bff;
            text-align: center;
            margin-bottom: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 10px;
            text-align: left;
            font-size: 14px;
        }
        th {
            background-color: #f2f2f2;
            color: #333;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .no-records {
            text-align: center;
            color: #777;
            padding: 20px;
        }
        .action-button {
            padding: 8px 12px;
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
            transition: background-color 0.2s;
            margin-right: 8px;
            margin-bottom: 5px;
        }
        .action-button.claim-button {
            background-color: #28a745;
        }
        .action-button.claim-button:hover {
            background-color: #218838;
        }
        .action-button.download-button {
            background-color: #17a2b8;
        }
        .action-button.download-button:hover {
            background-color: #138496;
        }
        .action-button.view-details-button {
            background-color: #6c757d;
        }
        .action-button.view-details-button:hover {
            background-color: #5a6268;
        }
        .action-button:hover {
            background-color: #0056b3;
        }

        /* Claim Status specific styling */
        .status-PENDING {
            color: #ffc107; /* Orange */
            font-weight: bold;
        }
        .status-APPROVED {
            color: #28a745; /* Green */
            font-weight: bold;
        }
        .status-DENIED {
            color: #dc3545; /* Red */
            font-weight: bold;
        }
        .status-NoClaimFiled {
            color: #6c757d; /* Grey for no claim */
        }

        .success-message {
            color: green;
            text-align: center;
            margin-bottom: 15px;
        }
        .error-message {
            color: red;
            text-align: center;
            margin-bottom: 15px;
        }

        .back-to-home {
            display: block;
            text-align: center;
            margin-top: 30px;
            padding: 10px 15px;
            background-color: #6c757d;
            color: white;
            border-radius: 5px;
            text-decoration: none;
            transition: background-color 0.2s;
            width: fit-content;
            margin-left: auto;
            margin-right: auto;
        }
        .back-to-home:hover {
            background-color: #5a6268;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Your Insurance Policies</h1>
        <nav>
            <ul>
                <li><a href="/home">Dashboard</a></li>
                <li><a href="/newInsurance">Buy New Insurance</a></li>
                <li><a href="/viewInsurance">View Policies</a></li>
                <li><a href="/logout">Logout</a></li>
            </ul>
        </nav>
    </div>

    <div class="container">
        <h2>Your Purchased Insurance Policies</h2>

        <c:if test="${not empty success}">
            <p class="success-message">${success}</p>
        </c:if>
        <c:if test="${not empty error}">
            <p class="error-message">${error}</p>
        </c:if>

        <c:choose>
            <c:when test="${not empty boughtInsurances}">
                <table>
                    <thead>
                        <tr>
                            <th>Policy Number</th>
                            <th>Plan Name</th>
                            <th>Coverage</th>
                            <th>Premium</th>
                            <th>Purchase Date</th>
                            <th>Expiry Date</th>
                            <th>Claim Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <c:forEach var="boughtInsurance" items="${boughtInsurances}">
                            <%-- Corrected access for NumberFormatException --%>
                            <c:set var="canFileNewClaim" value="${requestScope['canFileNewClaim' += boughtInsurance.id]}" />
                            <c:set var="hasAnyClaimFiled" value="${requestScope['hasAnyClaimFiled' += boughtInsurance.id]}" />
                            <c:set var="ClaimStatus" value="${requestScope['claimStatus' += boughtInsurance.id]}" />
                            <tr>
                                <td><c:out value="${boughtInsurance.policyNumber}"/></td>
                                <td><c:out value="${boughtInsurance.insurance.name}"/></td>
                                <td><fmt:formatNumber value="${boughtInsurance.insurance.coverage}" type="currency" currencySymbol="₹"/></td>
                                <td><fmt:formatNumber value="${boughtInsurance.insurance.amountPerYear}" type="currency" currencySymbol="₹"/></tD>
                                <td><fmt:formatDate value="${boughtInsurance.purchaseDate}" pattern="dd-MM-yyyy"/></td>
                                <td>
                                    <fmt:formatDate value="${boughtInsurance.expiryDate}" pattern="dd-MM-yyyy"/>
                                </td>
                                <td class="status-${ClaimStatus.replace(' ', '')}">
                                    <c:out value="${ClaimStatus}"/>
                                </td>
                                <td>
                                    <%-- Always show Download Invoice button --%>
                                    <a href="/downloadBoughtInvoice?boughtInsuranceId=${boughtInsurance.id}" class="action-button download-button">Download Invoice</a>

                                    <c:choose>
                                        <c:when test="${hasAnyClaimFiled}">
                                            <%-- If *any* claim has been filed (PENDING, APPROVED, or DENIED), prioritize "View Claim Details" --%>
                                            <%-- 
                                            <a href="/viewClaimDetails?boughtInsuranceId=${boughtInsurance.id}" class="action-button view-details-button">View Claim Details</a>
 --%>
                                            <%-- Additionally, allow filing a new claim ONLY IF the latest claim was DENIED. Expiry check removed. --%>
                                            <c:if test="${ClaimStatus eq 'DENIED'}">
                                                <a href="/claimInsuranceForm?boughtInsuranceId=${boughtInsurance.id}" class="action-button claim-button">File a New Claim</a>
                                            </c:if>
                                        </c:when>
                                        <c:when test="${not hasAnyClaimFiled and canFileNewClaim}">
                                            <%-- This condition means no claim has been filed yet, and the policy can be claimed. Expiry check removed. --%>
                                            <a href="/claimInsuranceForm?boughtInsuranceId=${boughtInsurance.id}" class="action-button claim-button">File a Claim</a>
                                        </c:when>
                                        <c:otherwise>
                                            <%-- Fallback for policies where no claim action is available based on current logic --%>
                                        </c:otherwise>
                                    </c:choose>
                                </td>
                            </tr>
                        </c:forEach>
                    </tbody>
                </table>
            </c:when>
            <c:otherwise>
                <p class="no-records">You have not purchased any insurance policies yet.</p>
                <p class="no-records"><a href="/newInsurance" class="action-button">Buy Your First Policy</a></p>
            </c:otherwise>
        </c:choose>

        <a href="/home" class="back-to-home">Back to Home</a>

    </div>
</body>
</html>