/*
 * Decompiled with CFR 0.152.
 */
package com.MedInsuranceV2.Version20.BoughtInsurance;

import com.MedInsuranceV2.Version20.BoughtInsurance.BoughtInsurance;
import com.MedInsuranceV2.Version20.BoughtInsurance.BoughtInsuranceRepository;
import com.MedInsuranceV2.Version20.Insurance.Insurance;
import com.MedInsuranceV2.Version20.User.User;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BoughtInsuranceService {
    @Autowired
    private BoughtInsuranceRepository boughtInsuranceRepository;

    public BoughtInsurance buyInsurance(User user, Insurance insurance) {
        BoughtInsurance boughtInsurance = new BoughtInsurance();
        boughtInsurance.setUser(user);
        boughtInsurance.setInsurance(insurance);
        boughtInsurance.setPurchaseDate(new Date());
        String policyNumber = this.generateUniquePolicyNumber();
        boughtInsurance.setPolicyNumber(policyNumber);
        Date expiryDate = new Date(System.currentTimeMillis() + 31536000000L);
        boughtInsurance.setExpiryDate(expiryDate);
        boughtInsurance.setClaimed(false);
        return (BoughtInsurance)this.boughtInsuranceRepository.save(boughtInsurance);
    }

    private String generateUniquePolicyNumber() {
        return "POL-" + UUID.randomUUID().toString().substring(0, 8).toUpperCase();
    }

    public List<BoughtInsurance> getBoughtInsuranceByUser(User user) {
        List<BoughtInsurance> list = this.boughtInsuranceRepository.findByUser(user);
        System.out.println("DEBUG: In BoughtInsuranceService, fetching for user: " + user.getId() + ". Found " + list.size() + " records.");
        return list;
    }

    public List<BoughtInsurance> getAllClaimedInsurances() {
        return this.boughtInsuranceRepository.findByClaimed(true);
    }

    public void updateClaimStatus(Long boughtInsuranceId, boolean status) {
        Optional optionalBoughtInsurance = this.boughtInsuranceRepository.findById(boughtInsuranceId);
        if (!optionalBoughtInsurance.isPresent()) {
            throw new RuntimeException("Bought Insurance with ID " + boughtInsuranceId + " not found.");
        }
        BoughtInsurance boughtInsurance = (BoughtInsurance)optionalBoughtInsurance.get();
        boughtInsurance.setClaimed(status);
        this.boughtInsuranceRepository.save(boughtInsurance);
    }

    public List<BoughtInsurance> getBoughtInsurancesByYear(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, 0, 1, 0, 0, 0);
        calendar.set(14, 0);
        Date startDate = calendar.getTime();
        calendar.set(year, 11, 31, 23, 59, 59);
        calendar.set(14, 999);
        Date endDate = calendar.getTime();
        return this.boughtInsuranceRepository.findByPurchaseDateBetween(startDate, endDate);
    }

    public Optional<BoughtInsurance> findById(long id) {
        return this.boughtInsuranceRepository.findById(id);
    }

    public List<BoughtInsurance> getAllBoughtInsurances() {
        return this.boughtInsuranceRepository.findAll();
    }

    public Optional<BoughtInsurance> findByPolicyNumber(String policyNumber) {
        return this.boughtInsuranceRepository.findByPolicyNumber(policyNumber);
    }

    public void save(BoughtInsurance boughtInsurance) {
        this.boughtInsuranceRepository.save(boughtInsurance);
    }

    public List<BoughtInsurance> getBoughtInsurancesByInsurancePlanName(String planName) {
        return this.boughtInsuranceRepository.findByInsurance_NameContainingIgnoreCase(planName);
    }

    public List<BoughtInsurance> findBoughtInsurancesByUserId(Long userId) {
        return this.boughtInsuranceRepository.findByUserId(userId);
    }
}

