/*
 * Decompiled with CFR 0.152.
 */
package com.MedInsuranceV2.Version20.Claim;

import com.MedInsuranceV2.Version20.BoughtInsurance.BoughtInsurance;
import com.MedInsuranceV2.Version20.User.User;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;

@Entity
@Table(name="claims")
public class Claim {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne
    @JoinColumn(name="bought_insurance_id", nullable=false)
    private BoughtInsurance boughtInsurance;
    @ManyToOne
    @JoinColumn(name="user_id", nullable=false)
    private User user;
    @Column(name="insurance_name", nullable=false)
    private String insuranceName;
    @Column(name="incident_date", nullable=false)
    @Temporal(value=TemporalType.DATE)
    private Date incidentDate;
    @Column(name="reason", columnDefinition="TEXT", nullable=false)
    private String reason;
    @Column(name="filing_date", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date filingDate = new Date();
    @Column(name="status", nullable=false)
    private String status = "PENDING";
    @Column(name="admin_notes", columnDefinition="TEXT")
    private String adminNotes;
    @Column(name="customer_name_at_claim", nullable=false)
    private String customerName;
    @Column(name="customer_email_at_claim", nullable=false)
    private String customerEmail;
    @Column(name="customer_phone_at_claim", nullable=false)
    private String customerPhone;
    private boolean isApproved;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public boolean isApproved() {
        return this.isApproved;
    }

    public void setApproved(boolean isApproved) {
        this.isApproved = isApproved;
    }

    public String getInsuranceName() {
        return this.insuranceName;
    }

    public void setInsuranceName(String insuranceName) {
        this.insuranceName = insuranceName;
    }

    public BoughtInsurance getBoughtInsurance() {
        return this.boughtInsurance;
    }

    public void setBoughtInsurance(BoughtInsurance boughtInsurance) {
        this.boughtInsurance = boughtInsurance;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Date getIncidentDate() {
        return this.incidentDate;
    }

    public void setIncidentDate(Date incidentDate) {
        this.incidentDate = incidentDate;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public Date getFilingDate() {
        return this.filingDate;
    }

    public void setFilingDate(Date filingDate) {
        this.filingDate = filingDate;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getAdminNotes() {
        return this.adminNotes;
    }

    public void setAdminNotes(String adminNotes) {
        this.adminNotes = adminNotes;
    }

    public String getCustomerName() {
        return this.customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getCustomerEmail() {
        return this.customerEmail;
    }

    public void setCustomerEmail(String customerEmail) {
        this.customerEmail = customerEmail;
    }

    public String getCustomerPhone() {
        return this.customerPhone;
    }

    public void setCustomerPhone(String customerPhone) {
        this.customerPhone = customerPhone;
    }

    public String getClaimNumber() {
        return this.boughtInsurance.getPolicyNumber() + "-" + this.id;
    }
}

