/*
 * Decompiled with CFR 0.152.
 */
package com.MedInsuranceV2.Version20.Claim;

import com.MedInsuranceV2.Version20.Claim.Claim;
import com.MedInsuranceV2.Version20.Claim.ClaimRepository;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ClaimService {
    @Autowired
    private ClaimRepository claimRepository;

    @Transactional
    public Claim saveClaim(Claim claim) {
        return (Claim)this.claimRepository.save(claim);
    }

    @Transactional(readOnly=true)
    public Optional<Claim> findClaimById(Long id) {
        return this.claimRepository.findById(id);
    }

    @Transactional(readOnly=true)
    public List<Claim> getAllClaims() {
        return this.claimRepository.findAll();
    }

    @Transactional(readOnly=true)
    public List<Claim> getClaimsByStatus(String status) {
        return this.claimRepository.findByStatus(status);
    }

    @Transactional
    public Claim updateClaim(Claim claim) {
        return (Claim)this.claimRepository.save(claim);
    }

    public List<Claim> findByBoughtInsurance_Id(Long id) {
        return this.claimRepository.findByBoughtInsurance_Id(id);
    }

    public List<Claim> findAllClaimedInsurances() {
        return this.claimRepository.findByIsApprovedTrue();
    }

    public List<Claim> findClaimedInsurancesByName(String insuranceName) {
        return this.claimRepository.findByInsuranceNameContainingIgnoreCaseAndIsApprovedTrue(insuranceName);
    }

    public void save(Claim claim) {
        this.claimRepository.save(claim);
    }
}

