/*
 * Decompiled with CFR 0.152.
 */
package com.MedInsuranceV2.Version20.Controller;

import com.MedInsuranceV2.Version20.BoughtInsurance.BoughtInsurance;
import com.MedInsuranceV2.Version20.BoughtInsurance.BoughtInsuranceService;
import com.MedInsuranceV2.Version20.Claim.Claim;
import com.MedInsuranceV2.Version20.Claim.ClaimService;
import com.MedInsuranceV2.Version20.Claim.PdfGeneratorService;
import com.MedInsuranceV2.Version20.Email.EmailService;
import com.MedInsuranceV2.Version20.Insurance.Insurance;
import com.MedInsuranceV2.Version20.Insurance.InsuranceService;
import com.MedInsuranceV2.Version20.PDF.PdfReportService;
import com.MedInsuranceV2.Version20.User.User;
import com.MedInsuranceV2.Version20.User.UserService;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledFuture;
import lombok.Generated;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/admin"})
public class AdminController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdminController.class);
    @Autowired
    private UserService userService;
    @Autowired
    private InsuranceService insuranceService;
    @Autowired
    private ClaimService claimService;
    @Autowired
    private BoughtInsuranceService boughtInsuranceService;
    @Autowired
    private PdfGeneratorService pdfGeneratorService;
    @Autowired
    private EmailService emailService;
    @Autowired
    private PdfReportService pdfReportService;
    @Autowired
    private ThreadPoolTaskScheduler taskScheduler;
    private ScheduledFuture<?> dailyReportTask;

    @GetMapping(value={"/dashboard"})
    public String adminDashboard(HttpSession session, Model model) {
        Optional<User> user;
        Long userId = (Long)session.getAttribute("userId");
        if (userId != null && (user = this.userService.findUserById(userId)).isPresent() && "ADMIN".equals(user.get().getRole())) {
            model.addAttribute("loggedInAdmin", (Object)user.get());
            model.addAttribute("isSchedulerRunning", (Object)(this.dailyReportTask != null && !this.dailyReportTask.isDone() ? 1 : 0));
            return "Admindashboard";
        }
        return "redirect:/login";
    }

    @PostMapping(value={"/scheduleDailyReport"})
    @ResponseBody
    public ResponseEntity<Map<String, Object>> scheduleDailyReport(HttpSession session) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        User loggedInUser = (User)session.getAttribute("loggedInUser");
        if (loggedInUser == null || !"ADMIN".equals(loggedInUser.getRole())) {
            response.put("success", false);
            response.put("message", "Unauthorized access.");
            return ResponseEntity.status((int)403).body(response);
        }
        if (this.dailyReportTask != null && !this.dailyReportTask.isDone()) {
            response.put("success", false);
            response.put("message", "Daily report scheduler is already running.");
            return ResponseEntity.ok(response);
        }
        try {
            Runnable task = () -> {
                log.info("Attempting to generate and send daily report at {}", (Object)LocalDateTime.now());
                try {
                    byte[] pdfBytes = this.pdfReportService.generateAllBoughtInsurancesPdf(null);
                    ByteArrayInputStream bais = new ByteArrayInputStream(pdfBytes);
                    String adminEmail = "your.admin.email@example.com";
                    if (loggedInUser != null) {
                        adminEmail = loggedInUser.getEmailId();
                    }
                    String subject = "Daily All Bought Insurances Report - " + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                    String body = "Dear Admin,\n\nPlease find attached your daily report on all bought insurance policies.\n\nRegards,\nYour System";
                    String filename = "All_Bought_Insurances_Report_" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")) + ".pdf";
                    this.emailService.sendEmailWithAttachment1(adminEmail, subject, body, bais, filename, "application/pdf");
                    log.info("Daily report successfully generated and sent to {}", (Object)adminEmail);
                }
                catch (Exception e) {
                    log.error("Error generating or sending daily report: {}", (Object)e.getMessage(), (Object)e);
                }
            };
            this.dailyReportTask = this.taskScheduler.schedule(task, (Trigger)new CronTrigger("0 */10 * * * ?"));
            response.put("success", true);
            response.put("message", "Daily report scheduler started successfully! Reports will be sent every 10 minutes.");
            log.info("Daily report scheduler initiated by admin: {}", (Object)(loggedInUser != null ? loggedInUser.getName() : "Unknown"));
        }
        catch (Exception e) {
            log.error("Failed to schedule daily report: {}", (Object)e.getMessage(), (Object)e);
            response.put("success", false);
            response.put("message", "Failed to start daily report scheduler: " + e.getMessage());
        }
        return ResponseEntity.ok(response);
    }

    @PostMapping(value={"/stopDailyReport"})
    @ResponseBody
    public ResponseEntity<Map<String, Object>> stopDailyReport(HttpSession session) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        User loggedInUser = (User)session.getAttribute("loggedInUser");
        if (loggedInUser == null || !"ADMIN".equals(loggedInUser.getRole())) {
            response.put("success", false);
            response.put("message", "Unauthorized access.");
            return ResponseEntity.status((int)403).body(response);
        }
        if (this.dailyReportTask != null) {
            boolean cancelled = this.dailyReportTask.cancel(true);
            if (cancelled) {
                this.dailyReportTask = null;
                response.put("success", true);
                response.put("message", "Daily report scheduler stopped successfully.");
                log.info("Daily report scheduler stopped by admin: {}", (Object)(loggedInUser != null ? loggedInUser.getName() : "Unknown"));
            } else {
                response.put("success", false);
                response.put("message", "Failed to stop daily report scheduler. It might have already completed or is running.");
                log.warn("Attempted to stop scheduler but it could not be cancelled. IsDone: {}", (Object)this.dailyReportTask.isDone());
            }
        } else {
            response.put("success", false);
            response.put("message", "Daily report scheduler is not currently running.");
            log.info("Attempted to stop scheduler, but no task was found running.");
        }
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/insurance/viewAll"})
    public String viewAllInsurance(Model model, HttpSession session) {
        Long userId = (Long)session.getAttribute("userId");
        log.info("Manickam");
        if (userId != null && "ADMIN".equals(this.userService.findUserById(userId).get().getRole())) {
            List<Insurance> allInsurances = this.insuranceService.getAllInsurancePolicies();
            model.addAttribute("allInsurances", allInsurances);
            log.info("Manickam");
            return "admin/viewAllInsurance";
        }
        return "redirect:/login";
    }

    @GetMapping(value={"/insurance/add"})
    public String addInsurancePage(Model model, HttpSession session) {
        Long userId = (Long)session.getAttribute("userId");
        if (userId != null && "ADMIN".equals(this.userService.findUserById(userId).get().getRole())) {
            model.addAttribute("insurance", (Object)new Insurance());
            return "admin/addInsurance";
        }
        return "redirect:/login";
    }

    @PostMapping(value={"/insurance/add"})
    public String addInsurance(@ModelAttribute Insurance insurance, HttpSession session) {
        Long userId = (Long)session.getAttribute("userId");
        if (userId != null && "ADMIN".equals(this.userService.findUserById(userId).get().getRole())) {
            this.insuranceService.addInsurance(insurance);
            return "redirect:/admin/insurance/viewAll";
        }
        return "redirect:/login";
    }

    @GetMapping(value={"/insurance/edit"})
    public String showEditInsuranceForm(@RequestParam(value="id") Long id, Model model, RedirectAttributes redirectAttributes) {
        Optional<Insurance> insuranceOptional = this.insuranceService.getInsuranceById(id);
        if (insuranceOptional.isPresent()) {
            model.addAttribute("insurance", (Object)insuranceOptional.get());
            return "admin/editInsurance";
        }
        redirectAttributes.addFlashAttribute("errorMessage", (Object)("Insurance policy with ID " + id + " not found for editing."));
        return "redirect:/admin/insurances";
    }

    @PostMapping(value={"/insurance/update"})
    public String updateInsurance(@ModelAttribute Insurance insurance, RedirectAttributes redirectAttributes) {
        try {
            Insurance updatedPolicy = this.insuranceService.updateInsurance(insurance);
            redirectAttributes.addFlashAttribute("successMessage", (Object)"Insurance policy updated successfully!");
        }
        catch (RuntimeException e) {
            redirectAttributes.addFlashAttribute("errorMessage", (Object)("Failed to update policy: " + e.getMessage()));
            return "redirect:/admin/insurance/edit?id=" + insurance.getId();
        }
        catch (Exception e) {
            redirectAttributes.addFlashAttribute("errorMessage", (Object)("An unexpected error occurred during update: " + e.getMessage()));
            return "redirect:/admin/insurance/edit?id=" + insurance.getId();
        }
        return "redirect:/admin/insurance/viewAll";
    }

    @GetMapping(value={"/insurance/delete"})
    public String deleteInsurance(@RequestParam(value="id") Long id, RedirectAttributes redirectAttributes) {
        try {
            this.insuranceService.deleteInsurance(id);
            redirectAttributes.addFlashAttribute("successMessage", (Object)"Insurance policy deleted successfully!");
        }
        catch (Exception e) {
            redirectAttributes.addFlashAttribute("errorMessage", (Object)("Error deleting insurance policy with ID " + id + ": " + e.getMessage()));
        }
        return "redirect:/admin/insurance/viewAll";
    }

    @GetMapping(value={"/insurance/export/pdf"})
    public void exportInsurancesToPdf(HttpServletResponse response) throws IOException, DocumentException {
        response.setContentType("application/pdf");
        String headerKey = "Content-Disposition";
        String headerValue = "attachment; filename=insurance_policies_" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")) + ".pdf";
        response.setHeader(headerKey, headerValue);
        List<Insurance> allInsurances = this.insuranceService.getAllInsurancePolicies();
        Document document = new Document();
        PdfWriter.getInstance((Document)document, (OutputStream)response.getOutputStream());
        document.open();
        Font titleFont = new Font(Font.FontFamily.HELVETICA, 18.0f, 1, BaseColor.BLUE);
        Font headerFont = new Font(Font.FontFamily.HELVETICA, 10.0f, 1, BaseColor.WHITE);
        Font dataFont = new Font(Font.FontFamily.HELVETICA, 9.0f, 0, BaseColor.BLACK);
        Paragraph title = new Paragraph("Insurance Policies Report");
        PdfPTable table = new PdfPTable(4);
        table.setWidthPercentage(100.0f);
        table.setSpacingBefore(10.0f);
        table.setSpacingAfter(10.0f);
        table.setWidths(new float[]{1.0f, 3.0f, 3.0f, 2.0f});
        PdfPCell cell = new PdfPCell();
        cell.setPadding(8.0f);
        cell.setBackgroundColor(BaseColor.DARK_GRAY);
        cell.setHorizontalAlignment(1);
        cell.setPhrase(new Phrase("ID", headerFont));
        table.addCell(cell);
        cell.setPhrase(new Phrase("Name", headerFont));
        table.addCell(cell);
        cell.setPhrase(new Phrase("Coverage", headerFont));
        table.addCell(cell);
        cell.setPhrase(new Phrase("Amount Per Year", headerFont));
        table.addCell(cell);
        PdfPCell dataCell = new PdfPCell();
        dataCell.setPadding(4.0f);
        dataCell.setHorizontalAlignment(0);
        for (Insurance insurance : allInsurances) {
            dataCell.setPhrase(new Phrase(String.valueOf(insurance.getId()), dataFont));
            table.addCell(dataCell);
            dataCell.setPhrase(new Phrase(insurance.getName(), dataFont));
            table.addCell(dataCell);
            dataCell.setPhrase(new Phrase(insurance.getCoverage() + " INR", dataFont));
            table.addCell(dataCell);
            dataCell.setPhrase(new Phrase(String.valueOf(insurance.getAmountPerYear()), dataFont));
            table.addCell(dataCell);
        }
        document.add((Element)table);
        document.close();
    }

    @GetMapping(value={"/insurance/manageClaims"})
    public String manageClaims(HttpSession session, Model model) {
        User loggedInUser = (User)session.getAttribute("loggedInUser");
        if (loggedInUser == null || !"ADMIN".equals(loggedInUser.getRole()) && !"AGENT".equals(loggedInUser.getRole())) {
            return "redirect:/login?error=unauthorized";
        }
        List<Claim> allClaims = this.claimService.getAllClaims();
        model.addAttribute("allClaims", allClaims);
        return "admin/manageClaims";
    }

    @PostMapping(value={"/insurance/updateClaimStatus"})
    public String updateClaimStatus(@RequestParam(value="claimId") Long claimId, @RequestParam(value="status") String newStatus, @RequestParam(value="adminNotes", required=false) String adminNotes, HttpSession session, Model model) {
        User loggedInUser = (User)session.getAttribute("loggedInUser");
        if (loggedInUser == null || !"ADMIN".equals(loggedInUser.getRole()) && !"AGENT".equals(loggedInUser.getRole())) {
            return "redirect:/login?error=unauthorized";
        }
        Optional<Claim> claimOpt = this.claimService.findClaimById(claimId);
        if (claimOpt.isEmpty()) {
            model.addAttribute("error", (Object)"Claim not found.");
            return "redirect:/admin/insurance/manageClaims";
        }
        Claim claim = claimOpt.get();
        if (!newStatus.equals("APPROVED") && !newStatus.equals("DENIED")) {
            model.addAttribute("error", (Object)"Invalid claim status.");
            return "redirect:/admin/insurance/manageClaims";
        }
        claim.setStatus(newStatus);
        claim.setAdminNotes(adminNotes);
        this.claimService.saveClaim(claim);
        model.addAttribute("success", (Object)"Claim status updated successfully.");
        return "redirect:/admin/insurance/manageClaims";
    }

    @GetMapping(value={"/payments/viewAll"})
    public String viewAllPayments(HttpSession session) {
        Long userId = (Long)session.getAttribute("userId");
        if (userId != null && "ADMIN".equals(this.userService.findUserById(userId).get().getRole())) {
            return "admin/viewAllPayments";
        }
        return "redirect:/login";
    }

    @GetMapping(value={"/payments/settle"})
    public String settlePayments(HttpSession session) {
        Long userId = (Long)session.getAttribute("userId");
        if (userId != null && "ADMIN".equals(this.userService.findUserById(userId).get().getRole())) {
            return "admin/settlePayments";
        }
        return "redirect:/login";
    }

    @GetMapping(value={"/agents/manage"})
    public String manageAgents(HttpSession session) {
        Long userId = (Long)session.getAttribute("userId");
        if (userId != null && "ADMIN".equals(this.userService.findUserById(userId).get().getRole())) {
            return "admin/manageAgents";
        }
        return "redirect:/login";
    }

    @GetMapping(value={"/agents/details"})
    public String agentDetails(HttpSession session) {
        Long userId = (Long)session.getAttribute("userId");
        if (userId != null && "ADMIN".equals(this.userService.findUserById(userId).get().getRole())) {
            return "admin/agentDetails";
        }
        return "redirect:/login";
    }

    @GetMapping(value={"/reports/agent"})
    public String agentReports(@RequestParam(value="year", required=false) Integer year, Model model, HttpSession session) {
        Long userId = (Long)session.getAttribute("userId");
        if (userId != null && "ADMIN".equals(this.userService.findUserById(userId).get().getRole())) {
            int currentYear = Calendar.getInstance().get(1);
            if (year == null) {
                year = currentYear;
            }
            List<BoughtInsurance> annualReports = this.boughtInsuranceService.getBoughtInsurancesByYear(year);
            model.addAttribute("annualReports", annualReports);
            model.addAttribute("selectedYear", (Object)year);
            model.addAttribute("currentYear", (Object)currentYear);
            return "admin/agentReports";
        }
        return "redirect:/login";
    }

    @GetMapping(value={"/reports/insurance"})
    public String insuranceReports(HttpSession session) {
        Long userId = (Long)session.getAttribute("userId");
        if (userId != null && "ADMIN".equals(this.userService.findUserById(userId).get().getRole())) {
            return "admin/insuranceReports";
        }
        return "redirect:/login";
    }

    @GetMapping(value={"/allBoughtInsurances"})
    public String viewAllBoughtInsurances(@RequestParam(value="planName", required=false) String planName, HttpSession session, Model model) {
        List<BoughtInsurance> allBoughtInsurances;
        User loggedInUser = (User)session.getAttribute("loggedInUser");
        if (loggedInUser == null || !"ADMIN".equals(loggedInUser.getRole())) {
            return "redirect:/login?error=unauthorized";
        }
        if (planName != null && !planName.trim().isEmpty()) {
            allBoughtInsurances = this.boughtInsuranceService.getBoughtInsurancesByInsurancePlanName(planName);
            model.addAttribute("planName", (Object)planName);
        } else {
            allBoughtInsurances = this.boughtInsuranceService.getAllBoughtInsurances();
        }
        model.addAttribute("allBoughtInsurances", allBoughtInsurances);
        return "admin/allBoughtInsurancesReport";
    }

    @GetMapping(value={"/reports/allBoughtInsurances/pdf"})
    public void generateAllBoughtInsurancesPdf(@RequestParam(value="planName", required=false) String planName, HttpSession session, HttpServletResponse response) throws IOException, DocumentException {
        String[] headers;
        User loggedInUser = (User)session.getAttribute("loggedInUser");
        if (loggedInUser == null || !"ADMIN".equals(loggedInUser.getRole())) {
            response.sendError(403, "Access Denied: Only administrators can generate this report.");
            return;
        }
        List<BoughtInsurance> allBoughtInsurances = planName != null && !planName.trim().isEmpty() ? this.boughtInsuranceService.getBoughtInsurancesByInsurancePlanName(planName) : this.boughtInsuranceService.getAllBoughtInsurances();
        response.setContentType("application/pdf");
        String filename = planName != null && !planName.trim().isEmpty() ? "Bought_Insurances_Report_" + planName.replaceAll(" ", "_") + ".pdf" : "All_Bought_Insurances_Report.pdf";
        response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
        Document document = new Document();
        PdfWriter.getInstance((Document)document, (OutputStream)response.getOutputStream());
        document.open();
        Font titleFont = FontFactory.getFont((String)"Helvetica-Bold", (float)20.0f, (BaseColor)BaseColor.BLUE);
        Font headerFont = FontFactory.getFont((String)"Helvetica-Bold", (float)12.0f, (BaseColor)BaseColor.WHITE);
        Font normalFont = FontFactory.getFont((String)"Helvetica", (float)10.0f, (BaseColor)BaseColor.BLACK);
        Paragraph title = new Paragraph("All Bought Insurance Policies Report");
        if (planName != null && !planName.trim().isEmpty()) {
            Paragraph paragraph = new Paragraph("Filtered by Plan: " + planName);
        }
        PdfPTable table = new PdfPTable(8);
        table.setWidthPercentage(100.0f);
        table.setSpacingBefore(10.0f);
        table.setWidths(new float[]{1.0f, 2.0f, 1.5f, 1.0f, 1.5f, 1.5f, 1.5f, 1.5f});
        for (String header : headers = new String[]{"Policy No.", "Customer Name", "Insurance Plan", "Premium", "Coverage", "Purchase Date", "Expiry Date", "Email"}) {
            PdfPCell cell = new PdfPCell(new Phrase(header, headerFont));
            cell.setBackgroundColor(BaseColor.DARK_GRAY);
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            cell.setPadding(5.0f);
            table.addCell(cell);
        }
        if (allBoughtInsurances != null && !allBoughtInsurances.isEmpty()) {
            DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd-MM-yyyy");
            for (BoughtInsurance policy : allBoughtInsurances) {
                table.addCell(new Phrase(policy.getPolicyNumber(), normalFont));
                table.addCell(new Phrase(policy.getName(), normalFont));
                table.addCell(new Phrase(policy.getInsurance().getName(), normalFont));
                table.addCell(new Phrase(String.format("\u20b9%.2f", policy.getInsurance().getAmountPerYear()), normalFont));
                table.addCell(new Phrase(String.format("\u20b9%.2f", policy.getInsurance().getCoverage()), normalFont));
                String purchaseDateStr = policy.getPurchaseDate() != null ? policy.getPurchaseDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(dateFormatter) : "N/A";
                table.addCell(new Phrase(purchaseDateStr, normalFont));
                String expiryDateStr = policy.getExpiryDate() != null ? policy.getExpiryDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(dateFormatter) : "N/A";
                table.addCell(new Phrase(expiryDateStr, normalFont));
                table.addCell(new Phrase(policy.getEmail(), normalFont));
            }
        } else {
            PdfPCell noDataCell = new PdfPCell(new Phrase("No bought insurance policies found matching the filter.", normalFont));
            noDataCell.setColspan(8);
            noDataCell.setHorizontalAlignment(1);
            noDataCell.setPadding(10.0f);
            table.addCell(noDataCell);
        }
        document.add((Element)table);
        document.close();
    }

    @GetMapping(value={"/reports/allBoughtInsurances/excel"})
    public void generateAllBoughtInsurancesExcel(@RequestParam(value="planName", required=false) String planName, HttpSession session, HttpServletResponse response) throws IOException {
        User loggedInUser = (User)session.getAttribute("loggedInUser");
        if (loggedInUser == null || !"ADMIN".equals(loggedInUser.getRole())) {
            response.sendError(403, "Access Denied: Only administrators can generate this report.");
            return;
        }
        List<BoughtInsurance> allBoughtInsurances = planName != null && !planName.trim().isEmpty() ? this.boughtInsuranceService.getBoughtInsurancesByInsurancePlanName(planName) : this.boughtInsuranceService.getAllBoughtInsurances();
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        String filename = planName != null && !planName.trim().isEmpty() ? "Bought_Insurances_Report_" + planName.replaceAll(" ", "_") + ".xlsx" : "All_Bought_Insurances_Report.xlsx";
        response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            Sheet sheet = workbook.createSheet("Bought Insurances");
            Row headerRow = sheet.createRow(0);
            String[] headers = new String[]{"Policy Number", "Customer Name", "Customer DOB", "Customer Address", "Customer Phone", "Customer Email", "Insurance Plan", "Coverage", "Premium", "Purchase Date", "Expiry Date"};
            for (int i = 0; i < headers.length; ++i) {
                Cell cell = headerRow.createCell(i);
                cell.setCellValue(headers[i]);
            }
            int rowNum = 1;
            DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            for (BoughtInsurance policy : allBoughtInsurances) {
                Row row = sheet.createRow(rowNum++);
                row.createCell(0).setCellValue(policy.getPolicyNumber());
                row.createCell(1).setCellValue(policy.getName());
                row.createCell(2).setCellValue(policy.getDob() != null ? policy.getDob().format(dateFormatter) : "N/A");
                row.createCell(3).setCellValue(policy.getAddress());
                row.createCell(4).setCellValue(policy.getPhone());
                row.createCell(5).setCellValue(policy.getEmail());
                row.createCell(6).setCellValue(policy.getInsurance().getName());
                row.createCell(7).setCellValue(policy.getInsurance().getCoverage());
                row.createCell(8).setCellValue(policy.getInsurance().getAmountPerYear());
                String purchaseDateStr = policy.getPurchaseDate() != null ? policy.getPurchaseDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(dateFormatter) : "N/A";
                row.createCell(9).setCellValue(purchaseDateStr);
                String expiryDateStr = policy.getExpiryDate() != null ? policy.getExpiryDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(dateFormatter) : "N/A";
                row.createCell(10).setCellValue(expiryDateStr);
            }
            for (int i = 0; i < headers.length; ++i) {
                sheet.autoSizeColumn(i);
            }
            workbook.write((OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            System.err.println("Error generating Excel report: " + e.getMessage());
            response.sendError(500, "Error generating Excel report.");
        }
    }

    @GetMapping(value={"/reports/user"})
    public String userReports(Model model, HttpSession session) {
        Long userId = (Long)session.getAttribute("userId");
        if (userId != null && "ADMIN".equals(this.userService.findUserById(userId).get().getRole())) {
            List<User> users = this.userService.getAllUsers();
            LinkedHashMap<User, List<BoughtInsurance>> userBoughtInsurances = new LinkedHashMap<User, List<BoughtInsurance>>();
            for (User user : users) {
                List<BoughtInsurance> boughtInsurances = this.boughtInsuranceService.getBoughtInsuranceByUser(user);
                userBoughtInsurances.put(user, boughtInsurances);
            }
            model.addAttribute("userBoughtInsurances", userBoughtInsurances);
            return "admin/userReports";
        }
        return "redirect:/login";
    }

    @GetMapping(value={"/reports/claim"})
    public String claimReports(HttpSession session, Model model, @RequestParam(name="insuranceName", required=false) String insuranceName) {
        Optional<User> userOptional;
        Long userId = (Long)session.getAttribute("userId");
        System.out.println("Accessing /reports/claim. User ID: " + userId);
        if (userId != null && (userOptional = this.userService.findUserById(userId)).isPresent()) {
            User user = userOptional.get();
            System.out.println("User role: " + user.getRole());
            if ("ADMIN".equals(user.getRole())) {
                List<Claim> claimedInsurances;
                if (insuranceName != null && !insuranceName.isEmpty()) {
                    claimedInsurances = this.claimService.findClaimedInsurancesByName(insuranceName);
                    System.out.println("Claims fetched by name. Count: " + claimedInsurances.size());
                } else {
                    claimedInsurances = this.claimService.getAllClaims();
                    System.out.println("All claims fetched. Count: " + claimedInsurances.size());
                }
                model.addAttribute("claimedInsurances", claimedInsurances);
                model.addAttribute("currentFilter", (Object)insuranceName);
                return "admin/claimReports";
            }
        }
        System.out.println("Redirecting to login: User not found or not ADMIN.");
        return "redirect:/login";
    }

    @GetMapping(value={"/reports/claim/download-all-pdf"})
    public ResponseEntity<InputStreamResource> downloadAllClaimsPdf(@RequestParam(name="insuranceName", required=false) String insuranceName) {
        List<Claim> claims = insuranceName != null && !insuranceName.isEmpty() ? this.claimService.findClaimedInsurancesByName(insuranceName) : this.claimService.findAllClaimedInsurances();
        byte[] bis = this.pdfGeneratorService.generateClaimPdf(claims);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Disposition", "inline; filename=all_claim_reports.pdf");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentType(MediaType.APPLICATION_PDF).body((Object)new InputStreamResource((InputStream)new ByteArrayInputStream(bis)));
    }

    @GetMapping(value={"/reports/claim/send-all-email"})
    public String sendAllClaimsEmail(@RequestParam(name="insuranceName", required=false) String insuranceName, HttpSession session, RedirectAttributes redirectAttributes) {
        List<Claim> claims;
        Long userId = (Long)session.getAttribute("userId");
        log.info("Accessing /reports/claim/send-all-email. User ID: {}", (Object)userId);
        if (userId == null) {
            return "redirect:/login";
        }
        Optional<User> userOptional = this.userService.findUserById(userId);
        if (userOptional.isEmpty() || !"ADMIN".equals(userOptional.get().getRole())) {
            return "redirect:/login";
        }
        if (insuranceName != null && !insuranceName.isEmpty()) {
            log.info("Filtering by insuranceName: " + insuranceName);
            claims = this.claimService.findClaimedInsurancesByName(insuranceName);
        } else {
            log.info("Fetching all claims (no insuranceName filter).");
            claims = this.claimService.findAllClaimedInsurances();
        }
        if (claims.isEmpty()) {
            redirectAttributes.addFlashAttribute("error", (Object)"No claims found to send report for.");
            return "redirect:/admin/reports/claim" + (String)(insuranceName != null && !insuranceName.isEmpty() ? "?insuranceName=" + insuranceName : "");
        }
        try {
            byte[] pdfBytes = this.pdfGeneratorService.generateClaimPdf(claims);
            String toEmail = "manickaraj1516@gmail.com";
            String subject = "Comprehensive Claims Report" + (String)(insuranceName != null && !insuranceName.isEmpty() ? " (Filtered by: " + insuranceName + ")" : "");
            String body = "Dear Admin,\n\nPlease find the attached PDF report containing details of " + claims.size() + " claims" + (String)(insuranceName != null && !insuranceName.isEmpty() ? " filtered by insurance name: " + insuranceName : "") + ".\n\nRegards,\nYour Healthcare System";
            String attachmentName = "claims_report" + (String)(insuranceName != null && !insuranceName.isEmpty() ? "_" + insuranceName.replace(" ", "_") : "") + ".pdf";
            String attachmentContentType = "application/pdf";
            this.emailService.sendEmailWithAttachment(toEmail, subject, body, pdfBytes, attachmentName, attachmentContentType);
            redirectAttributes.addFlashAttribute("message", (Object)("Claims report email sent successfully for " + claims.size() + " claims!"));
        }
        catch (Exception e) {
            redirectAttributes.addFlashAttribute("error", (Object)("Failed to send claims report email. Error: " + e.getMessage()));
            e.printStackTrace();
        }
        return "redirect:/admin/reports/claim" + (String)(insuranceName != null && !insuranceName.isEmpty() ? "?insuranceName=" + insuranceName : "");
    }
}

