/*
 * Decompiled with CFR 0.152.
 */
package com.MedInsuranceV2.Version20.Controller;

import com.MedInsuranceV2.Version20.Email.RegistrationService;
import com.MedInsuranceV2.Version20.User.User;
import exception.AdminRegistrationRestrictedException;
import exception.EmailSendingException;
import exception.UserAlreadyExistsException;
import jakarta.servlet.http.HttpSession;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class RegistrationController {
    @Autowired
    private RegistrationService registrationService;

    @PostMapping(value={"/sendOtpForRegistration"})
    public String sendOtpForRegistration(@RequestParam String name, @RequestParam String mobileNumber, @RequestParam String emailId, @RequestParam String password, @RequestParam String confirmPassword, @RequestParam String role, Model model) throws AdminRegistrationRestrictedException {
        if (!password.equals(confirmPassword)) {
            model.addAttribute("error", (Object)"Passwords do not match.");
            model.addAttribute("name", (Object)name);
            model.addAttribute("mobileNumber", (Object)mobileNumber);
            model.addAttribute("emailId", (Object)emailId);
            model.addAttribute("role", (Object)role);
            return "register";
        }
        try {
            User pendingUser = this.registrationService.prepareUserForRegistration(name, mobileNumber, emailId, password, role);
            this.registrationService.generateAndSendRegistrationOtp(emailId, role, pendingUser);
            model.addAttribute("successMessage", (Object)("OTP sent to " + emailId + ". Please check your email."));
            model.addAttribute("showOtpSection", (Object)true);
            model.addAttribute("emailId", (Object)emailId);
            model.addAttribute("role", (Object)role);
            return "register";
        }
        catch (EmailSendingException | UserAlreadyExistsException e) {
            model.addAttribute("error", (Object)e.getMessage());
            model.addAttribute("name", (Object)name);
            model.addAttribute("mobileNumber", (Object)mobileNumber);
            model.addAttribute("emailId", (Object)emailId);
            model.addAttribute("role", (Object)role);
            return "register";
        }
        catch (Exception e) {
            System.err.println("An unexpected error occurred during registration initiation: " + e.getMessage());
            e.printStackTrace();
            model.addAttribute("error", (Object)"An unexpected error occurred during registration. Please try again.");
            model.addAttribute("name", (Object)name);
            model.addAttribute("mobileNumber", (Object)mobileNumber);
            model.addAttribute("emailId", (Object)emailId);
            model.addAttribute("role", (Object)role);
            return "register";
        }
    }

    @PostMapping(value={"/verifyOtpAndRegister"})
    public String verifyOtpAndRegister(@RequestParam String otp, @RequestParam String emailId, HttpSession session) {
        if (emailId == null || emailId.isEmpty()) {
            throw new RuntimeException("Email is missing. Please provide a valid email.");
        }
        System.out.println("Email received for OTP verification: " + emailId);
        this.registrationService.verifyAndCompleteRegistration(emailId, otp);
        return "redirect:/login";
    }

    @PostMapping(value={"/resendOtpForRegistration"})
    @ResponseBody
    public Map<String, Object> resendOtpForRegistration(@RequestParam String emailId, @RequestParam String role) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            User pendingUser = this.registrationService.getPendingUser(emailId);
            if (pendingUser == null) {
                response.put("success", false);
                response.put("message", "Registration session expired. Please restart registration.");
                return response;
            }
            this.registrationService.generateAndSendRegistrationOtp(emailId, role, pendingUser);
            response.put("success", true);
            response.put("message", "New OTP sent successfully!");
        }
        catch (EmailSendingException e) {
            response.put("success", false);
            response.put("message", "Failed to resend OTP: " + e.getMessage());
        }
        catch (Exception e) {
            System.err.println("Error resending OTP for " + emailId + ": " + e.getMessage());
            e.printStackTrace();
            response.put("success", false);
            response.put("message", "An unexpected error occurred while trying to resend OTP.");
        }
        return response;
    }
}

