/*
 * Decompiled with CFR 0.152.
 */
package com.MedInsuranceV2.Version20.Controller;

import com.MedInsuranceV2.Version20.BoughtInsurance.BoughtInsurance;
import com.MedInsuranceV2.Version20.BoughtInsurance.BoughtInsuranceService;
import com.MedInsuranceV2.Version20.Claim.Claim;
import com.MedInsuranceV2.Version20.Claim.ClaimService;
import com.MedInsuranceV2.Version20.Email.EmailService;
import com.MedInsuranceV2.Version20.Insurance.Insurance;
import com.MedInsuranceV2.Version20.Insurance.InsuranceService;
import com.MedInsuranceV2.Version20.User.User;
import com.MedInsuranceV2.Version20.User.UserService;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
public class WebController {
    @Autowired
    private UserService userService;
    @Autowired
    private InsuranceService insuranceService;
    @Autowired
    private BoughtInsuranceService boughtInsuranceService;
    @Autowired
    private EmailService emailService;
    @Autowired
    private ClaimService claimService;

    @RequestMapping(value={"/homepage"})
    public String index() {
        return "index";
    }

    @GetMapping(value={"/login"})
    public String loginPage() {
        return "Model2LoginRegister";
    }

    @PostMapping(value={"/login"})
    public String login(@RequestParam(value="emailId") String emailId, @RequestParam(value="password") String password, HttpSession session, Model model) {
        Optional<User> user = this.userService.findUserByEmail(emailId);
        if (user.isPresent() && user.get().getPassword().equals(password)) {
            User loggedInUser = user.get();
            session.setAttribute("userId", (Object)loggedInUser.getId());
            session.setAttribute("loggedInUser", (Object)loggedInUser);
            session.setAttribute("username", (Object)loggedInUser.getName());
            if ("ADMIN".equals(loggedInUser.getRole())) {
                return "redirect:/admin/dashboard";
            }
            return "redirect:/home";
        }
        model.addAttribute("error", (Object)"Invalid credentials");
        return "login";
    }

    @GetMapping(value={"/register"})
    public String registerPage() {
        return "register";
    }

    @PostMapping(value={"/register"})
    public String register(@ModelAttribute User user, @RequestParam(value="confirmPassword") String confirmPassword, Model model) {
        if (!user.getPassword().equals(confirmPassword)) {
            model.addAttribute("error", (Object)"Passwords do not match!");
            return "register";
        }
        this.userService.registerUser(user);
        return "redirect:/login";
    }

    @GetMapping(value={"/home"})
    public String home(HttpSession session, Model model) {
        Long userId = (Long)session.getAttribute("userId");
        if (userId != null) {
            return "home";
        }
        return "redirect:/login";
    }

    @GetMapping(value={"/medicalInsurance"})
    public String medicalInsurance(HttpSession session) {
        Long userId = (Long)session.getAttribute("userId");
        if (userId != null) {
            return "medicalInsurance";
        }
        return "redirect:/login";
    }

    @GetMapping(value={"/newInsurance"})
    public String showNewInsurancePlans(Model model) {
        List<Insurance> allInsurancePolicies = this.insuranceService.getAllInsurancePolicies();
        model.addAttribute("insurancePlans", allInsurancePolicies);
        return "newInsurance";
    }

    @GetMapping(value={"/processBuy"})
    public String processBuyInsurance(@RequestParam(value="planName") String planName, @RequestParam(value="planId") Long planId, HttpSession session, Model model) {
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            return "redirect:/login";
        }
        Optional<User> user = this.userService.findUserById(userId);
        Optional<Insurance> insurance = this.insuranceService.findById(planId);
        if (user.isPresent() && insurance.isPresent()) {
            BoughtInsurance boughtInsurance = this.boughtInsuranceService.buyInsurance(user.get(), insurance.get());
            String generatedPolicyNumber = boughtInsurance.getPolicyNumber();
            return "redirect:/buyInsuranceDetails?planName=" + planName + "&coverage=" + insurance.get().getCoverage() + "&premium=" + insurance.get().getAmountPerYear() + "&boughtInsuranceId=" + boughtInsurance.getId() + "&policyNumber=" + generatedPolicyNumber;
        }
        return "redirect:/newInsurance?error=buyFailed";
    }

    @GetMapping(value={"/buyInsuranceDetails"})
    public String buyInsuranceDetails(@RequestParam(value="planName") String planName, @RequestParam(value="coverage") double coverage, @RequestParam(value="premium") double premium, @RequestParam(value="boughtInsuranceId") Long boughtInsuranceId, @RequestParam(value="policyNumber") String policyNumber, Model model) {
        model.addAttribute("planName", (Object)planName);
        model.addAttribute("coverage", (Object)coverage);
        model.addAttribute("premium", (Object)premium);
        model.addAttribute("boughtInsuranceRecordId", (Object)boughtInsuranceId);
        model.addAttribute("policyNumber", (Object)policyNumber);
        return "buyInsuranceDetails";
    }

    @PostMapping(value={"/confirmPurchase"})
    public String confirmPurchase(@RequestParam(value="planName") String planName, @RequestParam(value="coverage") double coverage, @RequestParam(value="premium") double premium, @RequestParam(value="fullName") String fullName, @RequestParam(value="dob") String dob, @RequestParam(value="address") String address, @RequestParam(value="phoneNumber") String phoneNumber, @RequestParam(value="emailId") String emailId, @RequestParam(value="boughtInsuranceRecordId") Long boughtInsuranceRecordId, @RequestParam(value="policyNumber") String policyNumber, HttpSession session, Model model) {
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            return "redirect:/login";
        }
        Optional<User> userOpt = this.userService.findUserById(userId);
        if (userOpt.isPresent()) {
            Optional<BoughtInsurance> boughtInsuranceOpt = this.boughtInsuranceService.findById(boughtInsuranceRecordId);
            if (boughtInsuranceOpt.isPresent()) {
                BoughtInsurance boughtInsurance = boughtInsuranceOpt.get();
                boughtInsurance.setName(fullName);
                boughtInsurance.setAddress(address);
                boughtInsurance.setEmail(emailId);
                boughtInsurance.setPhone(phoneNumber);
                try {
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                    boughtInsurance.setDob(LocalDate.parse(dob, formatter));
                }
                catch (DateTimeParseException e) {
                    System.err.println("Error parsing DOB: " + dob + " - " + e.getMessage());
                    model.addAttribute("error", (Object)"Invalid Date of Birth format. Please use YYYY-MM-DD.");
                    return "buyInsuranceDetails";
                }
                this.boughtInsuranceService.save(boughtInsurance);
                String subject = "Insurance Purchase Confirmation for " + planName;
                String body = "Dear " + fullName + ",\n\nThank you for purchasing " + planName + " insurance from us.\nYour policy number is: " + policyNumber + "\nYour policy details and invoice have been sent to your email.\n\nRegards,\nMedInsurance Team";
                this.emailService.sendSimpleEmail(emailId, subject, body);
                model.addAttribute("planName", (Object)planName);
                model.addAttribute("coverage", (Object)coverage);
                model.addAttribute("premium", (Object)premium);
                model.addAttribute("fullName", (Object)fullName);
                model.addAttribute("dob", (Object)dob);
                model.addAttribute("address", (Object)address);
                model.addAttribute("phoneNumber", (Object)phoneNumber);
                model.addAttribute("emailId", (Object)emailId);
                model.addAttribute("policyNumber", (Object)policyNumber);
                DateTimeFormatter pdfDateFormatter = DateTimeFormatter.ofPattern("dd-MM-yyyy");
                String purchaseDateStr = boughtInsurance.getPurchaseDate() != null ? boughtInsurance.getPurchaseDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(pdfDateFormatter) : "N/A";
                String expiryDateStr = boughtInsurance.getExpiryDate() != null ? boughtInsurance.getExpiryDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(pdfDateFormatter) : "N/A";
                model.addAttribute("purchaseDate", (Object)purchaseDateStr);
                model.addAttribute("expiryDate", (Object)expiryDateStr);
                return "triggerDownloadAndRedirect";
            }
            System.err.println("BoughtInsurance record not found for ID: " + boughtInsuranceRecordId);
            model.addAttribute("error", (Object)"Purchase record not found. Please try again.");
            return "redirect:/newInsurance?error=recordNotFound";
        }
        System.err.println("User not found for ID: " + userId);
        model.addAttribute("error", (Object)"User not found. Please login again.");
        return "redirect:/login";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/payment/generateInvoice"})
    public void generateInvoice(@RequestParam(value="planName") String planName, @RequestParam(value="coverage") double coverage, @RequestParam(value="premium") double premium, @RequestParam(value="fullName") String fullName, @RequestParam(value="dob") String dob, @RequestParam(value="address") String address, @RequestParam(value="emailId") String emailId, @RequestParam(value="policyNumber") String policyNumber, @RequestParam(value="purchaseDate") String purchaseDate, @RequestParam(value="expiryDate") String expiryDate, @RequestParam(value="phoneNumber", required=false) String phoneNumber, HttpServletResponse response) throws IOException, DocumentException {
        String displayPhoneNumber = phoneNumber != null && !phoneNumber.trim().isEmpty() ? phoneNumber : "N/A";
        response.setContentType("application/pdf");
        response.setHeader("Content-Disposition", "attachment; filename=\"invoice_" + planName.replaceAll(" ", "_") + ".pdf\"");
        Font headerFont = FontFactory.getFont((String)"Helvetica-Bold", (float)18.0f, (BaseColor)BaseColor.DARK_GRAY);
        Font subHeaderFont = FontFactory.getFont((String)"Helvetica-Bold", (float)12.0f, (BaseColor)BaseColor.BLACK);
        Font normalFont = FontFactory.getFont((String)"Helvetica", (float)10.0f, (BaseColor)BaseColor.BLACK);
        Font boldFont = FontFactory.getFont((String)"Helvetica-Bold", (float)10.0f, (BaseColor)BaseColor.BLACK);
        Document document = new Document();
        try {
            PdfWriter.getInstance((Document)document, (OutputStream)response.getOutputStream());
            document.open();
            Paragraph invoiceTitle = new Paragraph("INVOICE", headerFont);
            invoiceTitle.setAlignment(1);
            invoiceTitle.setSpacingAfter(20.0f);
            document.add((Element)invoiceTitle);
            PdfPTable infoTable = new PdfPTable(2);
            infoTable.setWidthPercentage(80.0f);
            infoTable.setSpacingAfter(20.0f);
            infoTable.setWidths(new float[]{1.0f, 1.0f});
            infoTable.setHorizontalAlignment(1);
            PdfPCell customerCell = new PdfPCell();
            customerCell.setBorder(0);
            customerCell.setHorizontalAlignment(0);
            customerCell.addElement((Element)new Paragraph("Bill To:", subHeaderFont));
            customerCell.addElement((Element)new Paragraph("Name: " + fullName, normalFont));
            customerCell.addElement((Element)new Paragraph("DOB: " + dob, normalFont));
            customerCell.addElement((Element)new Paragraph("Address: " + address, normalFont));
            customerCell.addElement((Element)new Paragraph("Phone: " + displayPhoneNumber, normalFont));
            customerCell.addElement((Element)new Paragraph("Email: " + emailId, normalFont));
            infoTable.addCell(customerCell);
            PdfPCell dateCell = new PdfPCell();
            dateCell.setBorder(0);
            dateCell.setHorizontalAlignment(2);
            dateCell.addElement((Element)new Paragraph("Invoice Date:", subHeaderFont));
            dateCell.addElement((Element)new Paragraph(LocalDate.now().format(DateTimeFormatter.ofPattern("dd-MM-yyyy")), normalFont));
            infoTable.addCell(dateCell);
            document.add((Element)infoTable);
            PdfPTable planTable = new PdfPTable(3);
            planTable.setWidthPercentage(80.0f);
            planTable.setSpacingBefore(10.0f);
            planTable.setSpacingAfter(20.0f);
            planTable.setWidths(new float[]{3.0f, 4.0f, 2.0f});
            planTable.setHorizontalAlignment(1);
            PdfPCell cell = new PdfPCell(new Phrase("Description", boldFont));
            cell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            cell.setHorizontalAlignment(1);
            cell.setPadding(5.0f);
            planTable.addCell(cell);
            cell = new PdfPCell(new Phrase("Coverage", boldFont));
            cell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            cell.setHorizontalAlignment(1);
            cell.setPadding(5.0f);
            planTable.addCell(cell);
            cell = new PdfPCell(new Phrase("Premium (Annual)", boldFont));
            cell.setBackgroundColor(BaseColor.LIGHT_GRAY);
            cell.setHorizontalAlignment(1);
            cell.setPadding(5.0f);
            planTable.addCell(cell);
            cell = new PdfPCell(new Phrase("Insurance Plan: " + planName, normalFont));
            cell.setHorizontalAlignment(1);
            cell.setPadding(5.0f);
            planTable.addCell(cell);
            cell = new PdfPCell(new Phrase(String.format("\u20b9%.2f", coverage), normalFont));
            cell.setHorizontalAlignment(1);
            cell.setPadding(5.0f);
            planTable.addCell(cell);
            cell = new PdfPCell(new Phrase(String.format("\u20b9%.2f", premium), normalFont));
            cell.setHorizontalAlignment(1);
            cell.setPadding(5.0f);
            planTable.addCell(cell);
            document.add((Element)planTable);
            PdfPTable totalTable = new PdfPTable(2);
            totalTable.setWidthPercentage(80.0f);
            totalTable.setWidths(new float[]{7.0f, 2.0f});
            totalTable.setHorizontalAlignment(1);
            cell = new PdfPCell(new Phrase("TOTAL AMOUNT DUE", boldFont));
            cell.setBorder(0);
            cell.setHorizontalAlignment(2);
            cell.setPadding(5.0f);
            totalTable.addCell(cell);
            cell = new PdfPCell(new Phrase(String.format("\u20b9%.2f", premium), boldFont));
            cell.setHorizontalAlignment(2);
            cell.setPadding(5.0f);
            totalTable.addCell(cell);
            document.add((Element)totalTable);
            Paragraph thankYou = new Paragraph("Thank you for your purchase!", normalFont);
            thankYou.setAlignment(1);
            thankYou.setSpacingBefore(30.0f);
            document.add((Element)thankYou);
            Paragraph contactInfo = new Paragraph("For any inquiries, please contact us at support@example.com", normalFont);
            contactInfo.setAlignment(1);
            document.add((Element)contactInfo);
        }
        finally {
            if (document != null && document.isOpen()) {
                document.close();
            }
        }
    }

    @GetMapping(value={"/viewInsurance"})
    public String viewInsurance(HttpSession session, Model model, @RequestParam(value="success", required=false) String successMessage, @RequestParam(value="error", required=false) String errorMessage, RedirectAttributes redirectAttributes) {
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            redirectAttributes.addFlashAttribute("error", (Object)"Please log in to view your policies.");
            return "redirect:/login";
        }
        Optional<User> userOpt = this.userService.findUserById(userId);
        if (userOpt.isEmpty()) {
            System.err.println("User ID " + userId + " found in session but not in database.");
            redirectAttributes.addFlashAttribute("error", (Object)"User not found. Please log in again.");
            return "redirect:/login";
        }
        if (successMessage != null) {
            model.addAttribute("success", (Object)successMessage);
        }
        if (errorMessage != null) {
            model.addAttribute("error", (Object)errorMessage);
        }
        List<BoughtInsurance> boughtInsurances = this.boughtInsuranceService.findBoughtInsurancesByUserId(userId);
        Date currentDateTime = new Date();
        for (BoughtInsurance bi : boughtInsurances) {
            List<Claim> claimsForPolicy = this.claimService.findByBoughtInsurance_Id(bi.getId());
            String displayClaimStatus = "No Claim Filed";
            boolean hasAnyClaimFiled = !claimsForPolicy.isEmpty();
            boolean canFileNewClaim = false;
            if (hasAnyClaimFiled) {
                Claim latestClaim;
                Optional<Claim> latestClaimOpt = claimsForPolicy.stream().max(Comparator.comparing(Claim::getFilingDate));
                if (latestClaimOpt.isPresent() && (displayClaimStatus = (latestClaim = latestClaimOpt.get()).getStatus()).equals("DENIED")) {
                    canFileNewClaim = true;
                }
            } else {
                canFileNewClaim = true;
            }
            System.out.println("Policy ID: " + bi.getId() + ", Claim Status: " + displayClaimStatus + ", Can File New Claim: " + canFileNewClaim + ", Has Any Claim Filed: " + hasAnyClaimFiled);
            model.addAttribute("claimStatus" + bi.getId(), (Object)displayClaimStatus);
            model.addAttribute("canFileNewClaim" + bi.getId(), (Object)canFileNewClaim);
            model.addAttribute("hasAnyClaimFiled" + bi.getId(), (Object)hasAnyClaimFiled);
        }
        model.addAttribute("boughtInsurances", boughtInsurances);
        model.addAttribute("currentDateTime", (Object)currentDateTime);
        return "showBoughtInsurance";
    }

    @GetMapping(value={"/downloadBoughtInvoice"})
    public void downloadBoughtInvoice(@RequestParam(value="boughtInsuranceId") Long boughtInsuranceId, HttpServletResponse response) throws IOException, DocumentException {
        Optional<BoughtInsurance> boughtInsuranceOpt = this.boughtInsuranceService.findById(boughtInsuranceId);
        if (boughtInsuranceOpt.isPresent()) {
            BoughtInsurance boughtInsurance = boughtInsuranceOpt.get();
            String planName = boughtInsurance.getInsurance().getName();
            double coverage = boughtInsurance.getInsurance().getCoverage();
            double premium = boughtInsurance.getInsurance().getAmountPerYear();
            String fullName = boughtInsurance.getName();
            String dob = boughtInsurance.getDob() != null ? boughtInsurance.getDob().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) : "N/A";
            String address = boughtInsurance.getAddress();
            String phoneNumber = boughtInsurance.getPhone();
            String emailId = boughtInsurance.getEmail();
            String policyNumber = boughtInsurance.getPolicyNumber();
            DateTimeFormatter pdfDateFormatter = DateTimeFormatter.ofPattern("dd-MM-yyyy");
            String purchaseDateStr = boughtInsurance.getPurchaseDate() != null ? boughtInsurance.getPurchaseDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(pdfDateFormatter) : "N/A";
            String expiryDateStr = boughtInsurance.getExpiryDate() != null ? boughtInsurance.getExpiryDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(pdfDateFormatter) : "N/A";
            this.generateInvoice(planName, coverage, premium, fullName, dob, address, emailId, policyNumber, purchaseDateStr, expiryDateStr, phoneNumber, response);
        } else {
            response.sendError(404, "Invoice not found for the given ID.");
        }
    }

    @GetMapping(value={"/claimInsuranceForm"})
    public String claimInsuranceForm(@RequestParam(value="boughtInsuranceId") Long boughtInsuranceId, HttpSession session, Model model) {
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            return "redirect:/login";
        }
        Optional<BoughtInsurance> boughtInsuranceOpt = this.boughtInsuranceService.findById(boughtInsuranceId);
        if (boughtInsuranceOpt.isPresent()) {
            BoughtInsurance boughtInsurance = boughtInsuranceOpt.get();
            if (!boughtInsurance.getUser().getId().equals(userId)) {
                System.out.println("Unauthorized attempt to access claim form for policy ID: " + boughtInsuranceId + " by user ID: " + userId);
                model.addAttribute("error", (Object)"You are not authorized to claim this policy.");
                return "redirect:/viewInsurance";
            }
            Date currentDate = new Date();
            if (boughtInsurance.isClaimed()) {
                model.addAttribute("error", (Object)"This policy has already been claimed.");
                return "redirect:/viewInsurance";
            }
            if (boughtInsurance.getExpiryDate() != null && boughtInsurance.getExpiryDate().before(currentDate)) {
                model.addAttribute("error", (Object)"This policy has expired and cannot be claimed.");
                return "redirect:/viewInsurance";
            }
            model.addAttribute("boughtInsurance", (Object)boughtInsurance);
            return "claimInsuranceForm";
        }
        model.addAttribute("error", (Object)"Policy not found.");
        return "redirect:/viewInsurance";
    }

    @PostMapping(value={"/submitClaim"})
    public String submitClaim(@RequestParam(value="boughtInsuranceId") Long boughtInsuranceId, @RequestParam(value="incidentDate") String incidentDateStr, @RequestParam(value="reason") String reason, HttpSession session, Model model) throws ParseException {
        Long userId = (Long)session.getAttribute("userId");
        if (userId == null) {
            return "redirect:/login";
        }
        Optional<User> userOpt = this.userService.findUserById(userId);
        if (userOpt.isEmpty()) {
            return "redirect:/login";
        }
        Optional<BoughtInsurance> boughtInsuranceOpt = this.boughtInsuranceService.findById(boughtInsuranceId);
        if (boughtInsuranceOpt.isPresent()) {
            BoughtInsurance boughtInsurance = boughtInsuranceOpt.get();
            if (!boughtInsurance.getUser().getId().equals(userId)) {
                model.addAttribute("error", (Object)"You are not authorized to claim this policy.");
                return "redirect:/viewInsurance";
            }
            Date currentDate = new Date();
            if (boughtInsurance.getExpiryDate() != null && boughtInsurance.getExpiryDate().before(currentDate)) {
                model.addAttribute("error", (Object)"This policy has expired and cannot be claimed.");
                return "redirect:/viewInsurance";
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date incidentDate = sdf.parse(incidentDateStr);
            Claim claim = new Claim();
            claim.setBoughtInsurance(boughtInsurance);
            claim.setFilingDate(new Date());
            claim.setIncidentDate(incidentDate);
            claim.setReason(reason.replace("\n", "<br/>"));
            claim.setStatus("PENDING");
            User currentUser = userOpt.get();
            claim.setUser(currentUser);
            claim.setInsuranceName(boughtInsurance.getInsurance().getName());
            claim.setCustomerName(boughtInsurance.getName());
            claim.setCustomerEmail(boughtInsurance.getEmail());
            claim.setCustomerPhone(boughtInsurance.getPhone());
            this.claimService.save(claim);
            model.addAttribute("success", (Object)"Your claim has been filed successfully and is awaiting review!");
            return "redirect:/viewInsurance";
        }
        model.addAttribute("error", (Object)"Bought Insurance not found.");
        return "redirect:/viewInsurance";
    }

    @GetMapping(value={"/about"})
    public String aboutPage() {
        return "about";
    }

    @GetMapping(value={"/logout"})
    public String logout(HttpSession session) {
        session.invalidate();
        return "index";
    }
}

