/*
 * Decompiled with CFR 0.152.
 */
package com.MedInsuranceV2.Version20.Email;

import com.MedInsuranceV2.Version20.Email.EmailService;
import com.MedInsuranceV2.Version20.Email.OtpService;
import com.MedInsuranceV2.Version20.User.User;
import com.MedInsuranceV2.Version20.User.UserRepository;
import com.MedInsuranceV2.Version20.User.UserService;
import exception.EmailSendingException;
import jakarta.mail.MessagingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RegistrationService {
    @Autowired
    private UserService userService;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private OtpService otpService;
    @Autowired
    private EmailService emailService;

    public String generateAndSendRegistrationOtp(String userEmail, String userRole, User pendingUser) {
        String recipientEmail = "ADMIN".equalsIgnoreCase(userRole) ? "manickaraj1516@gmail.com" : userEmail;
        String otp = this.otpService.generateAndStoreOtp(userEmail, pendingUser);
        try {
            this.emailService.sendOtpEmail(recipientEmail, otp);
            return otp;
        }
        catch (MessagingException e) {
            throw new EmailSendingException("Failed to send OTP email to " + recipientEmail + ".", e);
        }
    }

    public User prepareUserForRegistration(String name, String mobileNumber, String emailId, String password, String role) {
        User user = new User();
        user.setName(name);
        user.setMobileNumber(mobileNumber);
        user.setEmailId(emailId);
        user.setPassword(password);
        user.setRole(role);
        return user;
    }

    public boolean verifyAndCompleteRegistration(String email, String enteredOtp) {
        if (email == null || email.isEmpty()) {
            throw new RuntimeException("Email is missing. Please provide a valid email.");
        }
        boolean isValidOtp = this.otpService.validateOtp(email, enteredOtp);
        if (!isValidOtp) {
            throw new RuntimeException("Invalid or expired OTP for email: " + email);
        }
        User pendingUser = this.otpService.getPendingUser(email);
        if (pendingUser == null) {
            throw new RuntimeException("No pending registration found for email: " + email);
        }
        this.userRepository.save(pendingUser);
        this.otpService.removeOtp(email);
        return isValidOtp;
    }

    public User getPendingUser(String emailId) {
        User pendingUser = this.otpService.getPendingUser(emailId);
        if (pendingUser == null) {
            throw new RuntimeException("No pending registration found for email: " + emailId);
        }
        return pendingUser;
    }
}

