/*
 * Decompiled with CFR 0.152.
 */
package com.MedInsuranceV2.Version20.Medicine;

import com.MedInsuranceV2.Version20.Medicine.Medicine;
import com.MedInsuranceV2.Version20.Medicine.MedicineService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class MedicineController {
    @Autowired
    private MedicineService medicineService;

    @GetMapping(value={"/medicineByLocation"})
    public String medicineByLocationPage() {
        return "medicineByLocation";
    }

    @GetMapping(value={"/medicineByLocation/search"})
    public String findMedicinesByLocation(@RequestParam String location, Model model) {
        try {
            List<Medicine> medicines = this.medicineService.getMedicinesByLocation(location);
            model.addAttribute("medicines", medicines);
            return "medicineByLocation";
        }
        catch (MedicineService.MedicineServiceException e) {
            model.addAttribute("error", (Object)("Medicine Mismatch: " + e.getMessage()));
            return "medicineByLocation";
        }
    }
}

