package com.MedInsuranceV2.Version20.Claim;


import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;

import com.MedInsuranceV2.Version20.BoughtInsurance.BoughtInsurance;
import com.MedInsuranceV2.Version20.User.User;

import java.util.Date; // For incident date and claim filing date

@Entity
@Table(name = "claims") // Table name for claims
public class Claim {

 @Id
 @GeneratedValue(strategy = GenerationType.IDENTITY)
 private Long id;

 @ManyToOne
 @JoinColumn(name = "bought_insurance_id", nullable = false)
 private BoughtInsurance boughtInsurance; // Link to the specific bought policy

 @ManyToOne
 @JoinColumn(name = "user_id", nullable = false) // Link to the user who filed the claim
 private User user;

 @Column(name = "insurance_name", nullable = false)
 private String insuranceName;
 
 
 @Column(name = "incident_date", nullable = false)
 @Temporal(TemporalType.DATE)
 private Date incidentDate; // Date of the incident

 @Column(name = "reason", columnDefinition = "TEXT", nullable = false)
 private String reason; // Detailed reason for the claim

 @Column(name = "filing_date", nullable = false)
 @Temporal(TemporalType.TIMESTAMP)
 private Date filingDate; // When the claim was filed

 @Column(name = "status", nullable = false)
 private String status; // PENDING, APPROVED, DENIED

 @Column(name = "admin_notes", columnDefinition = "TEXT")
 private String adminNotes; // Notes from admin/agent upon approval/denial

 // --- NEW FIELDS FOR CUSTOMER DETAILS DIRECTLY IN CLAIM ENTITY ---
 @Column(name = "customer_name_at_claim", nullable = false)
 private String customerName; // Name of the customer at the time of claim filing

 @Column(name = "customer_email_at_claim", nullable = false)
 private String customerEmail; // Email of the customer at the time of claim filing

 @Column(name = "customer_phone_at_claim", nullable = false)
 private String customerPhone; // Phone of the customer at the time of claim filing
 // --- END NEW FIELDS ---

 private boolean isApproved;
 
 

 // Constructors
 public Claim() {
     this.filingDate = new Date(); // Set filing date automatically on creation
     this.status = "PENDING";      // Set initial status to PENDING
 }

 // Getters and Setters
 public Long getId() { return id; }
 public void setId(Long id) { this.id = id; }

 public boolean isApproved() { return isApproved; }
 public void setApproved(boolean isApproved) { this.isApproved = isApproved; }
 
 
 public String getInsuranceName() { return insuranceName; }
 public void setInsuranceName(String insuranceName) { this.insuranceName = insuranceName; }
 
 public BoughtInsurance getBoughtInsurance() { return boughtInsurance; }
 public void setBoughtInsurance(BoughtInsurance boughtInsurance) { this.boughtInsurance = boughtInsurance; } // Corrected typo here

 public User getUser() { return user; }
 public void setUser(User user) { this.user = user; }

 public Date getIncidentDate() { return incidentDate; }
 public void setIncidentDate(Date incidentDate) { this.incidentDate = incidentDate; }

 public String getReason() { return reason; }
 public void setReason(String reason) { this.reason = reason; }

 public Date getFilingDate() { return filingDate; }
 public void setFilingDate(Date filingDate) { this.filingDate = filingDate; }

 public String getStatus() { return status; }
 public void setStatus(String status) { this.status = status; }

 public String getAdminNotes() { return adminNotes; }
 public void setAdminNotes(String adminNotes) { this.adminNotes = adminNotes; }

 // --- Getters and Setters for the new customer details fields ---
 public String getCustomerName() { return customerName; }
 public void setCustomerName(String customerName) { this.customerName = customerName; }

 public String getCustomerEmail() { return customerEmail; }
 public void setCustomerEmail(String customerEmail) { this.customerEmail = customerEmail; }

 public String getCustomerPhone() { return customerPhone; }
 public void setCustomerPhone(String customerPhone) { this.customerPhone = customerPhone; }
 // --- End Getters and Setters for new fields ---

public String getClaimNumber() {
	
	return boughtInsurance.getPolicyNumber() + "-" + id; // Assuming policy number is unique and part of the claim number
}
}
