package com.MedInsuranceV2.Version20.Email;// Or your chosen package

import org.springframework.beans.factory.annotation.Autowired;

//... (other imports)

import org.springframework.stereotype.Service;

import com.MedInsuranceV2.Version20.User.User;
import com.MedInsuranceV2.Version20.User.UserRepository;
import com.MedInsuranceV2.Version20.User.UserService;

import exception.EmailSendingException;

@Service
public class RegistrationService {

 // ... (dependencies: userService, otpService, emailService)
@Autowired
 private UserService userService;
@Autowired
 private UserRepository userRepository; // Assuming you have a UserRepository for database operations
@Autowired
 private OtpService otpService;
@Autowired
 private EmailService emailService;
 // Constructor injection for dependencies

 // ... (prepareUserForRegistration method)

 public String generateAndSendRegistrationOtp(String userEmail, String userRole, User pendingUser) {
     String recipientEmail; // This variable will hold the email address to send the OTP to

     // --- THIS IS THE LOGIC THAT FULFILLS YOUR REQUIREMENT ---
     if ("ADMIN".equalsIgnoreCase(userRole)) { // Check if the role is ADMIN (case-insensitive)
         recipientEmail = "manickaraj1516@gmail.com"; // Set recipient to the fixed admin email
     } else {
         recipientEmail = userEmail; // For any other role (like USER), use the user's provided email
     }
     // --- END OF LOGIC ---

     // Generate and store OTP (associated with the user's actual email, for verification later)
     String otp = otpService.generateAndStoreOtp(userEmail, pendingUser);

     try {
         // Send OTP to the determined recipient email
         emailService.sendOtpEmail(recipientEmail, otp);
         return otp;
     } catch (jakarta.mail.MessagingException e) {
         // Handle email sending failure
         throw new EmailSendingException("Failed to send OTP email to " + recipientEmail + ".", e);
     }
 }

public User prepareUserForRegistration(String name, String mobileNumber, String emailId, String password, String role) {
		// Create a new User object with the provided details
	User user = new User();
	user.setName(name);
	user.setMobileNumber(mobileNumber);
	user.setEmailId(emailId);
	user.setPassword(password); // In a real application, you should hash the password before saving
	user.setRole(role); // Set the role (e.g., USER or ADMIN)

	// Perform any additional validation or processing if needed
	return user;
 }

public boolean verifyAndCompleteRegistration(String email, String enteredOtp) {
    if (email == null || email.isEmpty()) {
        throw new RuntimeException("Email is missing. Please provide a valid email.");
    }

    // Validate OTP
    boolean isValidOtp = otpService.validateOtp(email, enteredOtp);
    if (!isValidOtp) {
        throw new RuntimeException("Invalid or expired OTP for email: " + email);
    }

    // Retrieve pending user
    User pendingUser = otpService.getPendingUser(email);
    if (pendingUser == null) {
        throw new RuntimeException("No pending registration found for email: " + email);
    }

    // Complete registration (e.g., save user to the database)
    userRepository.save(pendingUser);

    // Clear OTP after successful registration
    otpService.removeOtp(email);
	return isValidOtp;
}


public User getPendingUser(String emailId) {
		// Retrieve the pending user associated with the provided email
	User pendingUser = otpService.getPendingUser(emailId);
	if (pendingUser == null) {
		throw new RuntimeException("No pending registration found for email: " + emailId);
	}
	return pendingUser;
}

 // ... (verifyAndCompleteRegistration and getPendingUser methods)
}
