package com.MedInsuranceV2.Version20.Enquiry;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller // This annotation marks the class as a Spring MVC controller
public class EnquiryController {

    @Autowired // Injects the EnquiryService
    private EnquiryService enquiryService;

   
    @PostMapping("/submitEnquiry")
    public String submitEnquiry(@RequestParam("name") String name,
                                @RequestParam("mobileNumber") String mobileNumber,
                                @RequestParam("pincode") String pincode,
                                RedirectAttributes redirectAttributes) { // Use RedirectAttributes for flash messages
        
        Enquiry enquiry = new Enquiry(name, mobileNumber, pincode);
        enquiryService.saveEnquiry(enquiry); // Save the enquiry to the database

        // Add a success message to be displayed after redirect
        redirectAttributes.addFlashAttribute("message", "Your enquiry has been submitted successfully! We will contact you soon.");
        
        // Redirect back to the main page or a thank you page
        return "redirect:/"; // Redirects to the root URL (which maps to home method)
    }

    // Optional: A page to view all enquiries (for administrative purposes)
    @GetMapping("/viewEnquiries")
    public String viewAllEnquiries(Model model) {
        model.addAttribute("enquiries", enquiryService.getAllEnquiries());
        return "admin/enquiriesList"; // Create a new JSP file named enquiriesList.jsp to display this
    }
}