package com.MedInsuranceV2.Version20.Medicine;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class MedicineService {

    @Autowired
    private MedicineRepository medicineRepository;

    public List<Medicine> getMedicinesByLocation(String location) {
        try {
            return medicineRepository.findByLocationContainingIgnoreCase(location);
        } catch (Exception e) {
            throw new MedicineServiceException("location based medicine search error.", e);
        }
    }

    public static class MedicineServiceException extends RuntimeException {
        public MedicineServiceException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}
