package com.MedInsuranceV2.Version20.PDF;


import com.MedInsuranceV2.Version20.BoughtInsurance.BoughtInsurance;
import com.MedInsuranceV2.Version20.BoughtInsurance.BoughtInsuranceService;
import com.MedInsuranceV2.Version20.Claim.ClaimService;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.text.SimpleDateFormat;
import java.io.ByteArrayOutputStream;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.*;

@Service
public class PdfReportService {

    @Autowired
    private BoughtInsuranceService boughtInsuranceService;

   
    public byte[] generateAllBoughtInsurancesPdf(String planName) throws DocumentException {
        List<BoughtInsurance> allBoughtInsurances;
        if (planName != null && !planName.trim().isEmpty()) {
            allBoughtInsurances = boughtInsuranceService.getBoughtInsurancesByInsurancePlanName(planName);
        } else {
            allBoughtInsurances = boughtInsuranceService.getAllBoughtInsurances();
        }

        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Document document = new Document();
        PdfWriter.getInstance(document, baos);
        document.open();

        Font titleFont = FontFactory.getFont(FontFactory.HELVETICA_BOLD, 20, BaseColor.BLUE);
        Font headerFont = FontFactory.getFont(FontFactory.HELVETICA_BOLD, 12, BaseColor.WHITE);
        Font normalFont = FontFactory.getFont(FontFactory.HELVETICA, 10, BaseColor.BLACK);

        Paragraph title = new Paragraph("All Bought Insurance Policies Report");
        title.setAlignment(Element.ALIGN_CENTER);
        title.setFont(titleFont);
        document.add(title);

        if (planName != null && !planName.trim().isEmpty()) {
            Paragraph filterInfo = new Paragraph("Filtered by Plan: " + planName);
            filterInfo.setAlignment(Element.ALIGN_CENTER);
            filterInfo.setFont(normalFont);
            document.add(filterInfo);
        }

        document.add(new Paragraph(" ")); // Add some space

        PdfPTable table = new PdfPTable(6); // Assuming 7 columns as per typical BoughtInsurance fields
        table.setWidthPercentage(100);
        table.setSpacingBefore(10f);
        table.setSpacingAfter(10f);

        // Define column widths if needed, e.g., table.setWidths(new float[]{...});

        // Add table headers
        PdfPCell cell = new PdfPCell();
        cell.setPadding(8);
        cell.setBackgroundColor(BaseColor.DARK_GRAY);
        cell.setHorizontalAlignment(Element.ALIGN_CENTER);
        cell.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cell.setPhrase(new Phrase("ID", headerFont)); table.addCell(cell);
        cell.setPhrase(new Phrase("User Name", headerFont)); table.addCell(cell);
        cell.setPhrase(new Phrase("Insurance Name", headerFont)); table.addCell(cell);
//        cell.setPhrase(new Phrase("Amount Paid", headerFont)); table.addCell(cell);
        cell.setPhrase(new Phrase("Start Date", headerFont)); table.addCell(cell);
        cell.setPhrase(new Phrase("End Date", headerFont)); table.addCell(cell);
        cell.setPhrase(new Phrase("Claimed Status", headerFont)); table.addCell(cell);


        // Add data rows
        PdfPCell dataCell = new PdfPCell();
        dataCell.setPadding(5);
        dataCell.setHorizontalAlignment(Element.ALIGN_LEFT);
        dataCell.setVerticalAlignment(Element.ALIGN_MIDDLE);
        dataCell.setLeading(0, 1.2f); // Line spacing

        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");

        for (BoughtInsurance boughtInsurance : allBoughtInsurances) {
            dataCell.setPhrase(new Phrase(String.valueOf(boughtInsurance.getId()), normalFont));
            table.addCell(dataCell);
            dataCell.setPhrase(new Phrase(boughtInsurance.getUser().getName(), normalFont));
            table.addCell(dataCell);
            dataCell.setPhrase(new Phrase(boughtInsurance.getInsurance().getName(), normalFont));
            table.addCell(dataCell);

            // Convert Date to LocalDate and format
            LocalDate purchaseDate = Instant.ofEpochMilli(boughtInsurance.getPurchaseDate().getTime())
                                             .atZone(ZoneId.systemDefault())
                                             .toLocalDate();
            dataCell.setPhrase(new Phrase(dateFormatter.format(purchaseDate), normalFont));
            table.addCell(dataCell);

            LocalDate expiryDate = Instant.ofEpochMilli(boughtInsurance.getExpiryDate().getTime())
                                           .atZone(ZoneId.systemDefault())
                                           .toLocalDate();
            dataCell.setPhrase(new Phrase(dateFormatter.format(expiryDate), normalFont));
            table.addCell(dataCell);

            dataCell.setPhrase(new Phrase(boughtInsurance.isClaimed() ? "Claimed" : "Not Claimed", normalFont));
            table.addCell(dataCell);
        }

        document.add(table);
        document.close();

        return baos.toByteArray();
    }
}