package com.MedInsuranceV2.Version20.User;

import java.util.Date;

import jakarta.persistence.*;

@Entity
@Table(name = "users")
public class User {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(nullable = false)
    private String name; // This will be used as firstName in JSP

    private String mobileNumber;

    @Column(nullable = false, unique = true)
    private String emailId;

    @Column(nullable = false)
    private String password;

    @Column(nullable = false)
    private String role; // Role field is now a String again

    @Column(name = "dob") // Date of Birth field
    private Date dob;
    
    @Column(name = "address") // Optional: Address field can be added if needed
    private String address; // Optional: Address field can be added if needed
    // Getter and Setter முறைகள்
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getDob() {
		return dob;
	}
    public void setDob(Date dob) {
    	this.dob = dob;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAddress() {
		return address;
	}
    public void setAddress(String address) {
		this.address = address;
	}
    public String getMobileNumber() {
        return mobileNumber;
    }

    public void setMobileNumber(String mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    public String getEmailId() {
        return emailId;
    }

    public void setEmailId(String emailId) {
        this.emailId = emailId;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getRole() { // Getter for String role
        return role;
    }

    public void setRole(String role) { // Setter for String role
        this.role = role;
    }
}