<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>About Us</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f2f6fa;
            margin: 0;
            padding: 0;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }
        header {
            background-color: #007BFF;
            color: white;
            padding: 20px 0;
            text-align: center;
        }
        main {
            flex: 1;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 40px 20px;
        }
        .about-box {
            background-color: white;
            padding: 30px 40px;
            border-radius: 12px;
            box-shadow: 0 4px 10px rgba(0,0,0,0.1);
            max-width: 600px;
            text-align: center;
        }
        .about-box h1 {
            color: #007BFF;
            margin-bottom: 20px;
        }
        .about-box p {
            font-size: 16px;
            color: #333;
            margin-bottom: 30px;
        }
        .about-box a {
            display: inline-block;
            padding: 10px 20px;
            background-color: #007BFF;
            color: white;
            text-decoration: none;
            border-radius: 8px;
            font-weight: bold;
        }
        .about-box a:hover {
            background-color: #0056b3;
        }
        footer {
            background-color: #eaeaea;
            padding: 10px;
            text-align: center;
            font-size: 14px;
            color: #555;
        }
    </style>
</head>
<body>
    <header>
        <h1>About Us</h1>
    </header>
    <main>
        <div class="about-box">
            <h1>Welcome to Health Care App</h1>
            <p>This application is developed and maintained by <strong>Unip Team FS049</strong>.  
               Our goal is to provide a seamless platform for managing medical insurance and medicine-related services 
               across all locations.</p>
            <a href="/homepage">⬅ Back to Home</a>
        </div>
    </main>
    <footer>
        &copy; 2025 Uniq Team FSD49 - All rights reserved.
    </footer>
</body>
</html>
