<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib uri="jakarta.tags.core" prefix="c" %>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Insurance Reports</title>
    <style>
        body { font-family: Arial, sans-serif; background-color: #f4f4f4; margin: 0; padding: 0; }
        .header { background-color: #333; color: white; padding: 15px 20px; display: flex; justify-content: space-between; align-items: center; }
        .header h1 { margin: 0; font-size: 24px; }
        .header nav ul { list-style: none; margin: 0; padding: 0; display: flex; }
        .header nav ul li { margin-left: 20px; }
        .header nav ul li a { color: white; text-decoration: none; font-weight: bold; }
        .header nav ul li a:hover { text-decoration: underline; }
        .container { padding: 20px; max-width: 900px; margin: 20px auto; background-color: #fff; border-radius: 8px; box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1); }
        h2 { color: #007bff; text-align: center; margin-bottom: 20px; }
        .report-options { text-align: center; margin-bottom: 30px; }
        .report-options button {
            background-color: #28a745;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            margin: 0 10px;
            transition: background-color 0.3s ease;
        }
        .report-options button:hover {
            background-color: #218838;
        }
        .report-options a {
             text-decoration: none;
             color: white;
        }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { border: 1px solid #ddd; padding: 10px; text-align: left; }
        th { background-color: #f2f2f2; color: #333; }
        .no-records { text-align: center; color: #777; padding: 20px; }
        .back-link { display: block; text-align: center; margin-top: 30px; text-decoration: none; color: #007bff; }
        .back-link:hover { text-decoration: underline; }
    </style>
</head>
<body>
    <div class="header">
        <h1>Admin Panel</h1>
        <nav>
            <ul>
                <li><a href="/admin/dashboard">Dashboard</a></li>
                <li><a href="/logout">Logout</a></li>
            </ul>
        </nav>
    </div>

    <div class="container">
        <h2>Insurance Reports</h2>

        <div class="report-options">
            <p>Generate reports in different formats:</p>
            <button onclick="window.location.href='/admin/reports/generate?format=pdf'">Save as PDF</button>
            <button onclick="window.location.href='/admin/reports/generate?format=excel'">Save as Excel</button>
        </div>

        <h3>Bought Insurance Details</h3>
        <c:choose>
            <c:when test="${not empty insurancePolicies}">
                <table>
                    <thead>
                        <tr>
                            <th>Policy ID</th>
                            <th>Policy Name</th>
                            <th>Customer Name</th>
                            <th>Premium</th>
                            <th>Coverage Amount</th>
                            <th>Start Date</th>
                            <th>End Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <c:forEach var="policy" items="${insurancePolicies}">
                            <tr>
                                <td><c:out value="${policy.policyId}"/></td>
                                <td><c:out value="${policy.policyName}"/></td>
                                <td><c:out value="${policy.customerName}"/></td>
                                <td><c:out value="${policy.premium}"/></td>
                                <td><c:out value="${policy.coverageAmount}"/></td>
                                <td><c:out value="${policy.startDate}"/></td>
                                <td><c:out value="${policy.endDate}"/></td>
                            </tr>
                        </c:forEach>
                    </tbody>
                </table>
            </c:when>
            <c:otherwise>
                <p class="no-records">No insurance policies found to display.</p>
            </c:otherwise>
        </c:choose>

        <a href="/admin/dashboard" class="back-link">Back to Dashboard</a>
    </div>
</body>
</html>