<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Manage Claims - Admin/Agent</title>
    <style>
        body { font-family: Arial, sans-serif; background-color: #f4f4f4; margin: 0; padding: 0; }
        .header { background-color: #333; color: white; padding: 15px 20px; display: flex; justify-content: space-between; align-items: center; }
        .header h1 { margin: 0; font-size: 24px; }
        .header nav ul { list-style: none; margin: 0; padding: 0; display: flex; }
        .header nav ul li { margin-left: 20px; }
        .header nav ul li a { color: white; text-decoration: none; font-weight: bold; }
        .header nav ul li a:hover { text-decoration: underline; }
        .container { padding: 20px; max-width: 1200px; margin: 20px auto; background-color: #fff; border-radius: 8px; box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1); }
        h2 { color: #007bff; text-align: center; margin-bottom: 20px; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { border: 1px solid #ddd; padding: 10px; text-align: left; font-size: 14px; }
        th { background-color: #f2f2f2; color: #333; }
        tr:nth-child(even) { background-color: #f9f9f9; }
        .no-records { text-align: center; color: #777; padding: 20px; }
        .action-form { display: flex; align-items: center; gap: 5px; } /* Use flex for alignment */
        .action-form select, .action-form textarea, .action-form button {
            padding: 5px 8px;
            border-radius: 4px;
            border: 1px solid #ccc;
            font-size: 13px;
        }
        .action-form button {
            background-color: #007bff;
            color: white;
            border: none;
            cursor: pointer;
            transition: background-color 0.2s;
        }
        .action-form button:hover { background-color: #0056b3; }

        /* Claim Status specific styling */
        .status-pending { color: #ffc107; font-weight: bold; } /* Orange */
        .status-approved { color: #28a745; font-weight: bold; } /* Green */
        .status-denied { color: #dc3545; font-weight: bold; } /* Red */

        .success-message { color: green; text-align: center; margin-bottom: 15px; }
        .error-message { color: red; text-align: center; margin-bottom: 15px; }
        .notes-area { flex-grow: 1; min-width: 100px; } /* Allow notes to expand */

        .back-link {
            display: block;
            text-align: center;
            margin-top: 30px;
            padding: 10px 15px;
            background-color: #6c757d;
            color: white;
            border-radius: 5px;
            text-decoration: none;
            transition: background-color 0.2s;
            width: fit-content;
            margin-left: auto;
            margin-right: auto;
        }
        .back-link:hover {
            background-color: #5a6268;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Admin/Agent Panel</h1>
        <nav>
            <ul>
                <li><a href="/admin/dashboard">Dashboard</a></li>
                <li><a href="/admin/allBoughtInsurances">All Policies</a></li>
                <!-- 
                <li><a href="/admin/insurance/manageClaims">Manage Claims</a></li>
                 -->
                <li><a href="/logout">Logout</a></li>
            </ul>
        </nav>
    </div>

    <div class="container">
        <h2>Manage Insurance Claims</h2>

        <c:if test="${not empty success}">
            <p class="success-message">${success}</p>
        </c:if>
        <c:if test="${not empty error}">
            <p class="error-message">${error}</p>
        </c:if>

        <c:choose>
            <c:when test="${not empty allClaims}">
                <table>
                    <thead>
                        <tr>
                            <th>Claim ID</th>
                            <th>Policy No.</th>
                            <th>Insurance Plan</th>
                            <th>Customer Name</th>
                            <th>Customer Email</th>
                            <th>Customer Phone</th>
                            <th>Incident Date</th>
                            <th>Reason</th>
                            <th>Filing Date</th>
                            <th>Status</th>
                            <th>Admin Notes</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <c:forEach var="claim" items="${allClaims}">
                            <tr>
                                <td><c:out value="${claim.id}"/></td>
                                <td><c:out value="${claim.boughtInsurance.policyNumber}"/></td>
                                <td><c:out value="${claim.boughtInsurance.insurance.name}"/></td>
                                <td><c:out value="${claim.customerName}"/></td>
                                <td><c:out value="${claim.customerEmail}"/></td>
                                <td><c:out value="${claim.customerPhone}"/></td>
                                <td><fmt:formatDate value="${claim.incidentDate}" pattern="dd-MM-yyyy"/></td>
                                <td>
                                    <%-- This is the change: Replace newlines with <br/> --%>
                                    <c:out value="${fn:replace(claim.reason, fn:substring(CRLF, 0, 1), '<br/>')}" escapeXml="false"/>
                                    <c:set var="CRLF" value="${'&#x0D;&#x0A;'}" />
                                    <c:out value="${fn:replace(claim.reason, CRLF, '<br/>')}" escapeXml="false"/>
                                    <c:out value="${fn:replace(claim.reason, fn:substring(CRLF, 1, 2), '<br/>')}" escapeXml="false"/>
                                    <%-- The above lines are a bit redundant for cross-platform newlines.
                                         A more robust way is to replace both carriage return and newline separately. --%>
                                    <c:set var="reasonWithBr" value="${fn:replace(claim.reason, fn:substring(CRLF, 0, 1), '<br/>')}" />
                                    <c:set var="reasonWithBr" value="${fn:replace(reasonWithBr, fn:substring(CRLF, 1, 2), '<br/>')}" />
                                    <c:out value="${reasonWithBr}" escapeXml="false"/>
                                </td>
                                <td><fmt:formatDate value="${claim.filingDate}" pattern="dd-MM-yyyy HH:mm"/></td>
                                <td class="status-${fn:toLowerCase(claim.status)}"><c:out value="${claim.status}"/></td>
                                <td><c:out value="${claim.adminNotes}"/></td>
                                <td>
                                    <c:if test="${claim.status eq 'PENDING'}">
                                        <form action="/admin/insurance/updateClaimStatus" method="post" class="action-form">
                                            <input type="hidden" name="claimId" value="${claim.id}">
                                            <select name="status" required>
                                                <option value="">Select Action</option>
                                                <option value="APPROVED">Approve</option>
                                                <option value="DENIED">Deny</option>
                                            </select>
                                            <textarea name="adminNotes" class="notes-area" placeholder="Notes (optional)"></textarea>
                                            <button type="submit">Update</button>
                                        </form>
                                    </c:if>
                                    <c:if test="${claim.status ne 'PENDING'}">
                                        No Action
                                    </c:if>
                                </td>
                            </tr>
                        </c:forEach>
                    </tbody>
                </table>
            </c:when>
            <c:otherwise>
                <p class="no-records">No claims found.</p>
            </c:otherwise>
        </c:choose>

        <a href="/admin/dashboard" class="back-link">Back to Admin Dashboard</a>
    </div>
</body>
</html>