<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib uri="jakarta.tags.core" prefix="c" %>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>View All Payments</title>
    <style>
        body { font-family: Arial, sans-serif; background-color: #f4f4f4; margin: 0; padding: 0; }
        .header { background-color: #333; color: white; padding: 15px 20px; display: flex; justify-content: space-between; align-items: center; }
        .header h1 { margin: 0; font-size: 24px; }
        .header nav ul { list-style: none; margin: 0; padding: 0; display: flex; }
        .header nav ul li { margin-left: 20px; }
        .header nav ul li a { color: white; text-decoration: none; font-weight: bold; }
        .header nav ul li a:hover { text-decoration: underline; }
        .container { padding: 20px; max-width: 800px; margin: 20px auto; background-color: #fff; border-radius: 8px; box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1); text-align: center;}
        h2 { color: #007bff; margin-bottom: 20px; }
        p { color: #555; }
        .back-link { display: block; text-align: center; margin-top: 20px; text-decoration: none; color: #007bff; }
        .back-link:hover { text-decoration: underline; }
    </style>
</head>
<body>
    <div class="header">
        <h1>Admin Panel</h1>
        <nav>
            <ul>
                <li><a href="/admin/dashboard">Dashboard</a></li>
                <li><a href="/logout">Logout</a></li>
            </ul>
        </nav>
    </div>

    <div class="container">
        <h2>View All Payments</h2>
        <p>This page will display a list of all payments received.</p>
        <p><i>(Implementation requires 'Payment' entity, repository, and service.)</i></p>
        <a href="/admin/dashboard" class="back-link">Back to Dashboard</a>
    </div>
</body>
</html>