<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Health Care Solutions - Your Trusted Partner</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        :root {
            --primary-color: #004080; /* Deep Navy */
            --primary-dark: #002D5A; /* Even darker blue for hover/nav */
            --secondary-color: #36A420; /* Forest Green for CTA */
            --accent-color: #7D8A99; /* Cool Grey for subtle text */
            --background-light: #EEF2F6; /* Light Grey-Blue */
            --background-card: #ffffff;
            --text-dark: #333333;
            --text-light: #666666;
            --border-radius-lg: 15px;
            --border-radius-md: 10px;
            --box-shadow-light: 0 4px 10px rgba(0,0,0,0.08);
            --box-shadow-hover: 0 8px 20px rgba(0,0,0,0.15);
            --cta-orange: #FF6F42; /* Vibrant Orange for form button */
            --cta-orange-dark: #E65C36; /* Darker orange for hover */
        }

        body {
            font-family: 'Roboto', sans-serif;
            background: var(--background-light);
            margin: 0;
            padding: 0;
            color: var(--text-dark);
            line-height: 1.6;
            overflow-x: hidden; /* Prevent horizontal scroll on some effects */
        }

        /* --- Header --- */
        header {
            background: linear-gradient(to right, var(--primary-color), var(--primary-dark));
            color: white;
            padding: 40px 20px;
            text-align: center;
            box-shadow: 0 6px 15px rgba(0,0,0,0.15); /* Stronger header shadow */
            position: relative; /* For potential future logo positioning */
            z-index: 10; /* Ensure header is above other elements if needed */
        }
        header h1 {
            font-size: 3.2em; /* Slightly larger for impact */
            margin-bottom: 10px;
            font-weight: 700;
            letter-spacing: 1px; /* A little spacing for modern look */
        }
        header p {
            font-size: 1.3em; /* Slightly larger for prominence */
            opacity: 0.95;
            max-width: 800px;
            margin: 0 auto;
        }

        /* --- Navigation --- */
        nav {
            background-color: var(--primary-dark);
            padding: 15px 0;
            text-align: center;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            position: sticky; /* Make navigation sticky */
            top: 0;
            width: 100%;
            z-index: 1000; /* High z-index to stay on top */
        }
        nav a {
            color: white;
            margin: 0 25px; /* More spacing */
            text-decoration: none;
            font-weight: 500;
            font-size: 1.15em; /* Slightly larger nav links */
            transition: color 0.3s ease, transform 0.3s ease, background-color 0.3s ease;
            padding: 8px 15px; /* More padding for clickable area */
            border-radius: var(--border-radius-md); /* Soft rounded corners */
            position: relative;
            display: inline-flex; /* Align icon and text */
            align-items: center;
            gap: 8px; /* Space between icon and text */
        }
        nav a::after {
            content: '';
            position: absolute;
            width: 0;
            height: 3px; /* Thicker underline */
            background: #aaccff; /* Lighter color for underline */
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            transition: width 0.3s ease;
        }
        nav a:hover::after {
            width: calc(100% - 20px); /* Underline shorter than button for visual interest */
        }
        nav a:hover {
            color: #e6f2ff;
            transform: translateY(-2px);
            background-color: var(--primary-color); /* Subtle background change on hover */
        }
        nav a.active {
            color: #e6f2ff;
            background-color: var(--primary-color);
            box-shadow: inset 0 0 10px rgba(0,0,0,0.2); /* Inset shadow for active state */
        }

        /* --- Container --- */
        .container {
            max-width: 1200px;
            margin: 40px auto; /* More vertical margin */
            padding: 0 20px;
        }

        /* --- Section Styles --- */
        .section {
            background: var(--background-card);
            padding: 40px; /* More padding */
            margin-bottom: 30px;
            border-radius: var(--border-radius-lg);
            box-shadow: var(--box-shadow-light);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            border: 1px solid #e0e6eb; /* Subtle border for definition */
        }
        .section:hover {
            transform: translateY(-5px);
            box-shadow: 0 12px 25px rgba(0,0,0,0.18); /* More pronounced hover shadow */
        }
        .section h2 {
            color: var(--primary-color);
            font-size: 2.4em; /* Slightly larger section titles */
            margin-bottom: 25px; /* More space below title */
            text-align: center;
            font-weight: 700;
            position: relative;
            padding-bottom: 15px; /* Space for underline */
        }
        .section h2::after { /* Underline for section titles */
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 70px;
            height: 4px;
            background-color: var(--secondary-color); /* Green underline */
            border-radius: 2px;
        }
        .section .button-group {
            display: flex;
            flex-wrap: wrap;
            gap: 20px; /* More gap */
            justify-content: center;
            margin-top: 30px; /* More space above buttons */
        }
        .section a.button {
            display: inline-flex;
            align-items: center;
            padding: 14px 30px; /* Larger buttons */
            background-color: var(--primary-color);
            color: white;
            border-radius: var(--border-radius-md);
            text-decoration: none;
            font-weight: bold;
            transition: background-color 0.3s ease, transform 0.3s ease, box-shadow 0.3s ease;
            font-size: 1.1em;
            box-shadow: 0 5px 12px rgba(0, 64, 128, 0.4); /* Stronger shadow */
        }
        .section a.button i {
            margin-right: 10px; /* More space for icon */
            font-size: 1.2em;
        }
        .section a.button:hover {
            background-color: var(--primary-dark);
            transform: translateY(-3px); /* More pronounced lift */
            box-shadow: 0 8px 18px rgba(0, 64, 128, 0.5);
        }

        /* --- Why Choose Section --- */
        .why-choose-section {
            text-align: center;
            margin-top: 60px; /* More margin */
            margin-bottom: 60px;
        }
        .why-choose-section h2 {
            color: var(--primary-color);
            font-size: 2.6em; /* Larger title */
            margin-bottom: 40px;
            position: relative;
            padding-bottom: 15px;
        }
        .why-choose-section h2::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 90px; /* Wider underline */
            height: 4px;
            background-color: var(--primary-color);
            border-radius: 2px;
        }
        .why-choose-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); /* Slightly larger min-width for cards */
            gap: 30px;
            justify-content: center;
        }
        .why-choose-card {
            background-color: var(--background-card);
            padding: 35px; /* More padding */
            border-radius: var(--border-radius-lg);
            box-shadow: var(--box-shadow-light);
            text-align: center;
            transition: transform 0.3s ease, box-shadow 0.3s ease, border-color 0.3s ease;
            border: 1px solid #dbe2e8; /* More prominent subtle border */
        }
        .why-choose-card:hover {
            transform: translateY(-10px); /* More pronounced lift */
            box-shadow: 0 15px 30px rgba(0,0,0,0.2); /* Stronger hover shadow */
            border-color: var(--primary-color); /* Highlight border on hover */
        }
        .why-choose-card img {
            max-width: 100px; /* Larger icons */
            height: auto;
            margin-bottom: 20px;
            filter: drop-shadow(0 5px 10px rgba(0,0,0,0.15)); /* Stronger icon shadow */
        }
        .why-choose-card h3 {
            font-size: 2.5em; /* Larger count */
            color: var(--primary-dark);
            margin-bottom: 8px;
            font-weight: 700;
        }
        .why-choose-card h3 .count {
            display: block;
            font-size: 1.3em;
        }
        .why-choose-card p {
            font-size: 1.15em; /* Larger text */
            color: var(--text-light);
        }

        /* --- What is Health Insurance Section --- */
        .what-is-health-insurance-section {
            display: flex;
            flex-wrap: wrap;
            align-items: center;
            justify-content: space-between;
            background: var(--background-card);
            padding: 40px; /* More padding */
            margin-top: 60px; /* More margin */
            border-radius: var(--border-radius-lg);
            box-shadow: var(--box-shadow-light);
            gap: 40px; /* More gap */
            border: 1px solid #e0e6eb;
        }
        .what-is-health-insurance-section .image-wrapper {
            flex: 1;
            min-width: 400px; /* Increased min-width for image */
            text-align: center;
        }
        .what-is-health-insurance-section .image-wrapper img {
            max-width: 100%;
            height: auto;
            border-radius: var(--border-radius-md);
            box-shadow: 0 10px 20px rgba(0,0,0,0.15); /* Stronger image shadow */
        }
        .what-is-health-insurance-section .content-wrapper {
            flex: 1.2;
            min-width: 400px; /* Increased min-width for content */
            text-align: left;
        }
        .what-is-health-insurance-section .content-wrapper h2 {
            color: var(--primary-color);
            font-size: 2.4em; /* Larger title */
            margin-top: 0;
            margin-bottom: 25px;
            text-align: left;
            font-weight: 700;
        }
        .what-is-health-insurance-section .content-wrapper p {
            font-size: 1.1em; /* Slightly larger text */
            line-height: 1.8; /* More comfortable line height */
            margin-bottom: 20px;
            color: var(--text-dark);
        }
        .what-is-health-insurance-section .content-wrapper .buy-button {
            display: inline-block;
            padding: 16px 35px; /* Larger button */
            background-color: var(--secondary-color);
            color: white;
            border-radius: var(--border-radius-md);
            text-decoration: none;
            font-weight: bold;
            transition: background-color 0.3s ease, transform 0.3s ease, box-shadow 0.3s ease;
            font-size: 1.2em; /* Larger font size */
            box-shadow: 0 5px 12px rgba(54, 164, 32, 0.4);
            margin-top: 15px; /* Space above button */
        }
        .what-is-health-insurance-section .content-wrapper .buy-button:hover {
            background-color: #2F8D1A;
            transform: translateY(-3px);
            box-shadow: 0 8px 18px rgba(54, 164, 32, 0.5);
        }

        /* --- Stats Section --- */
        .stats {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); /* Slightly larger min-width for stats */
            gap: 30px;
            margin-top: 60px; /* More margin */
            text-align: center;
        }
        .stat-card {
            background-color: var(--background-card);
            padding: 35px; /* More padding */
            border-radius: var(--border-radius-lg);
            box-shadow: var(--box-shadow-light);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            border: 1px solid #e0e6eb;
        }
        .stat-card:hover {
            transform: translateY(-7px); /* More pronounced lift */
            box-shadow: 0 12px 25px rgba(0,0,0,0.18);
        }
        .stat-card h3 {
            font-size: 3.2em; /* Larger numbers */
            color: var(--primary-dark);
            margin-bottom: 10px;
            font-weight: 700;
        }
        .stat-card p {
            font-size: 1.15em; /* Larger text */
            color: var(--text-light);
        }

        /* --- Video Section --- */
        .video-section {
            text-align: center;
            margin-top: 60px; /* More margin */
            background: var(--background-card);
            padding: 50px; /* More padding */
            border-radius: var(--border-radius-lg);
            box-shadow: var(--box-shadow-light);
            border: 1px solid #e0e6eb;
        }
        .video-section h2 {
            color: var(--primary-color);
            font-size: 2.6em; /* Larger title */
            margin-bottom: 30px;
            position: relative;
            padding-bottom: 15px;
        }
        .video-section h2::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 90px;
            height: 4px;
            background-color: var(--primary-color);
            border-radius: 2px;
        }
        .video-section video {
            width: 100%;
            max-width: 900px; /* Larger video player */
            border-radius: var(--border-radius-md);
            margin-top: 25px;
            box-shadow: 0 8px 20px rgba(0,0,0,0.2); /* Stronger video shadow */
            outline: none;
            border: 2px solid var(--primary-color); /* Border around video */
        }

        /* --- Enquiry Form Section --- */
        .enquiry-section {
            display: flex;
            background: #fff;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.15); /* More prominent shadow */
            overflow: hidden;
            margin: 60px auto; /* More margin */
            max-width: 950px; /* Slightly wider */
            border: 1px solid #e0e6eb;
        }

        .enquiry-left {
            flex: 1.2; /* Slightly larger left section */
            background: linear-gradient(to bottom right, #eaf4ff, #d7e8ff); /* More vibrant gradient */
            padding: 40px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            text-align: center;
            position: relative;
            overflow: hidden;
        }

        .enquiry-left img {
            max-width: 90%; /* Slightly smaller to give space */
            height: auto;
            display: block;
            margin: 0 auto;
            border-radius: 10px;
            box-shadow: 0 8px 20px rgba(0,0,0,0.15); /* Stronger image shadow */
        }

        .enquiry-overlay-text {
            position: absolute;
            top: 25px; /* Adjust position */
            right: 25px; /* Adjust position */
            background: rgba(255, 255, 255, 0.95); /* More opaque */
            padding: 12px 18px; /* More padding */
            border-radius: 10px; /* More rounded */
            font-weight: 600; /* Bolder text */
            color: var(--primary-color);
            box-shadow: 0 4px 10px rgba(0,0,0,0.1);
            display: flex;
            align-items: center;
            gap: 8px; /* More gap */
            font-size: 0.95em;
        }
         .enquiry-overlay-text img.icon {
            width: 24px; /* Larger icon */
            height: 24px;
            vertical-align: middle;
        }


        .enquiry-bottom-left-badge {
            position: absolute;
            bottom: 25px; /* Adjust position */
            left: 25px; /* Adjust position */
            background: rgba(255, 255, 255, 0.95);
            padding: 12px 18px;
            border-radius: 10px;
            font-weight: 600;
            color: var(--primary-color);
            box-shadow: 0 4px 10px rgba(0,0,0,0.1);
            display: flex;
            align-items: center;
            gap: 8px;
            font-size: 0.95em;
        }
        .enquiry-bottom-left-badge img.icon {
            width: 24px;
            height: 24px;
            vertical-align: middle;
        }


        .enquiry-right {
            flex: 1;
            padding: 40px;
            display: flex;
            flex-direction: column;
            justify-content: center;
        }

        .enquiry-right h2 {
            color: var(--primary-dark);
            font-size: 2.1em; /* Larger title */
            margin-bottom: 25px;
            text-align: left;
            font-weight: 700;
            line-height: 1.3;
        }

        .enquiry-right p {
            font-size: 1.1em;
            color: var(--text-light);
            margin-bottom: 30px;
        }

        .enquiry-form .form-group {
            margin-bottom: 22px; /* More vertical space */
            position: relative;
        }

        .enquiry-form .form-group label {
            display: block;
            margin-bottom: 8px;
            color: var(--text-dark);
            font-weight: 500;
            font-size: 0.98em; /* Slightly larger label */
        }

        .enquiry-form .form-group input {
            width: calc(100% - 20px);
            padding: 14px 15px; /* More padding for inputs */
            border: 1px solid #d0d9e0; /* Softer border */
            border-radius: 8px;
            font-size: 1.05em; /* Slightly larger input text */
            color: var(--text-dark);
            box-sizing: border-box;
            transition: border-color 0.3s ease, box-shadow 0.3s ease;
        }

        .enquiry-form .form-group input:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 4px rgba(0, 64, 128, 0.25); /* Stronger focus shadow */
            outline: none;
        }

        .enquiry-form .form-group .icon {
            position: absolute;
            right: 15px; /* Adjust right padding for icon */
            top: 50%;
            transform: translateY(-50%);
            color: var(--accent-color);
            pointer-events: none;
            font-size: 1.1em; /* Larger icon */
        }

        .enquiry-form button {
            width: 100%;
            padding: 18px; /* Larger button */
            background-color: var(--cta-orange); /* Vibrant orange */
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 1.2em; /* Larger font size */
            font-weight: bold;
            cursor: pointer;
            transition: background-color 0.3s ease, transform 0.3s ease, box-shadow 0.3s ease;
            box-shadow: 0 5px 15px rgba(255, 111, 66, 0.4); /* Stronger shadow */
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 12px; /* More space for icon */
            text-transform: uppercase; /* Uppercase for CTA */
            letter-spacing: 0.5px;
        }

        .enquiry-form button:hover {
            background-color: var(--cta-orange-dark);
            transform: translateY(-3px); /* More pronounced lift */
            box-shadow: 0 8px 20px rgba(255, 111, 66, 0.5);
        }

        .enquiry-form .terms-text {
            font-size: 0.9em; /* Slightly larger terms text */
            color: var(--text-light);
            margin-top: 20px; /* More space above terms */
            text-align: center;
            line-height: 1.5;
        }

        /* --- Footer --- */
        footer {
            text-align: center;
            padding: 35px; /* More padding */
            background-color: var(--primary-dark);
            color: white;
            margin-top: 60px;
            font-size: 1em; /* Slightly larger font size */
            box-shadow: 0 -4px 10px rgba(0,0,0,0.1); /* Top shadow for footer */
        }
        footer a {
            color: #b0d3ff; /* Lighter blue for footer links */
            text-decoration: none;
            transition: color 0.3s ease;
        }
        footer a:hover {
            color: #ffffff; /* White on hover */
            text-decoration: underline;
        }

        /* --- Responsive Adjustments --- */
        @media (max-width: 992px) {
            .container {
                padding: 0 20px;
            }
            header h1 {
                font-size: 2.8em;
            }
            header p {
                font-size: 1.2em;
            }
            nav a {
                margin: 0 15px;
                font-size: 1.05em;
                padding: 6px 12px;
            }
            .section h2, .why-choose-section h2, .what-is-health-insurance-section .content-wrapper h2, .video-section h2 {
                font-size: 2em;
            }
            .why-choose-grid {
                grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
            }
            .why-choose-card img {
                max-width: 80px;
            }
            .why-choose-card h3 {
                font-size: 2.2em;
            }
            .what-is-health-insurance-section {
                flex-direction: column;
                text-align: center;
                gap: 30px;
            }
            .what-is-health-insurance-section .content-wrapper {
                text-align: center;
                min-width: unset; /* Remove min-width to allow shrinking */
            }
            .what-is-health-insurance-section .image-wrapper {
                min-width: unset;
            }
            .video-section video {
                width: 95%;
                max-width: 700px;
            }
            .enquiry-section {
                flex-direction: column;
                max-width: 700px;
            }
            .enquiry-left, .enquiry-right {
                padding: 35px;
            }
            .enquiry-overlay-text, .enquiry-bottom-left-badge {
                position: relative; /* Revert to relative for smaller screens */
                top: unset;
                right: unset;
                bottom: unset;
                left: unset;
                margin-top: 15px;
                justify-content: center; /* Center badges */
                width: fit-content;
                align-self: center; /* Center badges in column layout */
            }
             .enquiry-left img {
                margin-top: 0;
            }
        }

        @media (max-width: 768px) {
            header {
                padding: 35px 15px;
            }
            header h1 {
                font-size: 2.2em;
            }
            header p {
                font-size: 1em;
            }
            nav a {
                margin: 0 8px;
                font-size: 0.95em;
                padding: 5px 10px;
            }
            .section {
                padding: 30px;
            }
            .section h2, .why-choose-section h2, .what-is-health-insurance-section .content-wrapper h2, .video-section h2 {
                font-size: 1.8em;
            }
            .why-choose-grid, .stats {
                grid-template-columns: 1fr;
            }
            .why-choose-card, .stat-card, .what-is-health-insurance-section {
                padding: 25px;
            }
            .section .button-group {
                flex-direction: column;
                align-items: center;
                gap: 15px;
            }
            .section a.button {
                width: 90%;
                padding: 12px 25px;
                font-size: 1em;
            }
            .enquiry-left, .enquiry-right {
                padding: 30px;
            }
            .enquiry-right h2 {
                font-size: 1.9em;
                text-align: center; /* Center title on small screens */
            }
            .enquiry-right p {
                font-size: 1em;
                text-align: center;
            }
            .enquiry-form .form-group input {
                padding: 12px 10px;
            }
            .enquiry-form button {
                padding: 15px;
                font-size: 1.1em;
            }
        }

        @media (max-width: 480px) {
            header {
                padding: 25px 10px;
            }
            header h1 {
                font-size: 1.8em;
            }
            header p {
                font-size: 0.9em;
            }
            nav {
                padding: 10px 0;
            }
            nav a {
                display: block;
                margin: 8px 0;
                padding: 8px 15px;
                font-size: 0.9em;
            }
            .container {
                padding: 0 10px;
                margin: 25px auto;
            }
            .section {
                padding: 20px;
                margin-bottom: 20px;
            }
            .section h2 {
                font-size: 1.6em;
                margin-bottom: 15px;
                padding-bottom: 10px;
            }
            .why-choose-card img {
                max-width: 60px;
            }
            .why-choose-card h3 {
                font-size: 1.8em;
            }
            .why-choose-card p {
                font-size: 1em;
            }
            .what-is-health-insurance-section .content-wrapper h2 {
                font-size: 1.5em;
            }
            .what-is-health-insurance-section .content-wrapper p {
                font-size: 0.95em;
            }
            .what-is-health-insurance-section .content-wrapper .buy-button {
                padding: 12px 25px;
                font-size: 1em;
            }
            .stat-card h3 {
                font-size: 2.5em;
            }
            .stat-card p {
                font-size: 1em;
            }
            .video-section h2 {
                font-size: 1.8em;
            }
            .enquiry-section {
                margin: 30px auto;
                max-width: 100%;
            }
            .enquiry-left, .enquiry-right {
                padding: 25px;
            }
            .enquiry-right h2 {
                font-size: 1.6em;
            }
            .enquiry-form button {
                font-size: 1em;
                padding: 12px;
            }
            .enquiry-form .terms-text {
                font-size: 0.8em;
            }
            footer {
                padding: 25px;
                font-size: 0.85em;
            }
        }
    </style>
</head>
<body>
    <header>
        <h1>Health Care Solutions</h1>
        <p>Your Trusted Partner for Comprehensive Health Coverage</p>
    </header>

    <nav>
        <a href="medicalInsurance"><i class="fas fa-stethoscope"></i> Medical Insurance</a>
        <a href="logout"><i class="fas fa-sign-out-alt"></i> Logout</a>
    </nav>

    <div class="container">
        <div class="enquiry-section">
            <div class="enquiry-left">
                <img src="/images/family_with_shield.png" alt="Family protecting health">
                <div class="enquiry-overlay-text">
                    <img src="/images/icons/star_health_logo.png" alt="Star Health Logo" class="icon">
                    Instant Quote Available!
                </div>
                <div class="enquiry-bottom-left-badge">
                    <img src="/images/icons/Secure.png" alt="Secure Icon" class="icon">
                    100% Secure & Private
                </div>
            </div>
            <div class="enquiry-right">
                <h2>Wait! Don't Leave Without Protecting Your Health.</h2>
                <p>Get a quick Star Health quote before you go.</p>
                <form action="/submitEnquiry" method="post" class="enquiry-form">
                    <div class="form-group">
                        <label for="name">Your Name:</label>
                        <input type="text" id="name" name="name" placeholder="Name" required>
                        <i class="fas fa-user icon"></i>
                    </div>
                    <div class="form-group">
                        <label for="mobileNumber">Mobile Number:</label>
                        <input type="tel" id="mobileNumber" name="mobileNumber" placeholder="Mobile Number" required pattern="[0-9]{10}">
                        <i class="fas fa-phone icon"></i>
                    </div>
                    <div class="form-group">
                        <label for="pincode">Pincode:</label>
                        <input type="text" id="pincode" name="pincode" placeholder="Pincode" required pattern="[0-9]{6}">
                        <i class="fas fa-map-marker-alt icon"></i>
                    </div>
                    <button type="submit"><i class="fas fa-arrow-right"></i> Get Your Quote</button>
                    <p class="terms-text">By providing my details, I consent to receive assistance from Star Health regarding my purchases and services through any valid communication channel.</p>
                </form>
            </div>
        </div>
        <div class="section">
            <h2>Manage Your Insurance</h2>
            <div class="button-group">
                <a href="newInsurance" class="button"><i class="fas fa-file-invoice"></i> New Insurance</a>
                <!-- 
                <a href="claimInsuranceForm" class="button"><i class="fas fa-hand-holding-usd"></i> Claim Insurance</a>
                 -->
                <a href="viewInsurance" class="button"><i class="fas fa-eye"></i> View Insurance</a>
            </div>
        </div>
        <div class="why-choose-section">
            <h2>Why Choose Our Health Care</h2>
            <div class="why-choose-grid">
                <div class="why-choose-card">
                    <img src="/images/icons/NetworkHospitals.png" alt="Network Hospitals Icon">
                    <h3><span class="count" data-target="14000">0</span>+</h3>
                    <p>Network Hospitals for cashless claims</p>
                </div>
                <div class="why-choose-card">
                    <img src="/images/icons/FastApprovals.png" alt="Fast Approvals Icon">
                    <h3><span class="count" data-target="97">0</span>%</h3>
                    <p>Cashless final approvals within 3 hours</p>
                </div>
                <div class="why-choose-card">
                    <img src="/images/icons/BranchOffices.png" alt="Branch Offices Icon">
                    <h3><span class="count" data-target="850">0</span>+</h3>
                    <p>Branch offices across India</p>
                </div>
                <div class="why-choose-card">
                    <img src="/images/icons/ClaimsSettled.png" alt="Claims Settled Icon">
                    <h3><span class="count" data-target="1000000">0</span>+</h3>
                    <p>Claims settled since inception</p>
                </div>
            </div>
        </div>

        <div class="what-is-health-insurance-section">
            <div class="image-wrapper">
                <img src="/images/family-health-insurance.png" alt="Family receiving health care benefits">
            </div>
            <div class="content-wrapper">
                <h2>Understanding Health Insurance: Your Shield in Uncertain Times</h2>
                <p>Health Insurance is a vital safeguard that protects you and your family from financial instability during health emergencies. Contrary to the common misconception that only the elderly or those with existing health risks need coverage, it is an essential asset for everyone, regardless of age or health status. A well-chosen health policy offers invaluable peace of mind by expertly managing your medical bills during periods of hospitalization.</p>
                <p>Recent global uncertainties, such as the COVID-19 pandemic, have underscored the critical and undeniable need for robust health insurance. Moreover, with the continuous rise in medical inflation, a comprehensive health insurance plan can be your financial bulwark, offering either seamless cashless treatments or prompt reimbursements for incurred medical expenses. Our policies are designed with flexibility, allowing you to choose between individual or floater coverage to secure wide-ranging protection tailored precisely to your unique needs.</p>
                <a href="newInsurance" class="buy-button"><i class="fas fa-shopping-cart"></i> Buy Online Now</a>
            </div>
        </div>

        <div class="stats">
            <div class="stat-card">
                <h3 class="count" data-target="12500">0</h3>
                <p>Insurance Policies Purchased</p>
            </div>
            <div class="stat-card">
                <h3 class="count" data-target="3800">0</h3>
                <p>Claims Successfully Processed</p>
            </div>
            <div class="stat-card">
                <h3 class="count" data-target="25000">0</h3>
                <p>Happy Members Served</p>
            </div>
        </div>

        <div class="video-section">
            <h2><i class="fas fa-play-circle"></i> Your Hope, Our Commitment</h2>
            <video controls>
                <source src="${pageContext.request.contextPath}/videos/Insurance.mp4" type="video/mp4">
                Your browser does not support the video tag. Please update your browser.
            </video>
        </div>
    </div>

    <footer>
        <p>&copy; 2025 Health Care Solutions. All rights reserved. | <a href="#" style="color: white; text-decoration: none;">Privacy Policy</a> | <a href="#" style="color: white; text-decoration: none;">Terms of Service</a></p>
    </footer>

    <script>
        const counters = document.querySelectorAll('.count');
        const speed = 200;

        const animateCount = (counter) => {
            const target = +counter.getAttribute('data-target');
            let currentCount = 0;

            const update = () => {
                const increment = Math.ceil(target / speed);
                if (currentCount < target) {
                    currentCount += increment;
                    counter.innerText = currentCount.toLocaleString();
                    requestAnimationFrame(update);
                } else {
                    counter.innerText = target.toLocaleString();
                }
            };
            requestAnimationFrame(update);
        };

        const options = {
            threshold: 0.7
        };

        const observer = new IntersectionObserver((entries, observer) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    animateCount(entry.target);
                    observer.unobserve(entry.target);
                }
            });
        }, options);

        counters.forEach(counter => {
            observer.observe(counter);
        });

        document.addEventListener('DOMContentLoaded', () => {
            const currentPath = window.location.pathname;
            document.querySelectorAll('nav a').forEach(link => {
                // Check if the link's href matches the current path, excluding leading slashes for comparison
                const linkHref = link.getAttribute('href').replace(/^\//, '');
                const currentPathClean = currentPath.replace(/^\//, '');

                if (linkHref === currentPathClean) {
                    link.classList.add('active');
                }
            });
        });
    </script>
</body>
</html>