<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Health Care Solutions - Your Trusted Partner</title>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;600;700&family=Open+Sans:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        :root {
            --primary-color: #004080; /* Deep Navy */
            --primary-dark: #002D5A; /* Even darker blue for hover/nav */
            --secondary-color: #36A420; /* Forest Green for CTA */
            --accent-color: #7D8A99; /* Cool Grey for subtle text */
            --background-light: #EEF2F6; /* Lighter blue-grey background */
            --background-card: #ffffff;
            --text-dark: #333333; /* Darker text for readability */
            --text-light: #666666;
            --border-radius-lg: 12px;
            --border-radius-md: 8px;
            --box-shadow-light: 0 4px 12px rgba(0,0,0,0.08);
            --box-shadow-hover: 0 8px 25px rgba(0,0,0,0.15);
            --gradient-header: linear-gradient(to right, #004080, #002D5A); /* Updated gradient */
        }

        body {
            font-family: 'Open Sans', sans-serif;
            background: var(--background-light);
            margin: 0;
            padding: 0;
            color: var(--text-dark);
            line-height: 1.6;
        }

        /* --- Header --- */
        header {
            background: var(--gradient-header);
            color: white;
            padding: 40px 20px;
            text-align: center;
            box-shadow: var(--box-shadow-light);
        }
        header h1 {
            font-family: 'Montserrat', sans-serif;
            font-size: 3.2em;
            margin-bottom: 10px;
            font-weight: 700;
        }
        header p {
            font-size: 1.2em;
            opacity: 0.9;
            max-width: 800px;
            margin: 0 auto;
        }

        /* --- Navigation --- */
        nav {
            background-color: var(--primary-dark);
            padding: 15px 0;
            text-align: center;
            box-shadow: 0 2px 8px rgba(0,0,0,0.15);
        }
        nav a {
            color: white;
            margin: 0 20px;
            text-decoration: none;
            font-weight: 600;
            font-size: 1.1em;
            transition: color 0.3s ease, transform 0.3s ease;
            padding: 5px 0;
            position: relative;
        }
        nav a::after {
            content: '';
            position: absolute;
            width: 0;
            height: 2px;
            background: white;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            transition: width 0.3s ease;
        }
        nav a:hover::after {
            width: 100%;
        }
        nav a:hover {
            color: #e6f2ff;
            transform: translateY(-2px);
        }

        /* --- Container --- */
        .container {
            max-width: 1100px; /* Slightly wider container */
            margin: 40px auto;
            padding: 0 20px;
        }

        /* --- Section Styles --- */
        .section {
            background: var(--background-card);
            padding: 30px;
            margin-bottom: 30px;
            border-radius: var(--border-radius-lg);
            box-shadow: var(--box-shadow-light);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        .section:hover {
            transform: translateY(-5px);
            box-shadow: var(--box-shadow-hover);
        }
        .section h2 {
            font-family: 'Montserrat', sans-serif;
            color: var(--primary-color);
            font-size: 2.2em;
            margin-bottom: 25px;
            text-align: center;
            position: relative;
            padding-bottom: 10px;
        }
        .section h2::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 60px;
            height: 3px;
            background-color: var(--primary-color);
            border-radius: 2px;
        }
        .section .button-group {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
            justify-content: center;
            margin-top: 30px;
        }
        .section a.button {
            display: inline-flex;
            align-items: center;
            padding: 12px 28px;
            background-color: var(--primary-color);
            color: white;
            border-radius: var(--border-radius-md);
            text-decoration: none;
            font-weight: 600;
            transition: background-color 0.3s ease, transform 0.3s ease, box-shadow 0.3s ease;
            font-size: 1.05em;
            box-shadow: 0 4px 10px rgba(0, 64, 128, 0.3); /* Adjusted shadow for primary-color */
        }
        .section a.button i {
            margin-right: 10px;
        }
        .section a.button:hover {
            background-color: var(--primary-dark);
            transform: translateY(-2px);
            box-shadow: 0 6px 15px rgba(0, 64, 128, 0.4); /* Adjusted shadow for primary-dark */
        }

        /* --- Why Choose Section --- */
        .why-choose-section {
            text-align: center;
            margin-top: 60px;
            margin-bottom: 60px;
        }
        .why-choose-section h2 {
            font-family: 'Montserrat', sans-serif;
            color: var(--primary-color);
            font-size: 2.4em;
            margin-bottom: 40px;
            position: relative;
            padding-bottom: 15px;
        }
        .why-choose-section h2::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 80px;
            height: 4px;
            background-color: var(--primary-color);
            border-radius: 2px;
        }
        .why-choose-grid {
            display: grid;
            grid-template-columns: repeat(4, 1fr); /* Forces 4 columns */
            gap: 30px;
            justify-content: center;
        }
        .why-choose-card {
            background-color: var(--background-card);
            padding: 35px 25px;
            border-radius: var(--border-radius-lg);
            box-shadow: var(--box-shadow-light);
            text-align: center;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            border: 1px solid #e0e6ec;
        }
        .why-choose-card:hover {
            transform: translateY(-8px);
            box-shadow: var(--box-shadow-hover);
        }
        .why-choose-card img {
            max-width: 100px;
            height: auto;
            margin-bottom: 20px;
            filter: drop-shadow(0 4px 8px rgba(0,0,0,0.15));
        }
        .why-choose-card h3 {
            font-family: 'Montserrat', sans-serif;
            font-size: 2.5em;
            color: var(--primary-dark);
            margin-bottom: 8px;
            font-weight: 700;
        }
        .why-choose-card p {
            font-size: 1.1em;
            color: var(--text-light);
            line-height: 1.5;
        }

        /* --- What is Health Insurance Section --- */
        .what-is-health-insurance-section {
            display: flex;
            flex-wrap: wrap;
            align-items: center;
            justify-content: space-between;
            background: var(--background-card);
            padding: 40px;
            margin-top: 60px;
            border-radius: var(--border-radius-lg);
            box-shadow: var(--box-shadow-light);
            gap: 40px;
        }
        .what-is-health-insurance-section .image-wrapper {
            flex: 1;
            min-width: 400px;
            text-align: center;
        }
        .what-is-health-insurance-section .image-wrapper img {
            max-width: 100%;
            height: auto;
            border-radius: var(--border-radius-md);
            box-shadow: 0 10px 20px rgba(0,0,0,0.15);
        }
        .what-is-health-insurance-section .content-wrapper {
            flex: 1.5;
            min-width: 400px;
            text-align: left;
        }
        .what-is-health-insurance-section .content-wrapper h2 {
            font-family: 'Montserrat', sans-serif;
            color: var(--primary-color);
            font-size: 2.5em;
            margin-top: 0;
            margin-bottom: 25px;
            text-align: left;
            position: relative;
            padding-bottom: 10px;
        }
        .what-is-health-insurance-section .content-wrapper h2::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 70px;
            height: 3px;
            background-color: var(--primary-color);
            border-radius: 2px;
        }
        .what-is-health-insurance-section .content-wrapper p {
            font-size: 1.1em;
            line-height: 1.8;
            margin-bottom: 20px;
            color: var(--text-dark);
        }
        .what-is-health-insurance-section .content-wrapper .buy-button {
            display: inline-flex;
            align-items: center;
            padding: 16px 35px;
            background-color: var(--secondary-color);
            color: white;
            border-radius: var(--border-radius-md);
            text-decoration: none;
            font-weight: bold;
            transition: background-color 0.3s ease, transform 0.3s ease, box-shadow 0.3s ease;
            font-size: 1.15em;
            box-shadow: 0 6px 12px rgba(54, 164, 32, 0.3); /* Adjusted shadow for secondary-color */
        }
        .what-is-health-insurance-section .content-wrapper .buy-button i {
            margin-right: 10px;
        }
        .what-is-health-insurance-section .content-wrapper .buy-button:hover {
            background-color: #2F8D1A; /* Darker green on hover */
            transform: translateY(-3px);
            box-shadow: 0 8px 16px rgba(54, 164, 32, 0.4); /* Adjusted shadow for secondary-color */
        }

        /* --- Stats Section --- */
        .stats {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 30px;
            margin-top: 60px;
            text-align: center;
        }
        .stat-card {
            background-color: var(--background-card);
            padding: 35px;
            border-radius: var(--border-radius-lg);
            box-shadow: var(--box-shadow-light);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            border: 1px solid #e0e6ec;
        }
        .stat-card:hover {
            transform: translateY(-6px);
            box-shadow: var(--box-shadow-hover);
        }
        .stat-card h3 {
            font-family: 'Montserrat', sans-serif;
            font-size: 3em;
            color: var(--primary-dark);
            margin-bottom: 12px;
            font-weight: 700;
        }
        .stat-card p {
            font-size: 1.15em;
            color: var(--text-light);
        }

        /* --- Video Section --- */
        .video-section {
            text-align: center;
            margin-top: 60px;
            background: var(--background-card);
            padding: 40px;
            border-radius: var(--border-radius-lg);
            box-shadow: var(--box-shadow-light);
        }
        .video-section h2 {
            font-family: 'Montserrat', sans-serif;
            color: var(--primary-color);
            font-size: 2.4em;
            margin-bottom: 30px;
            position: relative;
            padding-bottom: 15px;
        }
        .video-section h2::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 80px;
            height: 4px;
            background-color: var(--primary-color);
            border-radius: 2px;
        }
        .video-section video {
            width: 100%;
            max-width: 850px;
            border-radius: var(--border-radius-md);
            margin-top: 20px;
            box-shadow: 0 8px 20px rgba(0,0,0,0.18);
            outline: none;
        }

        /* --- Footer --- */
        footer {
            text-align: center;
            padding: 35px;
            background-color: var(--primary-dark);
            color: white;
            margin-top: 70px;
            font-size: 0.95em;
        }
        footer a {
            color: white;
            text-decoration: none;
            margin: 0 10px;
            transition: color 0.3s ease;
        }
        footer a:hover {
            color: #e6f2ff;
            text-decoration: underline;
        }

        /* --- Responsive Adjustments --- */
        @media (max-width: 1200px) {
            .container {
                max-width: 960px;
            }
            .why-choose-grid {
                grid-template-columns: repeat(2, 1fr); /* 2 columns on larger tablets */
            }
        }

        @media (max-width: 992px) {
            header h1 {
                font-size: 2.8em;
            }
            header p {
                font-size: 1.1em;
            }
            nav a {
                margin: 0 15px;
                font-size: 1em;
            }
            .container {
                padding: 0 15px;
            }
            .section h2, .why-choose-section h2, .what-is-health-insurance-section .content-wrapper h2, .video-section h2 {
                font-size: 2em;
            }
            .why-choose-card {
                padding: 25px;
            }
            .what-is-health-insurance-section {
                flex-direction: column;
                text-align: center;
                padding: 30px;
            }
            .what-is-health-insurance-section .content-wrapper {
                text-align: center;
                min-width: unset;
            }
            .what-is-health-insurance-section .content-wrapper h2::after {
                left: 50%;
                transform: translateX(-50%);
            }
        }

        @media (max-width: 768px) {
            header {
                padding: 30px 15px;
            }
            header h1 {
                font-size: 2.2em;
            }
            nav {
                flex-direction: column;
                gap: 10px;
            }
            nav a {
                margin: 5px 0;
            }
            .why-choose-grid, .stats {
                grid-template-columns: 1fr; /* Single column on small screens */
            }
            .why-choose-card, .stat-card, .what-is-health-insurance-section {
                padding: 20px;
            }
            .section .button-group {
                flex-direction: column;
                align-items: center;
            }
            .section a.button {
                width: 90%;
            }
            .what-is-health-insurance-section .image-wrapper {
                min-width: unset;
            }
        }

        @media (max-width: 480px) {
            header h1 {
                font-size: 1.8em;
            }
            .section h2, .why-choose-section h2, .what-is-health-insurance-section .content-wrapper h2, .video-section h2 {
                font-size: 1.6em;
            }
            .why-choose-card img {
                max-width: 80px;
            }
            .why-choose-card h3 {
                font-size: 2em;
            }
            .stat-card h3 {
                font-size: 2.5em;
            }
            .what-is-health-insurance-section .content-wrapper .buy-button {
                font-size: 1em;
                padding: 12px 25px;
            }
        }
    </style>
</head>
<body>

<header>
    <h1>Health Care Solutions</h1>
    <p>Your Trusted Partner for Comprehensive Health Coverage</p>
</header>

<nav>
    <a href="login"><i class="fas fa-sign-in-alt"></i> Login</a>
    <!-- 
    <a href="register"><i class="fas fa-user-plus"></i> Register</a>
     -->
    <a href="about"><i class="fas fa-info-circle"></i> About Us</a>
</nav>

<div class="container">

    <div class="section">
        <h2>🏥 Manage Your Health Insurance</h2>
        <p>Seamlessly handle your insurance needs, from purchasing new policies to managing existing ones and making claims.</p>
        <div class="button-group">
            <a href="login" class="button"><i class="fas fa-file-invoice"></i> New Policy</a>
            <!-- 
            <a href="claimInsuranceForm" class="button"><i class="fas fa-hand-holding-usd"></i> File a Claim</a>
             -->
            <a href="viewInsurance" class="button"><i class="fas fa-eye"></i> View My Policies</a>
        </div>
    </div>

   <!--  <div class="section">
        <h2>💊 Find Medicines & Pharmacies</h2>
        <p>Quickly locate medicines and pharmacies near you with our intuitive search tool.</p>
        <div class="button-group">
            <a href="login" class="button"><i class="fas fa-search-location"></i> Search Medicines</a>
        </div>
    </div> -->

    <div class="section">
        <h2>✍️ Share Your Feedback</h2>
        <p>Your opinion helps us improve. Please share your experience to help us serve you better.</p>
        <div class="button-group">
            <a href="#" class="button"><i class="fas fa-comment-dots"></i> Give Feedback</a>
        </div>
    </div>

    <div class="why-choose-section">
        <h2>Why Choose Health Care Solutions?</h2>
        <div class="why-choose-grid">
            <div class="why-choose-card">
                <img src="/images/icons/NetworkHospitals.png" alt="Network Hospitals Icon">
                <h3>14000+</h3>
                <p>Network Hospitals for cashless claims</p>
            </div>
            <div class="why-choose-card">
                <img src="/images/icons/FastApprovals.png" alt="Fast Approvals Icon">
                <h3>97%</h3>
                <p>Cashless final approvals within 3 hours</p>
            </div>
            <div class="why-choose-card">
                <img src="/images/icons/BranchOffices.png" alt="Branch Offices Icon">
                <h3>850+</h3>
                <p>Branch offices across India</p>
            </div>
            <div class="why-choose-card">
                <img src="/images/icons/ClaimsSettled.png" alt="Claims Settled Icon">
                <h3>1,000,000+</h3>
                <p>Claims settled since inception</p>
            </div>
        </div>
    </div>

    <div class="what-is-health-insurance-section">
        <div class="image-wrapper">
            <img src="/images/family-health-insurance.png" alt="Family receiving health care benefits">
        </div>
        <div class="content-wrapper">
            <h2>Understanding Health Insurance: Your Shield in Uncertain Times</h2>
            <p>Health Insurance is a vital safeguard that protects you and your family from financial instability during health emergencies. Contrary to the common misconception that only the elderly or those with existing health risks need coverage, it is an essential asset for everyone, regardless of age or health status. A well-chosen health policy offers invaluable peace of mind by expertly managing your medical bills during periods of hospitalization.</p>
            <p>Recent global uncertainties, such as the COVID-19 pandemic, have underscored the critical and undeniable need for robust health insurance. Moreover, with the continuous rise in medical inflation, a comprehensive health insurance plan can be your financial bulwark, offering either seamless cashless treatments or prompt reimbursements for incurred medical expenses. Our policies are designed with flexibility, allowing you to choose between individual or floater coverage to secure wide-ranging protection tailored precisely to your unique needs.</p>
            <a href="newInsurance" class="buy-button"><i class="fas fa-shopping-cart"></i> Buy Online Now</a>
        </div>
    </div>

    <div class="stats">
        <div class="stat-card">
            <h3>12,500+</h3>
            <p>Insurance Policies Purchased</p>
        </div>
        <div class="stat-card">
            <h3>3,800+</h3>
            <p>Claims Successfully Processed</p>
        </div>
        <div class="stat-card">
            <h3>25,000+</h3>
            <p>Happy Members Served</p>
        </div>
    </div>

    <div class="video-section">
        <h2>🎬 Your Hope, Our Commitment</h2>
        <video controls>
            <source src="${pageContext.request.contextPath}/videos/Insurance.mp4" type="video/mp4">
            Your browser does not support the video tag. Please update your browser.
        </video>
    </div>
</div>

<footer>
    <p>&copy; 2025 Health Care Solutions. All rights reserved. | <a href="#">Privacy Policy</a> | <a href="#">Terms of Service</a></p>
</footer>

</body>
</html>