<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>HealthPlus - Member Login</title>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
<style>
:root {
  --primary-gradient: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
  --secondary-gradient: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
  --success-gradient: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
  --primary-color: #667eea;
  --primary-dark: #5a67d8;
  --secondary-color: #764ba2;
  --accent-color: #f093fb;
  --text-primary: #2d3748;
  --text-secondary: #718096;
  --text-light: #a0aec0;
  --bg-primary: #f7fafc;
  --bg-card: #ffffff;
  --border-color: #e2e8f0;
  --border-focus: #667eea;
  --error-color: #e53e3e;
  --success-color: #38a169;
  --shadow-sm: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06);
  --shadow-md: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
  --shadow-lg: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
  --shadow-xl: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
  --border-radius: 12px;
  --border-radius-lg: 16px;
  --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
}

* {
  margin: 0;
  padding: 0;
  box-sizing: border-box;
}

body {
  font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
  background: var(--bg-primary);
  min-height: 100vh;
  position: relative;
  overflow-x: hidden;
}

/* Animated Background */
.bg-animation {
  position: fixed;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  z-index: -1;
  background: linear-gradient(-45deg, #667eea, #764ba2, #f093fb, #f5576c);
  background-size: 400% 400%;
  animation: gradientShift 15s ease infinite;
}

@keyframes gradientShift {
  0% { background-position: 0% 50%; }
  50% { background-position: 100% 50%; }
  100% { background-position: 0% 50%; }
}

/* Floating Elements */
.floating-shapes {
  position: fixed;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  pointer-events: none;
  z-index: 1;
}

.shape {
  position: absolute;
  border-radius: 50%;
  background: rgba(255, 255, 255, 0.1);
  animation: float 6s ease-in-out infinite;
}

.shape:nth-child(1) {
  width: 80px;
  height: 80px;
  top: 20%;
  left: 10%;
  animation-delay: 0s;
}

.shape:nth-child(2) {
  width: 120px;
  height: 120px;
  top: 60%;
  left: 80%;
  animation-delay: 2s;
}

.shape:nth-child(3) {
  width: 60px;
  height: 60px;
  top: 80%;
  left: 20%;
  animation-delay: 4s;
}

@keyframes float {
  0%, 100% { transform: translateY(0) rotate(0deg); }
  50% { transform: translateY(-20px) rotate(180deg); }
}

/* Main Container */
.main-container {
  display: flex;
  min-height: 100vh;
  position: relative;
  z-index: 2;
}

/* Left Panel - Brand Section */
.brand-panel {
  flex: 1;
  display: flex;
  flex-direction: column;
  justify-content: center;
  align-items: center;
  padding: 60px 40px;
  background: rgba(255, 255, 255, 0.1);
  backdrop-filter: blur(20px);
  border-right: 1px solid rgba(255, 255, 255, 0.2);
}

.brand-content {
  text-align: center;
  max-width: 400px;
}

.brand-logo {
  font-size: 3rem;
  font-weight: 700;
  background: linear-gradient(135deg, #ffffff 0%, #f0f9ff 100%);
  background-clip: text;
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
  margin-bottom: 1rem;
  font-family: 'Poppins', sans-serif;
}

.brand-tagline {
  font-size: 1.2rem;
  color: rgba(255, 255, 255, 0.9);
  margin-bottom: 2rem;
  line-height: 1.6;
}

.feature-list {
  list-style: none;
  text-align: left;
}

.feature-item {
  display: flex;
  align-items: center;
  margin-bottom: 1rem;
  color: rgba(255, 255, 255, 0.8);
  font-size: 0.95rem;
}

.feature-item i {
  color: #4ade80;
  margin-right: 12px;
  font-size: 1.1rem;
}

/* Right Panel - Login Form */
.login-panel {
  flex: 1;
  display: flex;
  align-items: center;
  justify-content: center;
  padding: 40px;
  background: rgba(255, 255, 255, 0.95);
  backdrop-filter: blur(20px);
}

.login-container {
  width: 100%;
  max-width: 400px;
  padding: 0;
}

.login-header {
  text-align: center;
  margin-bottom: 2rem;
}

.login-title {
  font-size: 2rem;
  font-weight: 700;
  color: var(--text-primary);
  margin-bottom: 0.5rem;
  font-family: 'Poppins', sans-serif;
}

.login-subtitle {
  color: var(--text-secondary);
  font-size: 0.95rem;
}

/* Error Message */
.error-container {
  background: linear-gradient(135deg, #fee2e2 0%, #fecaca 100%);
  border: 1px solid #fca5a5;
  border-radius: var(--border-radius);
  padding: 1rem;
  margin-bottom: 1.5rem;
  display: flex;
  align-items: center;
  animation: shake 0.5s ease-in-out;
}

.error-container i {
  color: var(--error-color);
  margin-right: 0.75rem;
  font-size: 1.1rem;
}

.error-text {
  color: #991b1b;
  font-size: 0.9rem;
  font-weight: 500;
}

@keyframes shake {
  0%, 100% { transform: translateX(0); }
  25% { transform: translateX(-5px); }
  75% { transform: translateX(5px); }
}

/* Form Styles */
.login-form {
  /* Removed `space-y: 1.5rem;` as it's a TailwindCSS class and doesn't apply directly in pure CSS */
}

.form-group {
  margin-bottom: 1.5rem;
}

.form-label {
  display: block;
  font-weight: 600;
  color: var(--text-primary);
  margin-bottom: 0.5rem;
  font-size: 0.9rem;
  letter-spacing: 0.025em;
}

.input-container {
  position: relative;
}

.form-input {
  width: 100%;
  padding: 1rem 1rem 1rem 3rem;
  border: 2px solid var(--border-color);
  border-radius: var(--border-radius);
  font-size: 1rem;
  transition: var(--transition);
  background: var(--bg-card);
  color: var(--text-primary);
}

.form-input:focus {
  outline: none;
  border-color: var(--border-focus);
  box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
  transform: translateY(-1px);
}

.input-icon {
  position: absolute;
  left: 1rem;
  top: 50%;
  transform: translateY(-50%);
  color: var(--text-light);
  font-size: 1.1rem;
  transition: var(--transition);
}

.form-input:focus + .input-icon {
  color: var(--border-focus);
}

/* Login Button */
.login-button {
  width: 100%;
  padding: 1rem;
  background: var(--primary-gradient);
  color: white;
  border: none;
  border-radius: var(--border-radius);
  font-size: 1rem;
  font-weight: 600;
  cursor: pointer;
  transition: var(--transition);
  position: relative;
  overflow: hidden;
  margin-top: 0.5rem;
  display: flex; /* Added for loading spinner alignment */
  align-items: center; /* Added for loading spinner alignment */
  justify-content: center; /* Added for loading spinner alignment */
}

.login-button::before {
  content: '';
  position: absolute;
  top: 0;
  left: -100%;
  width: 100%;
  height: 100%;
  background: linear-gradient(135deg, rgba(255,255,255,0.2) 0%, rgba(255,255,255,0.1) 100%);
  transition: left 0.5s ease;
}

.login-button:hover::before {
  left: 0;
}

.login-button:hover {
  transform: translateY(-2px);
  box-shadow: var(--shadow-lg);
}

.login-button:active {
  transform: translateY(0);
}

/* Register Link */
.register-section {
  text-align: center;
  margin-top: 2rem;
  padding-top: 2rem;
  border-top: 1px solid var(--border-color);
}

.register-text {
  color: var(--text-secondary);
  font-size: 0.9rem;
}

.register-link {
  color: var(--primary-color);
  text-decoration: none;
  font-weight: 600;
  transition: var(--transition);
}

.register-link:hover {
  color: var(--primary-dark);
  text-decoration: underline;
}

/* Loading Animation */
.loading {
  display: none; /* Changed from inline-block to none for initial state */
  width: 20px;
  height: 20px;
  border: 2px solid rgba(255,255,255,0.3);
  border-radius: 50%;
  border-top-color: white;
  animation: spin 1s ease-in-out infinite;
  margin-right: 0.5rem;
}

@keyframes spin {
  to { transform: rotate(360deg); }
}

/* Responsive Design */
@media (max-width: 1024px) {
  .brand-panel {
    display: none;
  }
  
  .main-container {
    justify-content: center;
  }
  
  .login-panel {
    flex: none;
    width: 100%;
    max-width: 500px;
    margin: 0 auto;
    background: var(--bg-card);
    border-radius: var(--border-radius-lg);
    box-shadow: var(--shadow-xl);
    margin-top: 2rem;
    margin-bottom: 2rem;
  }
}

@media (max-width: 640px) {
  .login-panel {
    padding: 2rem 1.5rem;
    margin: 1rem;
  }
  
  .login-title {
    font-size: 1.75rem;
  }
  
  .brand-logo {
    font-size: 2.5rem;
  }
}

/* Additional Professional Touches */
.form-input::placeholder {
  color: var(--text-light);
  opacity: 1;
}

.form-input:invalid:focus {
  border-color: var(--error-color);
  box-shadow: 0 0 0 3px rgba(229, 62, 62, 0.1);
}

.security-badge {
  display: flex;
  align-items: center;
  justify-content: center;
  margin-top: 1.5rem;
  font-size: 0.8rem;
  color: var(--text-light);
}

.security-badge i {
  margin-right: 0.5rem;
  color: var(--success-color);
}

/* Focus indicators for accessibility */
.login-button:focus-visible,
.register-link:focus-visible,
.form-input:focus-visible {
  outline: 2px solid var(--primary-color);
  outline-offset: 2px;
}
</style>
</head>
<body>

<div class="bg-animation"></div>

<div class="floating-shapes">
  <div class="shape"></div>
  <div class="shape"></div>
  <div class="shape"></div>
</div>

<div class="main-container">
  
  <div class="brand-panel">
    <div class="brand-content">
      <div class="brand-logo">HealthPlus</div>
      <p class="brand-tagline">Your trusted partner in comprehensive healthcare management</p>
      
      <ul class="feature-list">
        <li class="feature-item">
          <i class="fas fa-shield-alt"></i>
          <span>Bank-level security & encryption</span>
        </li>
        <li class="feature-item">
          <i class="fas fa-clock"></i>
          <span>24/7 access to your health data</span>
        </li>
        <li class="feature-item">
          <i class="fas fa-user-md"></i>
          <span>Connect with healthcare providers</span>
        </li>
        <li class="feature-item">
          <i class="fas fa-chart-line"></i>
          <span>Track your health progress</span>
        </li>
      </ul>
    </div>
  </div>

  <div class="login-panel">
    <div class="login-container">
      
      <div class="login-header">
        <h1 class="login-title">Welcome Back</h1>
        <p class="login-subtitle">Please sign in to your account</p>
      </div>

      <c:if test="${not empty error}">
        <div class="error-container">
          <i class="fas fa-exclamation-triangle"></i>
          <span class="error-text">${error}</span>
        </div>
      </c:if>

      <form class="login-form" action="/login" method="post" id="loginForm"> <%-- ACTION CHANGED HERE --%>
        
        <div class="form-group">
          <label class="form-label" for="username">Username/Email</label> <%-- Label updated for clarity --%>
          <div class="input-container">
            <input 
              type="text" 
              id="username" 
              name="emailId"  <%-- NAME CHANGED HERE --%>
              class="form-input" 
              placeholder="Enter your username or email"
              required 
              autocomplete="username"
            />
            <i class="fas fa-user input-icon"></i>
          </div>
        </div>

        <div class="form-group">
          <label class="form-label" for="password">Password</label>
          <div class="input-container">
            <input 
              type="password" 
              id="password" 
              name="password" 
              class="form-input" 
              placeholder="Enter your password"
              required 
              autocomplete="current-password"
            />
            <i class="fas fa-lock input-icon"></i>
          </div>
        </div>

        <button type="submit" class="login-button" id="loginBtn">
          <span class="loading" id="loadingSpinner"></span>
          <span id="buttonText">Sign In</span>
        </button>

      </form>

      <div class="security-badge">
        <i class="fas fa-shield-alt"></i>
        <span>Your information is protected with 256-bit SSL encryption</span>
      </div>

      <div class="register-section">
        <p class="register-text">
          Don't have an account? 
          <a href="register" class="register-link">Create Account</a>
        </p>
      </div>

    </div>
  </div>

</div>

<script>
// Enhanced form interactions
document.addEventListener('DOMContentLoaded', function() {
  const form = document.getElementById('loginForm');
  const loginBtn = document.getElementById('loginBtn');
  const loadingSpinner = document.getElementById('loadingSpinner');
  const buttonText = document.getElementById('buttonText');
  
  // Form submission with loading state
  form.addEventListener('submit', function(e) {
    loginBtn.disabled = true;
    loadingSpinner.style.display = 'inline-block';
    buttonText.textContent = 'Signing In...';
  });
  
  // Input focus effects
  const inputs = document.querySelectorAll('.form-input');
  inputs.forEach(input => {
    input.addEventListener('focus', function() {
      // Use .closest() for more robust targeting of the parent container
      this.closest('.input-container').style.transform = 'scale(1.02)';
    });
    
    input.addEventListener('blur', function() {
      this.closest('.input-container').style.transform = 'scale(1)';
    });
  });
  
  // Real-time validation feedback
  const emailIdInput = document.querySelector('input[name="emailId"]'); // Select by name now
  const passwordInput = document.getElementById('password');
  
  emailIdInput.addEventListener('input', function() {
    if (this.value.length > 0) {
      this.style.borderColor = 'var(--success-color)';
    } else {
      this.style.borderColor = 'var(--border-color)';
    }
  });
  
  passwordInput.addEventListener('input', function() {
    if (this.value.length >= 6) { // Assuming a minimum password length of 6 for "success"
      this.style.borderColor = 'var(--success-color)';
    } else if (this.value.length > 0) {
      this.style.borderColor = 'var(--error-color)';
    } else {
      this.style.borderColor = 'var(--border-color)';
    }
  });
});
</script>

</body>
</html>