<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Medical Insurance</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f4f8fb;
            margin: 0;
            padding: 0;
        }
        header {
            background-color: #007BFF;
            color: white;
            padding: 20px;
            text-align: center;
        }
        nav {
            background-color: #0056b3;
            padding: 10px;
            text-align: center;
        }
        nav a {
            color: #ffffff;
            margin: 0 15px;
            text-decoration: none;
            font-weight: bold;
        }
        nav a:hover {
            text-decoration: underline;
        }
        .container {
            max-width: 800px;
            margin: 30px auto;
            padding: 20px;
        }
        .link-box {
            background-color: #ffffff;
            margin: 15px 0;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 3px 6px rgba(0,0,0,0.1);
            transition: 0.3s ease;
        }
        .link-box a {
            display: inline-block;
            color: #007BFF;
            text-decoration: none;
            font-size: 16px;
            font-weight: bold;
        }
        .link-box:hover {
            background-color: #e9f0fb;
        }
    </style>
</head>
<body>
    <header>
        <h1>Medical Insurance Dashboard</h1>
    </header>
    <nav>
        <a href="home">Home</a>
        <a href="logout">Logout</a>
    </nav>
    <div class="container">
        <h2>Welcome to the Medical Insurance Portal</h2>
        <div class="link-box">
            <a href="newInsurance">🛒 Buy Insurance</a>
        </div>
        <div class="link-box">
            <a href="claimInsuranceForm">📄 Claim Insurance</a>
        </div>
        <div class="link-box">
            <a href="viewInsurance">📑 View Insurance Policies</a>
        </div>
    </div>
</body>
</html>
